/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.methodmatcher;

import com.wily.diagnos.cmp.log.CompilerLogDetails;
import com.wily.diagnos.cmp.log.CompilerLogDetailsSession;
import com.wily.diagnos.cmp.methodmatcher.IMethodMatcher;
import com.wily.util.classfile.ClassFileUtilities;
import com.wily.util.classfile.IMethodName;
import com.wily.util.classfile.IModeledMethod;

public final class NamedMethodMatcher
implements IMethodMatcher {
    private final IMethodName fName;

    public NamedMethodMatcher(IMethodName name) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.fName = name;
    }

    public boolean IMethodMatcher_matches(IModeledMethod method) {
        boolean result = ClassFileUtilities.looselyMatches(this.fName, method.getMethodName());
        if (result) {
            CompilerLogDetails current = CompilerLogDetailsSession.getCurrent();
            current.setSkipCause(131072);
            current.setMethodMatchName(this.fName);
        }
        return result;
    }

    public IMethodName getMethodName() {
        return this.fName;
    }

    public String toString() {
        return "[NamedMethodMatcher: method=" + this.fName + "]";
    }

    public boolean equals(Object o) {
        if (o instanceof NamedMethodMatcher) {
            NamedMethodMatcher matcher = (NamedMethodMatcher)o;
            return this.fName.equals(matcher.fName);
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

