/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.transform;

import com.wily.diagnos.cmp.directives.DGCompilerSettings;
import com.wily.diagnos.cmp.log.ICompilerLog;
import com.wily.diagnos.cmp.mutate.IClassMutator;
import com.wily.diagnos.cmp.mutate.IMethodMutator;
import com.wily.diagnos.cmp.mutate.IMutation;
import com.wily.diagnos.cmp.transform.ITransformation;
import com.wily.util.classfile.IModeledClass;
import com.wily.util.classfile.IModeledMethod;
import com.wily.wilyassert.Assertion;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class AClassAndEveryMethodTransformation
implements ITransformation {
    private final ICompilerLog fLog;

    protected AClassAndEveryMethodTransformation(ICompilerLog log) {
        this.fLog = log;
    }

    protected final ICompilerLog getLog() {
        return this.fLog;
    }

    protected abstract boolean doShouldProcessClass(DGCompilerSettings var1, IModeledClass var2);

    protected abstract boolean doShouldMutateClass(DGCompilerSettings var1, IModeledClass var2);

    protected abstract boolean doShouldMutateMethod(DGCompilerSettings var1, IModeledMethod var2);

    protected abstract IMutation doGenerateClassMutation(DGCompilerSettings var1, IClassMutator var2, IModeledClass var3);

    protected abstract IMutation doGenerateMethodMutation(DGCompilerSettings var1, IMethodMutator var2, IModeledMethod var3);

    private boolean shouldProcessClass(DGCompilerSettings settings, IModeledClass targetClass) {
        return this.doShouldProcessClass(settings, targetClass);
    }

    private boolean shouldMutateClass(DGCompilerSettings settings, IModeledClass targetClass) {
        return this.doShouldMutateClass(settings, targetClass);
    }

    private IMutation generateClassMutation(DGCompilerSettings settings, IClassMutator mutator, IModeledClass targetClass) {
        return this.doGenerateClassMutation(settings, mutator, targetClass);
    }

    private boolean shouldMutateMethod(DGCompilerSettings settings, IModeledMethod targetMethod) {
        return this.doShouldMutateMethod(settings, targetMethod);
    }

    private IMutation generateMethodMutation(DGCompilerSettings settings, IMethodMutator mutator, IModeledMethod targetMethod) {
        return this.doGenerateMethodMutation(settings, mutator, targetMethod);
    }

    public final IMutation[] generateMutations(DGCompilerSettings settings, IModeledClass targetClass, IClassMutator mutator) {
        if (this.shouldProcessClass(settings, targetClass)) {
            ArrayList<IMutation> mutations = new ArrayList<IMutation>();
            if (this.shouldMutateClass(settings, targetClass)) {
                IMutation mutation = this.generateClassMutation(settings, mutator, targetClass);
                mutations.add(mutation);
            }
            Iterator methods = targetClass.getAllDeclaredMethods();
            while (methods.hasNext()) {
                IModeledMethod method = (IModeledMethod)methods.next();
                if (!this.shouldMutateMethod(settings, method)) continue;
                IMutation mutation = this.generateMethodMutation(settings, mutator, method);
                mutations.add(mutation);
            }
            return mutations.toArray(IMutation.kZeroLengthArray);
        }
        return IMutation.kZeroLengthArray;
    }

    public final IMutation[] generateMutations(DGCompilerSettings settings, IModeledMethod targetMethod, IMethodMutator mutator) {
        if (this.shouldProcessClass(settings, targetMethod.getModeledClass())) {
            ArrayList<IMutation> mutations = new ArrayList<IMutation>();
            Assertion.wilyAssert(false);
            if (this.shouldMutateMethod(settings, targetMethod)) {
                IMutation mutation = this.generateMethodMutation(settings, mutator, targetMethod);
                mutations.add(mutation);
            }
            return mutations.toArray(IMutation.kZeroLengthArray);
        }
        return IMutation.kZeroLengthArray;
    }
}

