/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.personality.java.classfile.attributes;

import com.wily.diagnos.cmp.classfile.DGClassLoadingException;
import com.wily.diagnos.cmp.classfile.DGClassModificationException;
import com.wily.diagnos.cmp.log.ICompilerLog;
import com.wily.diagnos.personality.java.classfile.attributes.DGCode;
import com.wily.diagnos.personality.java.classfile.attributes.DGExceptionsAttribute;
import com.wily.diagnos.personality.java.classfile.attributes.DGLineNumberTable;
import com.wily.diagnos.personality.java.classfile.attributes.DGStackMapTable;
import com.wily.diagnos.personality.java.classfile.attributes.DGWilyAttribute;
import com.wily.diagnos.personality.java.classfile.attributes.annotations.DGAnnotationDefaultAttribute;
import com.wily.diagnos.personality.java.classfile.attributes.annotations.DGRuntimeAnnotationAttribute;
import com.wily.diagnos.personality.java.classfile.attributes.annotations.DGRuntimeParameterAnnotationAttribute;
import com.wily.diagnos.personality.java.classfile.constants.DGConstantPool;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class DGAttribute {
    protected byte[] fAttribData;
    protected int fCPI_name;
    private String fName;

    protected DGAttribute(int nameIndex, String name, byte[] data) {
        this.fCPI_name = nameIndex;
        this.fAttribData = data;
        this.fName = name;
    }

    public static DGAttribute createAttribute(DGConstantPool constantPool, DataInputStream in, ICompilerLog log) throws DGClassLoadingException, IOException {
        int cpi_name = in.readUnsignedShort();
        constantPool.validateType(cpi_name, 1);
        String attributeName = constantPool.getUtf(cpi_name);
        int dataSize = in.readInt();
        byte[] data = new byte[dataSize];
        in.readFully(data);
        DGAttribute attribute = attributeName.equals("Code") ? new DGCode(constantPool, cpi_name, attributeName, data, log) : (attributeName.equals("Exceptions") ? new DGExceptionsAttribute(constantPool, cpi_name, attributeName, data) : (attributeName.equals("LineNumberTable") ? new DGLineNumberTable(cpi_name, attributeName, data) : (attributeName.equals("com.wilytech.WilyAttribute") ? new DGWilyAttribute(constantPool, cpi_name, attributeName, data) : (attributeName.equals("RuntimeVisibleAnnotations") ? new DGRuntimeAnnotationAttribute(constantPool, cpi_name, attributeName, data) : (attributeName.equals("RuntimeInvisibleAnnotations") ? new DGRuntimeAnnotationAttribute(constantPool, cpi_name, attributeName, data) : (attributeName.equals("RuntimeVisibleParameterAnnotations") ? new DGRuntimeParameterAnnotationAttribute(constantPool, cpi_name, attributeName, data) : (attributeName.equals("RuntimeVisibleParameterAnnotations") ? new DGRuntimeParameterAnnotationAttribute(constantPool, cpi_name, attributeName, data) : (attributeName.equals("AnnotationDefault") ? new DGAnnotationDefaultAttribute(constantPool, cpi_name, attributeName, data) : (attributeName.equals("StackMapTable") ? new DGStackMapTable(constantPool, cpi_name, attributeName, data) : new DGAttribute(cpi_name, attributeName, data))))))))));
        return attribute;
    }

    public void adjustConstantPoolIndices(int base, int delta) throws DGClassModificationException {
        if (this.fCPI_name > base) {
            this.fCPI_name += delta;
        }
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeShort(this.fCPI_name);
        out.writeInt(this.fAttribData.length);
        out.write(this.fAttribData);
    }

    public int getLength() {
        return this.fAttribData.length + 6;
    }

    public String getName() {
        return this.fName;
    }
}

