/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.errors;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.errors.ErrorSnapshotFeatureFactory;
import com.wily.introscope.agent.errors.Log;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.trace.ASingleMetricTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.spec.metric.ESEException;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;

public class MethodThrewErrorReportingTracer
extends ASingleMetricTracerFactory {
    public MethodThrewErrorReportingTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    public final void ITracer_startTrace(int tracerIndex, InvocationData data) {
    }

    protected final IDataAccumulator createDataAccumulator(String formattedMetricName) {
        return null;
    }

    public final void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        if (data.hasInvocationThrownException()) {
            if (Log.out.isDebugEnabled()) {
                ProbeIdentification probe = data.getProbeInformation().getProbeIdentification();
                Log.out.debug("ExceptionErrorReporter: " + probe.getRuntimeFullClassName() + "." + probe.getProbeMethodName() + " threw an exception");
            }
            Throwable error = data.getInvocationThrownException();
            String component = this.formatParameterizedResource(data);
            String errorMessage = String.valueOf(component) + ": " + error.getClass().getName() + ": " + error.getMessage();
            if (ErrorSnapshotFeatureFactory.flagErrorInManagedApplication(errorMessage)) {
                try {
                    String name = this.formatParameterizedName(data);
                    if (name != null) {
                        this.getAgent().IAgent_getComponentTracer().noteBoundaryError();
                        this.getDataAccumulatorFactory().getLongIntervalCounterDataAccumulator(name).ILongIntervalCounterDataAccumulator_addSingleIncident();
                    } else {
                        ProbeIdentification probe = data.getProbeInformation().getProbeIdentification();
                        Log.out.debug("ExceptionErrorReporter: " + probe.getRuntimeFullClassName() + "." + probe.getProbeMethodName() + " failed to format metric name.");
                    }
                }
                catch (ESEException eSEException) {
                    Assertion.wilyFail("Metric type conflict");
                }
            }
        }
    }
}

