/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.recording;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.recording.IMetricRecordingListener;
import com.wily.introscope.agent.recording.IMetricShutoffService;
import com.wily.introscope.agent.recording.IRemoveMetricDataListener;
import com.wily.introscope.agent.recording.MetricExclusionFilter;
import com.wily.introscope.agent.recording.MetricRecordingTracker;
import com.wily.introscope.agent.recording.TimesliceMetricSnapshot;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.introscope.spec.server.MetricNameUtils;
import com.wily.introscope.stat.gatherer.BlameHandlingGatherer;
import com.wily.introscope.stat.gatherer.GathererFactory;
import com.wily.util.WilyUtilities;
import com.wily.util.clock.MasterClock;
import com.wily.util.task.ASimpleExecutableItem;
import com.wily.util.task.IExecutionQueue;
import com.wily.wilyassert.Assertion;
import com.wily.wilyassert.AssertionFailureException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;

public final class MetricRecordingAdministrator
implements IRemoveMetricDataListener {
    private static final AgentMetric[] kEmptyMetricArray = new AgentMetric[0];
    private final Hashtable fMetricRecordingTrackers = new Hashtable();
    private final Vector fMetrics = new Vector();
    private final Vector fActiveConstantDataAccumulators = new Vector();
    private final Vector fActiveNonConstantDataAccumulators = new Vector();
    private final Vector fNewlyActiveConstantDataAccumulators = new Vector();
    private final Vector fNewMetrics = new Vector();
    private final Vector fDeadMetrics = new Vector();
    private final IExecutionQueue fNotificationQueue;
    private boolean fGlobalShutOff;
    private final IMetricShutoffService fShutoffService;
    private int fMetricIterator;
    private Map[] fMetricGroups;
    private volatile OneUseTimestamp fUpdateTimestamp;
    private static final int kPowerOfTwoForMapCount = 8;
    private static final int kMetricGroupMapCount = (int)Math.pow(2.0, 8.0);
    private static final int kMask = kMetricGroupMapCount - 1;

    public MetricRecordingAdministrator(IMetricShutoffService shutoffService, IExecutionQueue notificationQueue) {
        this.fNotificationQueue = notificationQueue;
        this.fShutoffService = shutoffService;
        this.fGlobalShutOff = false;
        this.fMetricIterator = 0;
        this.fUpdateTimestamp = new OneUseTimestamp(System.currentTimeMillis());
        this.fMetricGroups = new HashMap[kMetricGroupMapCount];
        int i = 0;
        while (i < kMetricGroupMapCount) {
            this.fMetricGroups[i] = new HashMap();
            ++i;
        }
    }

    private IExecutionQueue getNotificationQueue() {
        return this.fNotificationQueue;
    }

    public synchronized void trackMetric(AgentMetric metric, IDataAccumulator accumulator) {
        Assertion.wilyAssert(false);
        Assertion.wilyAssert(false);
        if (metric != null && metric != AgentMetric.kNullAgentMetric) {
            this.fNewMetrics.addElement(metric);
            this.fDeadMetrics.removeElement(metric);
            if (accumulator != null) {
                MetricRecordingTracker tracker = this.getTrackerForMetric(metric);
                Assertion.wilyAssert(false);
                if (tracker != null) {
                    this.untrackMetric(metric);
                }
                tracker = this.createRecordingTrackerForMetric(metric, accumulator);
                this.addAccumulatorIfActive(tracker);
            }
        } else {
            throw new AssertionFailureException();
        }
    }

    public synchronized void trackMetricOnSharedElement(AgentMetric metric, IDataAccumulator accumulator) {
        Assertion.wilyAssert(false);
        Assertion.wilyAssert(false);
        if (metric != null && metric != AgentMetric.kNullAgentMetric) {
            this.fNewMetrics.addElement(metric);
            this.fDeadMetrics.removeElement(metric);
            if (accumulator != null) {
                MetricRecordingTracker tracker = this.getTrackerForMetric(metric);
                Assertion.wilyAssert(false);
                if (tracker != null) {
                    this.untrackMetric(metric);
                }
                tracker = this.createRecordingTrackerForMetricOnSharedElement(metric, accumulator);
                this.addAccumulatorIfActive(tracker);
            }
        } else {
            throw new AssertionFailureException();
        }
    }

    public synchronized void untrackMetric(AgentMetric metric) {
        this.fDeadMetrics.addElement(metric);
        MetricRecordingTracker tracker = (MetricRecordingTracker)this.fMetricRecordingTrackers.remove(metric);
        this.fMetrics.remove(metric);
        if (tracker != null) {
            this.removeAccumulatorIfActive(tracker);
            tracker.notifyListenersOfAgedMetric();
            tracker.removeAllListeners();
        }
    }

    public boolean isMetricShutOff(AgentMetric metric) {
        Assertion.wilyAssert(false);
        MetricRecordingTracker tracker = this.getTrackerForMetric(metric);
        if (tracker != null) {
            return tracker.isMetricShutOff();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGlobalShutOff(boolean isShutOff) {
        Enumeration trackersSnapshot = null;
        boolean globalShutOffSnapshot = false;
        MetricRecordingAdministrator metricRecordingAdministrator = this;
        synchronized (metricRecordingAdministrator) {
            if (isShutOff != this.fGlobalShutOff) {
                this.fGlobalShutOff = isShutOff;
                trackersSnapshot = ((Hashtable)this.fMetricRecordingTrackers.clone()).elements();
                globalShutOffSnapshot = this.fGlobalShutOff;
            }
        }
        if (trackersSnapshot != null) {
            while (trackersSnapshot.hasMoreElements()) {
                MetricRecordingTracker tracker = (MetricRecordingTracker)trackersSnapshot.nextElement();
                if (globalShutOffSnapshot) {
                    if (!tracker.shutGlobalToggleOff()) continue;
                    this.deactivateAccumulator(tracker.getDataAccumulator());
                    continue;
                }
                if (!tracker.turnGlobalToggleOn()) continue;
                this.activateAccumulator(tracker.getDataAccumulator());
            }
        }
    }

    public synchronized boolean getGlobalShutOff() {
        return this.fGlobalShutOff;
    }

    public synchronized void turnOnAllToggles() {
        Enumeration trackers = this.fMetricRecordingTrackers.elements();
        while (trackers.hasMoreElements()) {
            MetricRecordingTracker tracker = (MetricRecordingTracker)trackers.nextElement();
            if (!tracker.turnMetricOn()) continue;
            this.activateAccumulator(tracker.getDataAccumulator());
        }
    }

    public synchronized void turnMetricOn(AgentMetric metric) {
        Assertion.wilyAssert(false);
        MetricRecordingTracker tracker = this.getTrackerForMetric(metric);
        if (tracker != null && tracker.turnMetricOn()) {
            this.activateAccumulator(tracker.getDataAccumulator());
        }
    }

    public synchronized void shutMetricOff(AgentMetric metric) {
        Assertion.wilyAssert(false);
        MetricRecordingTracker tracker = this.getTrackerForMetric(metric);
        if (tracker != null && tracker.shutMetricOff()) {
            this.deactivateAccumulator(tracker.getDataAccumulator());
        }
    }

    private void addAccumulatorIfActive(MetricRecordingTracker tracker) {
        if (!tracker.isMetricShutOff()) {
            this.addAccumulator(tracker.getDataAccumulator());
        }
    }

    private void removeAccumulatorIfActive(MetricRecordingTracker tracker) {
        if (!tracker.isMetricShutOff()) {
            this.removeAccumulator(tracker.getDataAccumulator());
        }
    }

    private void activateAccumulator(IDataAccumulator accumulator) {
        accumulator.IDataAccumulator_getGatherer().IGatherer_reset(MasterClock.currentTimeMillis());
        this.addAccumulator(accumulator);
    }

    private void deactivateAccumulator(IDataAccumulator accumulator) {
        this.removeAccumulator(accumulator);
        accumulator.IDataAccumulator_getGatherer().IGatherer_reset(MasterClock.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAccumulator(IDataAccumulator accumulator) {
        if (accumulator.IDataAccumulator_isConstant()) {
            Vector vector = this.fNewlyActiveConstantDataAccumulators;
            synchronized (vector) {
                this.fNewlyActiveConstantDataAccumulators.addElement(accumulator);
            }
            this.fActiveConstantDataAccumulators.addElement(accumulator);
        } else {
            this.fActiveNonConstantDataAccumulators.addElement(accumulator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAccumulator(IDataAccumulator accumulator) {
        if (accumulator.IDataAccumulator_isConstant()) {
            Vector vector = this.fNewlyActiveConstantDataAccumulators;
            synchronized (vector) {
                this.fNewlyActiveConstantDataAccumulators.removeElement(accumulator);
            }
            this.fActiveConstantDataAccumulators.removeElement(accumulator);
        } else {
            this.fActiveNonConstantDataAccumulators.removeElement(accumulator);
        }
    }

    public void addMetricRecordingListenerWithRewind(AgentMetric metric, IMetricRecordingListener listener) {
        Assertion.wilyAssert(false);
        Assertion.wilyAssert(false);
        MetricRecordingTracker tracker = this.getTrackerForMetric(metric);
        Assertion.wilyAssert(false);
        if (tracker != null && listener != null) {
            tracker.addMetricRecordingListenerWithRewind(listener);
        }
    }

    public void removeMetricRecordingListener(AgentMetric metric, IMetricRecordingListener listener) {
        Assertion.wilyAssert(false);
        Assertion.wilyAssert(false);
        MetricRecordingTracker tracker = this.getTrackerForMetric(metric);
        Assertion.wilyAssert(false);
        if (tracker != null && listener != null) {
            tracker.removeMetricRecordingListener(listener);
        }
    }

    public synchronized TimesliceMetricSnapshot getTimesliceMetricSnapshot(boolean firstTimeslice) {
        return new TimesliceMetricSnapshot(this.getAndClearNewMetrics(firstTimeslice), this.getAccumulatorsToHarvest(firstTimeslice), this.getAndClearDeadMetrics(firstTimeslice));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector getAccumulatorsToHarvest(boolean firstTimeslice) {
        Vector result;
        Vector vector = this.fNewlyActiveConstantDataAccumulators;
        synchronized (vector) {
            result = firstTimeslice ? WilyUtilities.combineVectorContents(this.fActiveConstantDataAccumulators, this.fActiveNonConstantDataAccumulators) : WilyUtilities.combineVectorContents(this.fNewlyActiveConstantDataAccumulators, this.fActiveNonConstantDataAccumulators);
            this.fNewlyActiveConstantDataAccumulators.removeAllElements();
        }
        return result;
    }

    private AgentMetric[] getAndClearNewMetrics(boolean firstTimeslice) {
        if (firstTimeslice) {
            this.fNewMetrics.removeAllElements();
            return this.getAllMetrics();
        }
        return this.copyAndClearContentsOfMetricVector(this.fNewMetrics);
    }

    private AgentMetric[] getAndClearDeadMetrics(boolean firstTimeslice) {
        if (firstTimeslice) {
            this.fDeadMetrics.removeAllElements();
            return kEmptyMetricArray;
        }
        return this.copyAndClearContentsOfMetricVector(this.fDeadMetrics);
    }

    private AgentMetric[] getAllMetrics() {
        AgentMetric[] metrics = new AgentMetric[this.fMetricRecordingTrackers.size()];
        Enumeration hashKeys = this.fMetricRecordingTrackers.keys();
        int index = 0;
        while (hashKeys.hasMoreElements()) {
            metrics[index++] = (AgentMetric)hashKeys.nextElement();
        }
        return metrics;
    }

    private LinkedList getAllMetrics(int metricCount) {
        int metricEndIterator;
        LinkedList<AgentMetric> metrics = new LinkedList<AgentMetric>();
        int metricSize = this.fMetrics.size();
        if (metricCount >= metricSize) {
            this.fMetricIterator = 0;
            metricEndIterator = metricSize;
        } else {
            if (this.fMetricIterator >= metricSize) {
                this.fMetricIterator = 0;
            }
            metricEndIterator = this.fMetricIterator + metricCount >= metricSize ? metricSize : this.fMetricIterator + metricCount;
        }
        try {
            int i = this.fMetricIterator;
            while (i < metricEndIterator) {
                if (i < this.fMetrics.size() && this.fMetrics.get(i) != null) {
                    metrics.add((AgentMetric)this.fMetrics.get(i));
                    ++this.fMetricIterator;
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            metrics = null;
            this.fMetricIterator = 0;
        }
        return metrics;
    }

    private AgentMetric[] copyAndClearContentsOfMetricVector(Vector metrics) {
        int size = metrics.size();
        if (size > 0) {
            Object[] metricsArray = new AgentMetric[size];
            metrics.copyInto(metricsArray);
            metrics.removeAllElements();
            return metricsArray;
        }
        return kEmptyMetricArray;
    }

    public int getMetricCount() {
        return this.fMetricRecordingTrackers.size();
    }

    public IDataAccumulator getDataAccumulator(AgentMetric metric) {
        Assertion.wilyAssert(false);
        MetricRecordingTracker tracker = this.getTrackerForMetric(metric);
        if (tracker != null) {
            return tracker.getDataAccumulator();
        }
        return null;
    }

    private MetricRecordingTracker getTrackerForMetric(AgentMetric metric) {
        if (metric == null) {
            return null;
        }
        return (MetricRecordingTracker)this.fMetricRecordingTrackers.get(metric);
    }

    private MetricRecordingTracker createRecordingTrackerForMetric(AgentMetric metric, IDataAccumulator accumulator) {
        Assertion.wilyAssert(false);
        MetricRecordingTracker tracker = new MetricRecordingTracker(this, metric, this.fGlobalShutOff, false, accumulator);
        this.fMetricRecordingTrackers.put(metric, tracker);
        this.fMetrics.add(metric);
        return tracker;
    }

    private MetricRecordingTracker createRecordingTrackerForMetricOnSharedElement(AgentMetric metric, IDataAccumulator accumulator) {
        MetricRecordingTracker result = this.createRecordingTrackerForMetric(metric, accumulator);
        result.setBasedOnSharedElement(true);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCalledBackendMetrics(String metricNameResource) {
        Map blameStackSnapshotMap;
        Map map = blameStackSnapshotMap = GathererFactory.getBlameStackSnapshotCache(metricNameResource);
        synchronized (map) {
            ArrayList gatherers = (ArrayList)blameStackSnapshotMap.get(metricNameResource);
            if (gatherers != null) {
                for (BlameHandlingGatherer gatherer : gatherers) {
                    gatherer.removeGatherer(metricNameResource);
                    AgentMetric calledBackendAgentMetric = MetricNameUtils.createTemporaryCalledBackendMetric(gatherer, metricNameResource);
                    this.untrackMetric(calledBackendAgentMetric);
                }
                blameStackSnapshotMap.remove(metricNameResource);
            }
        }
    }

    void notifyListenerOfShutOffMetric(IMetricRecordingListener listener, AgentMetric metric) {
        this.getNotificationQueue().IExecutionQueue_addExecutableItem(new MetricShutOffNotificationItem(listener, metric));
    }

    void notifyListenerOfTurnedOnMetric(IMetricRecordingListener listener, AgentMetric metric) {
        this.getNotificationQueue().IExecutionQueue_addExecutableItem(new MetricTurnedOnNotificationItem(listener, metric));
    }

    public void setShutOffState(AgentMetric metric, boolean isShutOff) {
        this.fShutoffService.setMetricShutoffState(metric, isShutOff);
    }

    private void removeMetricBasedOnSharedElement(AgentMetric metric, IDataAccumulator accumulator) {
        this.untrackMetric(metric);
        metric.remove();
        accumulator.setRemoval();
    }

    public void removeMetricData(int dataChunk, MetricExclusionFilter metricExclusionFilter, int timeslices) {
        int errorCount = 0;
        boolean metricsRemoved = false;
        int numberOfMetricsRemoved = 0;
        AgentMetric currentMetric = null;
        LinkedList agentMetrics = this.getAllMetrics(dataChunk);
        if (agentMetrics == null) {
            return;
        }
        try {
            if (errorCount > 10) {
                return;
            }
            Iterator agentMetricsIterator = agentMetrics.iterator();
            String metricNameResource = null;
            while (agentMetricsIterator.hasNext()) {
                IDataAccumulator dataAccumulator;
                MetricRecordingTracker tracker;
                boolean metricGroupExists = false;
                currentMetric = (AgentMetric)agentMetricsIterator.next();
                String metricURL = currentMetric.getAttributeURL();
                if (!metricExclusionFilter.isOK(metricURL)) continue;
                metricNameResource = currentMetric.getAgentMetricPrefix().getPathURL();
                if (currentMetric == null || (tracker = this.getTrackerForMetric(currentMetric)) == null || (dataAccumulator = tracker.getDataAccumulator()).IDataAccumulator_hasNewData(timeslices)) continue;
                Collection metricGroup = this.getMetricGroup(metricNameResource);
                if (metricGroup != null) {
                    boolean allMetricsPass = false;
                    for (AgentMetric metricIndex : metricGroup) {
                        IDataAccumulator dataAccumulatorForMetricInGroup;
                        MetricRecordingTracker trackerForMetricInGroup;
                        if (metricIndex == null) break;
                        if (!metricExclusionFilter.isOK(metricIndex.getAttributeURL())) {
                            allMetricsPass = true;
                        }
                        if ((trackerForMetricInGroup = this.getTrackerForMetric(metricIndex)) != null && (dataAccumulatorForMetricInGroup = trackerForMetricInGroup.getDataAccumulator()) != null && dataAccumulatorForMetricInGroup.IDataAccumulator_hasNewData(timeslices)) {
                            allMetricsPass = true;
                        }
                        if (!metricIndex.getAttributeURL().equals(currentMetric.getAttributeURL())) continue;
                        metricGroupExists = true;
                    }
                    if (!allMetricsPass && metricGroupExists) {
                        if (tracker.isBasedOnSharedElement()) {
                            for (AgentMetric metricToBeRemoved : metricGroup) {
                                IDataAccumulator dataAccumulatorToBeRemoved;
                                MetricRecordingTracker trackerToBeRemoved = this.getTrackerForMetric(metricToBeRemoved);
                                if (trackerToBeRemoved == null || (dataAccumulatorToBeRemoved = trackerToBeRemoved.getDataAccumulator()) == null) continue;
                                this.removeMetricBasedOnSharedElement(metricToBeRemoved, dataAccumulatorToBeRemoved);
                                ++numberOfMetricsRemoved;
                            }
                        } else {
                            Iterator iter = metricGroup.iterator();
                            while (iter.hasNext()) {
                                ++numberOfMetricsRemoved;
                                MetricRecordingAdministrator.getAgent().IAgent_getDataAccumulatorFactory().removeMetric((AgentMetric)iter.next());
                            }
                            this.removeCalledBackendMetrics(metricNameResource);
                        }
                        metricsRemoved = true;
                        this.removeMetricGroup(metricNameResource);
                        continue;
                    }
                    if (metricGroupExists) continue;
                    if (tracker.isBasedOnSharedElement()) {
                        this.removeMetricBasedOnSharedElement(currentMetric, dataAccumulator);
                    } else {
                        MetricRecordingAdministrator.getAgent().IAgent_getDataAccumulatorFactory().removeMetric(currentMetric);
                    }
                    ++numberOfMetricsRemoved;
                    metricsRemoved = true;
                    continue;
                }
                if (tracker.isBasedOnSharedElement()) {
                    this.removeMetricBasedOnSharedElement(currentMetric, dataAccumulator);
                } else {
                    MetricRecordingAdministrator.getAgent().IAgent_getDataAccumulatorFactory().removeMetric(currentMetric);
                    this.removeCalledBackendMetrics(metricNameResource);
                }
                ++numberOfMetricsRemoved;
                metricsRemoved = true;
            }
            if (metricsRemoved) {
                MetricRecordingAdministrator.getAgent().IAgent_getDataAccumulatorFactory().updateRemovalMetricKey();
                MetricRecordingAdministrator.getAgent().IAgent_getModuleFeedback().verbose("Agent Metric Aging: number of metrics removed are " + numberOfMetricsRemoved);
            }
        }
        catch (AgentNotAvailableException agentNotAvailableException) {
            ++errorCount;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            ++errorCount;
        }
        catch (NullPointerException nullPointerException) {
            ++errorCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMetricGroup(String metricKey, Collection metrics) {
        if (metricKey != null && metrics != null) {
            Map metricGroupMap;
            HashSet metricSet = null;
            Map map = metricGroupMap = this.getMetricGroupMap(metricKey);
            synchronized (map) {
                metricSet = (HashSet)metricGroupMap.get(metricKey);
                if (metricSet == null) {
                    metricSet = new HashSet();
                    metricGroupMap.put(metricKey, metricSet);
                }
                metricSet.addAll(metrics);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getMetricGroup(String metricKey) {
        Map metricGroupMap = this.getMetricGroupMap(metricKey);
        Collection metrics = null;
        Map map = metricGroupMap;
        synchronized (map) {
            metrics = (Collection)metricGroupMap.get(metricKey);
        }
        return metrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMetricGroup(String metricKey) {
        Map metricGroupMap;
        Map map = metricGroupMap = this.getMetricGroupMap(metricKey);
        synchronized (map) {
            metricGroupMap.remove(metricKey);
        }
    }

    public boolean hasUpdatedSince(long timestamp) {
        return timestamp < this.fUpdateTimestamp.getTimestamp();
    }

    public void setUpdateTimestamp(long timestamp) {
        this.fUpdateTimestamp = new OneUseTimestamp(timestamp);
    }

    private Map getMetricGroupMap(String key) {
        int index = this.getIndex(key);
        return this.fMetricGroups[index];
    }

    private int getIndex(String key) {
        int index = key.hashCode() >> 3 & kMask;
        return index;
    }

    private static IAgent getAgent() throws AgentNotAvailableException {
        return AgentShim.getAgent();
    }

    private static abstract class AMetricNotificationItem
    extends ASimpleExecutableItem {
        private final IMetricRecordingListener fListener;
        private final AgentMetric fMetric;

        public AMetricNotificationItem(IMetricRecordingListener listener, AgentMetric metric) {
            this.fListener = listener;
            this.fMetric = metric;
        }

        protected final IMetricRecordingListener getListener() {
            return this.fListener;
        }

        protected final AgentMetric getMetric() {
            return this.fMetric;
        }
    }

    private static final class MetricShutOffNotificationItem
    extends AMetricNotificationItem {
        public MetricShutOffNotificationItem(IMetricRecordingListener listener, AgentMetric metric) {
            super(listener, metric);
        }

        public void IExecutableItem_execute() {
            this.getListener().IMetricRecordingListener_metricIsShutOff(this.getMetric());
        }
    }

    private static final class MetricTurnedOnNotificationItem
    extends AMetricNotificationItem {
        public MetricTurnedOnNotificationItem(IMetricRecordingListener listener, AgentMetric metric) {
            super(listener, metric);
        }

        public void IExecutableItem_execute() {
            this.getListener().IMetricRecordingListener_metricIsTurnedOn(this.getMetric());
        }
    }

    class OneUseTimestamp {
        private long fTimestamp;

        public OneUseTimestamp(long timestamp) {
            this.fTimestamp = timestamp;
        }

        public long getTimestamp() {
            return this.fTimestamp;
        }
    }
}

