/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.remote;

import com.wily.introscope.agent.AgentAdapter;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.remote.IRemoteAgent;
import com.wily.introscope.agent.remote.RemoteMethodTracer;
import com.wily.introscope.agent.remote.arf.ArfCommandConnection;
import com.wily.introscope.agent.remote.arf.ArfDataConnection;
import com.wily.introscope.agent.remote.arf.TCPArfTransport;
import com.wily.introscope.agent.trace.EmptyMethodTracer;
import com.wily.introscope.agent.trace.IMethodTracer;
import com.wily.introscope.agent.trace.IParameterizedMethodTracer;
import com.wily.util.adt.IAtomicNumber;
import com.wily.util.feedback.IModuleFeedbackChannel;

public class RemoteAgent
extends AgentAdapter
implements IRemoteAgent {
    private final IModuleFeedbackChannel fFeedback;
    private final ArfCommandConnection fCmdConn;
    private final ArfDataConnection fDataConn;
    private final IAtomicNumber fArfSequence;
    private final IAtomicNumber fThreadSequence;
    private final ThreadLocal fThreadId = new ThreadLocal();
    private static final IParameterizedMethodTracer sNoOpTracer = new EmptyMethodTracer();

    public RemoteAgent(IAgent delegate, String args) {
        super(delegate);
        this.fFeedback = delegate.IAgent_getModuleFeedback();
        TCPArfTransport transport = new TCPArfTransport(delegate);
        String[] agentInfo = delegate.IAgent_getHostProcessAgentTriplet();
        this.fCmdConn = transport.getCommandConnection(args, agentInfo[1], "java", "123", agentInfo[1]);
        this.fDataConn = transport.getDataConnection(args, agentInfo[1], "java", "123", agentInfo[1]);
        this.fArfSequence = delegate.IAgent_getAtomicNumberFactory().getInstance(0L);
        this.fThreadSequence = delegate.IAgent_getAtomicNumberFactory().getInstance(0L);
    }

    public IMethodTracer IAgent_loadTracer(int probeHashCode, String probeClassName, String probeMethodName, String probeMethodDescriptor, Object tracedObject, String tracerEncoding) {
        if (tracerEncoding.indexOf("BlamePointTracer") > 0) {
            RemoteMethodTracer tracer = new RemoteMethodTracer(probeHashCode, probeClassName, probeMethodName, probeMethodDescriptor, tracedObject, tracerEncoding, this);
            tracer.IMethodTracer_startTrace();
            return tracer;
        }
        return sNoOpTracer;
    }

    public IParameterizedMethodTracer IAgent_loadParameterizedTracer(int probeHashCode, String probeClassName, String probeMethodName, String probeMethodDescriptor, Object tracedObject, String tracerEncoding) {
        if (tracerEncoding.indexOf("BlamePointTracer") > 0) {
            return new RemoteMethodTracer(probeHashCode, probeClassName, probeMethodName, probeMethodDescriptor, tracedObject, tracerEncoding, this);
        }
        return sNoOpTracer;
    }

    public void IAgent_noticeEvent(String probeClassName, String probeMethodName, String probeMethodDescriptor, String eventNoticingClass, String eventType, Object eventSpecificReference, String eventSpecificData, String eventSpecificData2) {
        super.IAgent_noticeEvent(probeClassName, probeMethodName, probeMethodDescriptor, eventNoticingClass, eventType, eventSpecificReference, eventSpecificData, eventSpecificData2);
    }

    public long getNextSequence() {
        return this.fArfSequence.incrementLongAndGet();
    }

    public String getThreadId() {
        Integer id = (Integer)this.fThreadId.get();
        if (id == null) {
            id = new Integer(this.fThreadSequence.incrementIntAndGet());
            this.fThreadId.set(id);
        }
        return id.toString();
    }

    public void sendEventMessage(String msg) {
        if (this.fDataConn != null) {
            this.fDataConn.send(msg);
        }
    }
}

