/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.remote.arf;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.remote.arf.AArfConnection;
import com.wily.introscope.agent.remote.arf.ArfException;
import com.wily.introscope.agent.remote.arf.ArfMessage;

public abstract class ArfDataConnection
extends AArfConnection {
    private long fCurrentSequence = 0L;

    public ArfDataConnection(IAgent agent, String connectMessage) throws ArfException {
        super(agent, connectMessage);
        ArfMessage m = ArfMessage.parseMessage(connectMessage);
        if (m.isInstIdSet()) {
            this.fInstanceId = m.getInstId();
        }
        if (m.isProgramSet()) {
            this.fProgram = m.getProgram();
        }
        if (m.isProbeSet()) {
            this.fProbe = m.getProbe();
        }
        if (m.isPidSet()) {
            this.fPid = m.getPid();
        }
        if (m.isTidSet()) {
            this.fTid = m.getTid();
        }
        if (m.isSeqSet()) {
            this.fCurrentSequence = m.getSeq();
        }
    }

    public ArfDataConnection(IAgent agent) {
        super(agent);
    }

    protected void processMessage(ArfMessage m) {
        if (m.isSeqSet()) {
            long seq = m.getSeq();
            if (this.fCurrentSequence != 0L && seq != 0L && seq != this.fCurrentSequence + 1L && this.fListener != null) {
                this.fListener.resetConnection(this);
            }
            this.fCurrentSequence = seq;
        }
        if (this.fListener != null) {
            this.fListener.processMessage(this, m);
        }
    }

    public String toString() {
        return "ArfDataConnection " + (this.isClient() ? "Client" : "Server");
    }
}

