/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.resultsub;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.extension.ExtensionAdministrator;
import com.wily.util.extension.ExtensionUtilities;
import com.wily.util.extension.IPlugin;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class ResultSubstitutionAdministrator {
    private final IAgent agent;
    private final IModuleFeedbackChannel feed;
    private Map substituterMap;
    private static final String kResultSubstitutionType = "resultsubstituter";
    private static final String kResultSubstitutionMethod = "substituteResult";
    private static final Class[] kSignature = new Class[]{Object.class, Object.class};
    private static final Object kSentinelNullObject = new Object();
    private static final Module sModule = new Module("ResultSubstitutionAdministrator");
    private static final ThreadLocal localMaps = new ThreadLocal(){

        protected Object initialValue() {
            return new HashMap();
        }
    };

    public ResultSubstitutionAdministrator(IAgent agent) {
        this.agent = agent;
        this.feed = agent.IAgent_getModuleFeedback();
        this.substituterMap = Collections.synchronizedMap(new HashMap());
        this.loadResultSubstitutionPlugins(agent);
    }

    private void loadResultSubstitutionPlugins(IAgent agent) {
        ExtensionAdministrator eAdmin = agent.IAgent_getExtensionAdministrator();
        IPlugin[] substitutionPlugins = eAdmin.getAgentPluginsByType(kResultSubstitutionType);
        if (substitutionPlugins != null) {
            int i = 0;
            while (i < substitutionPlugins.length) {
                try {
                    Class<?> returnType;
                    Class c = ExtensionUtilities.loadEntryPointClass(this.feed, agent.IAgent_getStringLocalizer(), substitutionPlugins[i]);
                    Method m = c.getMethod(kResultSubstitutionMethod, kSignature);
                    boolean didPut = false;
                    if (m != null && Object.class.equals(returnType = m.getReturnType())) {
                        this.substituterMap.put(substitutionPlugins[i].IPlugin_getName(), m);
                        didPut = true;
                    }
                    if (!didPut) {
                        this.feed.error(sModule, "Result substitution class " + c.getName() + " does not implement the required method " + kResultSubstitutionMethod + " (must have a single java.lang.Object parameter, and must return a java.lang.Object)");
                    }
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    try {
                        this.feed.error(sModule, "An error occurred while trying to load result substituter plugin " + substitutionPlugins[i].IPlugin_getName());
                        this.feed.debug(sModule, "", t);
                    }
                    catch (ThreadDeath td2) {
                        throw td2;
                    }
                    catch (Throwable throwable) {}
                }
                ++i;
            }
        }
    }

    public final Object substituteResult(Object sampleTracedObject, Object origResult, String substituterName) {
        Object newResult = origResult;
        Method m = this.getEntry(substituterName);
        if (m == null) {
            this.feed.error(sModule, "No match for result substituter name " + substituterName);
        } else {
            try {
                Object[] args = new Object[]{sampleTracedObject, origResult};
                newResult = m.invoke(null, args);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    this.feed.error(sModule, "An error occurred in a result substitution method");
                    this.feed.debug(sModule, "", t);
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Throwable throwable) {}
            }
        }
        return newResult;
    }

    private Method getEntry(String substituterName) {
        Method result = null;
        Map tlMap = (Map)localMaps.get();
        Object m = tlMap.get(substituterName);
        if (m == null) {
            m = this.substituterMap.get(substituterName);
            if (m == null) {
                m = kSentinelNullObject;
            }
            tlMap.put(substituterName, m);
        }
        if (m != kSentinelNullObject) {
            result = (Method)m;
        }
        return result;
    }

    private void removeEntry(String substituterName) {
        Map tlMap = (Map)localMaps.get();
        tlMap.remove(substituterName);
        this.substituterMap.remove(substituterName);
    }
}

