/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.runtime.java.environment;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.recording.MetricRecordingPollerHandler;
import com.wily.introscope.agent.runtime.java.environment.GCHeapUsagePoller;
import com.wily.introscope.agent.runtime.java.environment.TimePoller;
import com.wily.introscope.agent.service.ASimpleService;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.agent.transformer.TransformerAdministrator;
import com.wily.introscope.agent.transformer.dynamic.IClassRedefinitionDelegate;
import com.wily.introscope.agent.transformer.dynamic.IDynamicInstrumentationTransformer;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.feedback.SeverityLevel;
import java.util.Map;

public final class EnvironmentStatisticsHandler
extends ASimpleService {
    private static final String kEnvironmentStatisticsServiceName = "Environment";
    private static String osName = "Unknown";
    private static String vmVendor = "Unknown";
    private static String vmVersion = "Unknown";
    private static String ipAddress = "Unknown";
    private static String jvmArch = "";
    private MetricRecordingPollerHandler fGCHandler;
    private MetricRecordingPollerHandler fTimeHandler;
    private boolean fShowJavaMetrics;

    static {
        EnvironmentStatisticsHandler.loadJvmInfo();
    }

    public EnvironmentStatisticsHandler() {
        super(kEnvironmentStatisticsServiceName);
    }

    protected void doStartService(IAgent agent, Map parameters) {
        DataAccumulatorFactory factory = agent.IAgent_getDataAccumulatorFactory();
        this.fShowJavaMetrics = agent.IAgent_getIndexedProperties().getBooleanProperty("introscope.agent.environment.java.metrics.enabled", true);
        this.initBuiltInConstantCollectors(agent, factory);
        if (this.fShowJavaMetrics) {
            this.fGCHandler = new MetricRecordingPollerHandler(agent, new GCHeapUsagePoller(factory));
        }
        this.fTimeHandler = new MetricRecordingPollerHandler(agent, new TimePoller(factory));
    }

    private static void loadJvmInfo() {
        try {
            osName = System.getProperty("os.name");
        }
        catch (Throwable throwable) {}
        try {
            vmVendor = System.getProperty("java.vendor");
        }
        catch (Throwable throwable) {}
        try {
            jvmArch = System.getProperty("sun.arch.data.model");
            if (jvmArch == null && (jvmArch = System.getProperty("com.ibm.vm.bitmode")) == null) {
                jvmArch = "";
            }
            vmVersion = System.getProperty("java.version");
            if (jvmArch != null && jvmArch.length() > 0) {
                vmVersion = String.valueOf(vmVersion) + " " + "( " + jvmArch + " bit )";
            }
        }
        catch (Throwable throwable) {}
    }

    public static String getOsName() {
        return osName;
    }

    public static String getVmVendor() {
        return vmVendor;
    }

    public static String getVmVersion() {
        return vmVersion;
    }

    public static String getJvmArch() {
        return jvmArch;
    }

    private void initBuiltInConstantCollectors(IAgent agent, DataAccumulatorFactory factory) {
        try {
            ipAddress = agent.IAgent_getEnvironmentAdministrator().getIPAddress();
        }
        catch (Throwable throwable) {}
        this.doIBM15JVMCheck(agent, factory, vmVendor, vmVersion);
        factory.safeGetStringConstantDataAccumulator("Host:Operating System", osName);
        factory.safeGetStringConstantDataAccumulator("Host:IP Address", ipAddress);
        if (this.fShowJavaMetrics) {
            factory.safeGetStringConstantDataAccumulator("Virtual Machine", vmVendor);
            factory.safeGetStringConstantDataAccumulator("Java Version", vmVersion);
        }
    }

    private void doIBM15JVMCheck(IAgent agent, DataAccumulatorFactory factory, String vmVendor, String vmVersion) {
        IClassRedefinitionDelegate classRedefinitionDelegate;
        IDynamicInstrumentationTransformer iService;
        TransformerAdministrator transformerAdmin;
        if (vmVendor.startsWith("IBM") && vmVersion.startsWith("1.5") && (transformerAdmin = agent.IAgent_getTransformerAdministrator()) != null && (iService = transformerAdmin.getDynamicInstrumentationTransformer()) != null && (classRedefinitionDelegate = iService.getClassRedefinitionDelegate()) != null) {
            SeverityLevel level;
            boolean agentClassRedefinition = classRedefinitionDelegate.isClassRedefinitionEnabled();
            String agentClassRedefinitionStr = Boolean.toString(agentClassRedefinition);
            factory.safeGetStringConstantDataAccumulator("Agent Class Redefinition Enabled", agentClassRedefinitionStr);
            IModuleFeedbackChannel feedback = agent.IAgent_getModuleFeedback();
            Module module = agent.IAgent_getModule();
            SeverityLevel severityLevel = level = agentClassRedefinition ? SeverityLevel.WARN : SeverityLevel.INFO;
            if (feedback.isLogEnabled(level, module)) {
                feedback.log(level, module, agent.IAgent_getStringLocalizer().IStringLocalizer_getLocalizedString(agentClassRedefinition ? "Agent_Class_Redefinition_Enabled_Message" : "Agent_Class_Redefinition_Disabled_Message"));
            }
        }
    }
}

