/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.runtime.java.environment;

import com.wily.introscope.agent.poll.IMetricRecordingAwareDataPoller;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.agent.stat.ILongFluctuatingCounterDataAccumulator;
import com.wily.introscope.spec.metric.AgentMetric;

public final class GCHeapUsagePoller
implements IMetricRecordingAwareDataPoller {
    private final ILongFluctuatingCounterDataAccumulator fGCHeapTotalBytes;
    private final ILongFluctuatingCounterDataAccumulator fGCHeapInUseBytes;
    private final Runtime fRuntime;

    public GCHeapUsagePoller(DataAccumulatorFactory factory) {
        this.fGCHeapTotalBytes = factory.safeGetLongFluctuatingCounterDataAccumulator("GC Heap:Bytes Total");
        this.fGCHeapInUseBytes = factory.safeGetLongFluctuatingCounterDataAccumulator("GC Heap:Bytes In Use");
        this.fRuntime = Runtime.getRuntime();
    }

    public AgentMetric[] IMetricRecordingAwareDataPoller_getMetrics() {
        return new AgentMetric[]{this.fGCHeapTotalBytes.IDataAccumulator_getMetric(), this.fGCHeapInUseBytes.IDataAccumulator_getMetric()};
    }

    public void IMetricRecordingAwareDataPoller_resetPoller() {
    }

    public void ITimestampedRunnable_execute(long nowInMillis) {
        long longTotalMem = this.fRuntime.totalMemory();
        long longFreeMem = this.fRuntime.freeMemory();
        long longUsedMem = longTotalMem - longFreeMem;
        if (this.fGCHeapInUseBytes != null) {
            this.fGCHeapInUseBytes.ILongCounterDataAccumulator_setValue(longUsedMem);
        }
        if (this.fGCHeapTotalBytes != null) {
            this.fGCHeapTotalBytes.ILongCounterDataAccumulator_setValue(longTotalMem);
        }
    }
}

