/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.sustainability;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.extension.OptionalExtensionsIncludeConfiguration;
import com.wily.introscope.agent.service.ASimpleService;
import com.wily.introscope.agent.stat.ILongFluctuatingCounterDataAccumulator;
import com.wily.introscope.agent.stat.ILongIntervalCounterDataAccumulator;
import com.wily.introscope.agent.stat.IStringEveryEventDataAccumulator;
import com.wily.introscope.agent.sustainability.ISustainabilityReportLogger;
import com.wily.introscope.agent.sustainability.ISustainabilityService;
import com.wily.introscope.agent.sustainability.ISustainabilityServiceTrace;
import com.wily.introscope.agent.sustainability.ProbeInfoOverheadInfo;
import com.wily.introscope.agent.sustainability.SustainabilityReportEntry;
import com.wily.introscope.agent.sustainability.SustainabilityReportLogger;
import com.wily.introscope.agent.sustainability.SustainabilityServiceTrace;
import com.wily.introscope.agent.trace.ProbeInformation;
import com.wily.introscope.agent.transformer.dynamic.AInstrumentationHelper;
import com.wily.introscope.agent.transformer.dynamic.IDirectiveLoadListener;
import com.wily.introscope.agent.transformer.dynamic.IDynamicInstrumentationTransformer;
import com.wily.util.IConfigurationListener;
import com.wily.util.adt.IAgedMap;
import com.wily.util.adt.IAgedValue;
import com.wily.util.adt.IAtomicNumberFactory;
import com.wily.util.adt.IConcurrentMapFactory;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.LoggingHelper;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.IRegisteredBehavior;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.properties.hot.BooleanConfigurationProperty;
import com.wily.util.properties.hot.PositiveIntegerConfigurationProperty;
import com.wily.util.text.IStringLocalizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SustainabilityService
extends ASimpleService
implements ISustainabilityService,
IConfigurationListener,
IDirectiveLoadListener {
    private static SustainabilityService sustainabilityServiceInstance = null;
    public static final String kRootMetrics = "Agent Stats|Sustainability";
    private static final String kSustainabiliyMetricsPropertyEnabled = "com.wily.introscope.agent.sustainabilitymetrics.enabled";
    private static final String kSustainabiliyMetricsPropertyMetricsEnabled = "com.wily.introscope.agent.sustainabilitymetrics.metrics.enabled";
    private static final String kSustainabiliyMetricsPropertyReportsEnabled = "com.wily.introscope.agent.sustainabilitymetrics.report.enabled";
    private static final String kSustainabiliyMetricsPropertyReportFrequencyEnabled = "com.wily.introscope.agent.sustainabilitymetrics.report.frequency";
    private static final int kReportFrequency = 60000;
    private static final String kOptionalExtensionsRootMetricsName = "Agent Stats|Sustainability|Extensions Bundles";
    public static final String kOptionalExtensionsTotalMetricsName = "Agent Stats|Sustainability|Extensions Bundles|Total:Count";
    public static final String kOptionalExtensionsTotalLoadedMetricsName = "Agent Stats|Sustainability|Extensions Bundles|Loaded:Count";
    public static final String kOptionalExtensionsTotalFailedMetricsName = "Agent Stats|Sustainability|Extensions Bundles|Failed:Count";
    private static final String kOptionalExtensionsDeployementRootMetricsName = "Agent Stats|Sustainability|Extensions Bundles|Deployment";
    public static final String kOptionalExtensionsDeployementLastCycleTimeMetricsName = "Agent Stats|Sustainability|Extensions Bundles|Deployment|Last Cycle:Time (milliseconds)";
    public static final String kOptionalExtensionsDeployementStatusMetricsName = "Agent Stats|Sustainability|Extensions Bundles|Deployment|Current Cycle:Status (0=Deployed/1=Deploying)";
    public static final String kOptionalExtensionsDeployementCounterMetricsName = "Agent Stats|Sustainability|Extensions Bundles|Deployment|Count:All Cycles";
    public static final String kOptionalExtensionsDeployementSuccessfulCounterMetricsName = "Agent Stats|Sustainability|Extensions Bundles|Deployment|Count:Successful Cycles";
    public static final String kOptionalExtensionsDeployementFailedCounterMetricsName = "Agent Stats|Sustainability|Extensions Bundles|Deployment|Count:Failed Cycles";
    public static final String kAutoProbeTotalFailedMetricsName = "Agent Stats|Sustainability|Configuration|Logs:AutoProbe Errors Count";
    public static final String kAgentLogWarningMetricsName = "Agent Stats|Sustainability|Configuration|Logs:Warnings Count";
    public static final String kAgentLogErrorMetricsName = "Agent Stats|Sustainability|Configuration|Logs:Errors Count";
    public static final String kAgentLogWarningPerIntervalMetricsName = "Agent Stats|Sustainability|Configuration|Logs:Warnings Per Interval";
    public static final String kAgentLogErrorPerIntervalMetricsName = "Agent Stats|Sustainability|Configuration|Logs:Errors Per Interval";
    private volatile IAgent agent;
    private volatile BooleanConfigurationProperty fAgentSustainabilityMetricsProperty;
    private volatile BooleanConfigurationProperty fAgentSustainabilityMetricsEnabledProperty;
    private volatile BooleanConfigurationProperty fAgentSustainabilityReportEnabledProperty;
    private volatile PositiveIntegerConfigurationProperty fAgentSustainabilityReportFrequencyProperty;
    private volatile boolean fIsTracingSustainabilityMetrics = false;
    private volatile boolean fAreSustainabilityMetricsEnabled = false;
    private volatile boolean fIsSustainabilityReportEnabled = false;
    private volatile int fReportFrequency = 60000;
    private volatile IAgedMap fSustainabilityMap;
    private volatile IRegisteredBehavior extractorBehavior;
    private volatile IStringEveryEventDataAccumulator fConfigUdateTime = null;
    private volatile IStringEveryEventDataAccumulator fAutoProbeUdateTime = null;
    private volatile IStringEveryEventDataAccumulator fClassRedefinitionTime = null;
    private volatile ILongFluctuatingCounterDataAccumulator fOptionalExtensionsTotalMetricCount = null;
    private volatile ILongFluctuatingCounterDataAccumulator fOptionalExtensionsFailedMetricCount = null;
    private volatile ILongFluctuatingCounterDataAccumulator fOptionalExtensionsLoadedMetricCount = null;
    private volatile ILongFluctuatingCounterDataAccumulator fOptionalExtensionsSuccessfulDeploymentCount = null;
    private volatile ILongFluctuatingCounterDataAccumulator fOptionalExtensionsFailedDeploymentCount = null;
    private volatile ILongFluctuatingCounterDataAccumulator fOptionalExtensionsLastDeploymentCycleTime = null;
    private volatile ILongFluctuatingCounterDataAccumulator fOptionalExtensionsDeploymentStatus = null;
    private volatile ILongFluctuatingCounterDataAccumulator fOptionalExtensionsDeploymentCount = null;
    private static volatile ILongFluctuatingCounterDataAccumulator fAutoProbeErrorMetricCountAccumulator = null;
    private static volatile ILongFluctuatingCounterDataAccumulator fAgentErrorMetricCountAccumulator = null;
    private static volatile ILongFluctuatingCounterDataAccumulator fAgentWarningMetricCountAccumulator = null;
    private static volatile ILongIntervalCounterDataAccumulator fAgentErrorsPerIntervalMetricCountAccumulator = null;
    private static volatile ILongIntervalCounterDataAccumulator fAgentWarningsPerIntervalMetricCountAccumulator = null;
    private static volatile boolean fLogsAccumulatorsInitialized = false;
    static final Module kModule = new Module("SustainabilityService");
    static final Set fLoggers = new HashSet();

    public SustainabilityService(String name) {
        super(name);
    }

    public static SustainabilityService getSustainabilityServiceInstance() {
        return sustainabilityServiceInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getLoggerSnapshot() {
        ArrayList result = new ArrayList();
        Set set = fLoggers;
        synchronized (set) {
            Iterator i = fLoggers.iterator();
            while (i.hasNext()) {
                result.add(i.next());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSustainabilityReportLogger(ISustainabilityReportLogger logger) {
        Set set = fLoggers;
        synchronized (set) {
            fLoggers.add(logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSustainabilityReportLogger(ISustainabilityReportLogger logger) {
        Set set = fLoggers;
        synchronized (set) {
            fLoggers.remove(logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSustainabilityReportLoggerSet() {
        Set set = fLoggers;
        synchronized (set) {
            fLoggers.clear();
        }
    }

    private BooleanConfigurationProperty createAgentSustainabilityConfigurationParameter(Module module, IModuleFeedbackChannel feedback, IStringLocalizer localizer) {
        return new AgentSustainabilityMetricsProperty(kSustainabiliyMetricsPropertyEnabled, Boolean.FALSE, "Agent_Sustainability_Property_Name", feedback, module, localizer);
    }

    protected void doStartService(IAgent agent, Map parameters) throws Exception {
        this.agent = agent;
        this.fAgentSustainabilityMetricsProperty = this.createAgentSustainabilityConfigurationParameter(kModule, agent.IAgent_getModuleFeedback(), agent.IAgent_getStringLocalizer());
        this.fAgentSustainabilityMetricsEnabledProperty = new BooleanConfigurationProperty(kSustainabiliyMetricsPropertyMetricsEnabled, Boolean.FALSE, "Agent_Sustainability_Metric_Enabled_Property_Name", agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer()){

            public void set(Object value) {
                SustainabilityService.this.fAreSustainabilityMetricsEnabled = (Boolean)value;
                if (SustainabilityService.this.fSustainabilityMap != null) {
                    ((Map)((Object)SustainabilityService.this.fSustainabilityMap)).clear();
                }
            }
        };
        this.fAgentSustainabilityReportEnabledProperty = new BooleanConfigurationProperty(kSustainabiliyMetricsPropertyReportsEnabled, Boolean.FALSE, "Agent_Sustainability_Report_Enabled_Property_Name", agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer()){

            public void set(Object value) {
                SustainabilityService.this.fIsSustainabilityReportEnabled = (Boolean)value;
            }
        };
        this.fAgentSustainabilityReportFrequencyProperty = new PositiveIntegerConfigurationProperty(kSustainabiliyMetricsPropertyReportFrequencyEnabled, new Integer(60000), "Agent_Sustainability_Report_Frequency_Property_Name", agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer()){

            public void set(Object value) {
                SustainabilityService.this.fReportFrequency = (Integer)value;
                if (SustainabilityService.this.extractorBehavior != null) {
                    SustainabilityService.this.extractorBehavior.close();
                }
                SustainabilityService.this.extractorBehavior = SustainabilityService.this.startReportBehavior(SustainabilityService.this.getAgent());
            }
        };
        agent.IAgent_getConfigurationManager().add(this.fAgentSustainabilityMetricsProperty, true);
        agent.IAgent_getConfigurationManager().add(this.fAgentSustainabilityMetricsEnabledProperty, true);
        agent.IAgent_getConfigurationManager().add(this.fAgentSustainabilityReportEnabledProperty, true);
        agent.IAgent_getConfigurationManager().add(this.fAgentSustainabilityReportFrequencyProperty, true);
        sustainabilityServiceInstance = this;
        String metricName = "Agent Stats|Sustainability|Configuration:Last Profile Update Time";
        this.fConfigUdateTime = agent.IAgent_getDataAccumulatorFactory().safeGetStringEveryEventDataAccumulator(metricName);
        this.fConfigUdateTime.IStringEveryEventDataAccumulator_addString(new Date(System.currentTimeMillis()).toString());
        agent.addConfigurationListener(this);
        metricName = "Agent Stats|Sustainability|Configuration:Last AutoProbe Reload Time";
        this.fAutoProbeUdateTime = agent.IAgent_getDataAccumulatorFactory().safeGetStringEveryEventDataAccumulator(metricName);
        this.fAutoProbeUdateTime.IStringEveryEventDataAccumulator_addString(new Date(System.currentTimeMillis()).toString());
        metricName = "Agent Stats|Sustainability|Configuration:Last Class Redefinition Time";
        this.fClassRedefinitionTime = agent.IAgent_getDataAccumulatorFactory().safeGetStringEveryEventDataAccumulator(metricName);
        this.fClassRedefinitionTime.IStringEveryEventDataAccumulator_addString(new Date(System.currentTimeMillis()).toString());
        this.fOptionalExtensionsTotalMetricCount = agent.IAgent_getDataAccumulatorFactory().safeGetLongFluctuatingCounterDataAccumulator(kOptionalExtensionsTotalMetricsName);
        this.fOptionalExtensionsLoadedMetricCount = agent.IAgent_getDataAccumulatorFactory().safeGetLongFluctuatingCounterDataAccumulator(kOptionalExtensionsTotalLoadedMetricsName);
        this.fOptionalExtensionsFailedMetricCount = agent.IAgent_getDataAccumulatorFactory().safeGetLongFluctuatingCounterDataAccumulator(kOptionalExtensionsTotalFailedMetricsName);
        this.fOptionalExtensionsFailedDeploymentCount = agent.IAgent_getDataAccumulatorFactory().safeGetLongFluctuatingCounterDataAccumulator(kOptionalExtensionsDeployementFailedCounterMetricsName);
        this.fOptionalExtensionsSuccessfulDeploymentCount = agent.IAgent_getDataAccumulatorFactory().safeGetLongFluctuatingCounterDataAccumulator(kOptionalExtensionsDeployementSuccessfulCounterMetricsName);
        this.fOptionalExtensionsDeploymentStatus = agent.IAgent_getDataAccumulatorFactory().safeGetLongFluctuatingCounterDataAccumulator(kOptionalExtensionsDeployementStatusMetricsName);
        this.fOptionalExtensionsDeploymentCount = agent.IAgent_getDataAccumulatorFactory().safeGetLongFluctuatingCounterDataAccumulator(kOptionalExtensionsDeployementCounterMetricsName);
        this.fOptionalExtensionsLastDeploymentCycleTime = agent.IAgent_getDataAccumulatorFactory().safeGetLongFluctuatingCounterDataAccumulator(kOptionalExtensionsDeployementLastCycleTimeMetricsName);
        fAutoProbeErrorMetricCountAccumulator = agent.IAgent_getDataAccumulatorFactory().safeGetLongFluctuatingCounterDataAccumulator(kAutoProbeTotalFailedMetricsName);
        fAgentWarningMetricCountAccumulator = agent.IAgent_getDataAccumulatorFactory().safeGetLongFluctuatingCounterDataAccumulator(kAgentLogWarningMetricsName);
        fAgentErrorMetricCountAccumulator = agent.IAgent_getDataAccumulatorFactory().safeGetLongFluctuatingCounterDataAccumulator(kAgentLogErrorMetricsName);
        fAgentWarningsPerIntervalMetricCountAccumulator = agent.IAgent_getDataAccumulatorFactory().safeGetLongIntervalCounterDataAccumulator(kAgentLogWarningPerIntervalMetricsName);
        fAgentErrorsPerIntervalMetricCountAccumulator = agent.IAgent_getDataAccumulatorFactory().safeGetLongIntervalCounterDataAccumulator(kAgentLogErrorPerIntervalMetricsName);
        fLogsAccumulatorsInitialized = true;
        SustainabilityService.reportAgentErrorMetrics();
        SustainabilityService.reportAutoProbeErrorCountMetric();
        this.reportOptionalExtensionsMetrics(this.fOptionalExtensionsLoadedMetricCount, OptionalExtensionsIncludeConfiguration.getIncludedExtensions().size());
        this.reportOptionalExtensionsMetrics(this.fOptionalExtensionsFailedMetricCount, 0L);
        IDynamicInstrumentationTransformer transformer = agent.IAgent_getTransformerAdministrator().getDynamicInstrumentationTransformer();
        if (transformer != null) {
            transformer.registerDirectiveLoadListener(this);
        }
        agent.IAgent_getTracerAdministrator().setService(this);
        SustainabilityReportLogger logger = new SustainabilityReportLogger(this.getAgent(), this.getAgent().IAgent_getConfigurationResource());
        agent.addConfigurationListener(logger);
        this.addSustainabilityReportLogger(logger);
    }

    private IRegisteredBehavior startReportBehavior(IAgent agent) {
        return agent.IAgent_getCommonHeartbeat().addBehavior((ITimestampedRunnable)new ReportExtrator(), "High Concurrency Stall Feature", true, (long)this.fReportFrequency, false);
    }

    public ISustainabilityServiceTrace startSustainabilityTrace() {
        if (this.fIsTracingSustainabilityMetrics) {
            SustainabilityServiceTrace trace = new SustainabilityServiceTrace(this);
            return trace;
        }
        return null;
    }

    public IAtomicNumberFactory getFactory() {
        return this.agent.IAgent_getAtomicNumberFactory();
    }

    public ProbeInfoOverheadInfo getProbeInfoOverheadInfo(ProbeInformation probeInformation) {
        ProbeInfoOverheadInfo existingResult;
        ProbeInfoOverheadInfo result = (ProbeInfoOverheadInfo)this.fSustainabilityMap.getAged(probeInformation);
        if (result == null && (existingResult = (ProbeInfoOverheadInfo)this.fSustainabilityMap.addAgedIfAbsent(probeInformation, result = new ProbeInfoOverheadInfo(this, probeInformation))) != null) {
            result = existingResult;
        }
        return result;
    }

    public void storeAway(ISustainabilityServiceTrace sustainabilityServiceTrace) {
        ProbeInfoOverheadInfo info = this.getProbeInfoOverheadInfo(sustainabilityServiceTrace.getProbeInfo());
        long totalElapsedTime = sustainabilityServiceTrace.getTotalElapsedTime();
        long totalTimeInTracers = sustainabilityServiceTrace.getTotalTimeInTracers();
        long currentTotal = info.fGlobalTimeInMethod.addLongAndGet(totalElapsedTime);
        long currentTracer = info.fTraceTimeInMethod.addLongAndGet(totalTimeInTracers);
        if (this.fAreSustainabilityMetricsEnabled) {
            info.fGlobal.ILongAggregatingDataAccumulator_recordDataPoint(totalElapsedTime);
            info.fTracers.ILongAggregatingDataAccumulator_recordDataPoint(totalTimeInTracers);
            double percentage = 100.0 * ((double)currentTracer / (double)currentTotal);
            int percentageTotal = (int)Math.floor(percentage);
            info.fPercentage.IIntegerAggregatingDataAccumulator_recordDataPoint(percentageTotal);
        }
    }

    public IAgent getAgent() {
        return this.agent;
    }

    public boolean isSustainabilityMetricsEnabled() {
        return this.fAreSustainabilityMetricsEnabled;
    }

    public long getNanoTime() {
        return this.agent.getNanoTime();
    }

    public void onChange(IndexedProperties newProps) {
        this.fConfigUdateTime.IStringEveryEventDataAccumulator_addString(new Date(System.currentTimeMillis()).toString());
    }

    public void notifyDirectivesLoaded() {
        this.fAutoProbeUdateTime.IStringEveryEventDataAccumulator_addString(new Date(System.currentTimeMillis()).toString());
    }

    public void notifyRedefinitionComplete() {
        this.fClassRedefinitionTime.IStringEveryEventDataAccumulator_addString(new Date(System.currentTimeMillis()).toString());
    }

    public void setOptionalExtensionsFailedMetricCount(int metricCount) {
        this.reportOptionalExtensionsMetrics(this.fOptionalExtensionsFailedMetricCount, metricCount);
    }

    public void setOptionalExtensionsLoadedMetricCount(int metricCount) {
        this.reportOptionalExtensionsMetrics(this.fOptionalExtensionsLoadedMetricCount, metricCount);
    }

    public void setOptionalExtensionsTotalMetricCount(long metricCount) {
        this.reportOptionalExtensionsMetrics(this.fOptionalExtensionsTotalMetricCount, metricCount);
    }

    public void setOptionalExtensionsFailedDeploymentCount(long metricCount) {
        this.reportOptionalExtensionsMetrics(this.fOptionalExtensionsFailedDeploymentCount, metricCount);
    }

    public void setOptionalExtensionsSuccessfulDeploymentCount(long metricCount) {
        this.reportOptionalExtensionsMetrics(this.fOptionalExtensionsSuccessfulDeploymentCount, metricCount);
    }

    public void setOptionalExtensionsDeploymentCount(long metricCount) {
        this.reportOptionalExtensionsMetrics(this.fOptionalExtensionsDeploymentCount, metricCount);
    }

    public void setOptionalExtensionsLastDeploymentCycleTime(long metricValue) {
        this.reportOptionalExtensionsMetrics(this.fOptionalExtensionsLastDeploymentCycleTime, metricValue);
    }

    public void setOptionalExtensionsDeploymentStatus(int metricValue) {
        this.reportOptionalExtensionsMetrics(this.fOptionalExtensionsDeploymentStatus, metricValue);
    }

    private void reportOptionalExtensionsMetrics(ILongFluctuatingCounterDataAccumulator accumulator, long value) {
        accumulator.ILongCounterDataAccumulator_setValue(value);
    }

    public static void reportAutoProbeErrorCountMetric() {
        if (AInstrumentationHelper.isAutoProbeSettingsInvalid()) {
            fAutoProbeErrorMetricCountAccumulator.ILongCounterDataAccumulator_setValue(1L);
        }
    }

    public static void reportAgentErrorMetrics() {
        if (fLogsAccumulatorsInitialized) {
            fAgentErrorMetricCountAccumulator.ILongCounterDataAccumulator_setValue(LoggingHelper.getErrorCount());
            fAgentWarningMetricCountAccumulator.ILongCounterDataAccumulator_setValue(LoggingHelper.getWarningCount());
            fAgentWarningsPerIntervalMetricCountAccumulator.ILongAggregatingDataAccumulator_recordDataPoint(LoggingHelper.getAndResetWarningPerIntervalCount());
            fAgentErrorsPerIntervalMetricCountAccumulator.ILongAggregatingDataAccumulator_recordDataPoint(LoggingHelper.getAndResetErrorPerIntervalCount());
        }
    }

    private final class AgentSustainabilityMetricsProperty
    extends BooleanConfigurationProperty {
        private AgentSustainabilityMetricsProperty(String name, Boolean defaultValue, String descriptionKey, IModuleFeedbackChannel feedback, Module module, IStringLocalizer localizer) {
            super(name, defaultValue, descriptionKey, feedback, module, localizer);
        }

        public void set(Object newValue) {
            SustainabilityService.this.fIsTracingSustainabilityMetrics = (Boolean)newValue;
            if (SustainabilityService.this.fIsTracingSustainabilityMetrics && SustainabilityService.this.fSustainabilityMap == null) {
                IConcurrentMapFactory factory = SustainabilityService.this.agent.IAgent_getConcurrentMapFactory();
                if (factory != null) {
                    SustainabilityService.this.fSustainabilityMap = factory.getConcurrentAgingMap("sustainabilityMetrics");
                }
            } else if (SustainabilityService.this.fSustainabilityMap != null) {
                ((Map)((Object)SustainabilityService.this.fSustainabilityMap)).clear();
            }
        }
    }

    private final class ReportExtrator
    implements ITimestampedRunnable {
        private ReportExtrator() {
        }

        public void ITimestampedRunnable_execute(long nowInMillis) {
            if (!SustainabilityService.this.fIsSustainabilityReportEnabled) {
                return;
            }
            Map map = (Map)((Object)SustainabilityService.this.fSustainabilityMap);
            if (map != null) {
                ArrayList<SustainabilityReportEntry> result = new ArrayList<SustainabilityReportEntry>();
                for (Map.Entry e : map.entrySet()) {
                    IAgedValue dv = (IAgedValue)e.getValue();
                    ProbeInformation info = (ProbeInformation)e.getKey();
                    ProbeInfoOverheadInfo overhead = (ProbeInfoOverheadInfo)dv.get();
                    SustainabilityReportEntry ri = new SustainabilityReportEntry();
                    ri.setInfo(info);
                    ri.setTotal(overhead.fGlobalTimeInMethod.getLongAndSet(0L));
                    ri.setInTracers(overhead.fTraceTimeInMethod.getLongAndSet(0L));
                    double percentage = 100.0 * ((double)ri.getInTracers() / (double)ri.getTotal());
                    ri.setPercentage(new Integer((int)Math.floor(percentage)));
                    result.add(ri);
                }
                Collections.sort(result);
                List snapshot = SustainabilityService.this.getLoggerSnapshot();
                for (ISustainabilityReportLogger logger : snapshot) {
                    logger.log(result);
                }
            }
        }
    }
}

