/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.ComponentTracer;
import com.wily.introscope.agent.blame.IBlameStack;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import com.wily.util.properties.AttributeListing;

public abstract class ASingleMetricTracerFactory
extends ASingleInstanceTracerFactory {
    private final ReentrancyLevel fReentrancyLevel = this.calculateReentrancyLevel(ReentrancyLevel.kNone);
    private final boolean fUseBlame = this.calculateUseBlame(false);
    private final IDataAccumulator fDataAccumulator = this.cacheDataAccumulator();

    public ASingleMetricTracerFactory(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    private final IDataAccumulator cacheDataAccumulator() {
        if (this.canUseCaching()) {
            return this.createDataAccumulator(this.getFormattedName());
        }
        return null;
    }

    public final ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return this.fReentrancyLevel;
    }

    public boolean ITracerFactory_isShutoff() {
        if (this.fDataAccumulator != null) {
            return this.fDataAccumulator.IDataAccumulator_isShutOff();
        }
        return false;
    }

    protected final boolean useBlame() {
        return this.fUseBlame;
    }

    protected final void addToBlameStackIfEnabled(InvocationData data) {
        String blamedComponent;
        if (this.useBlame() && (blamedComponent = this.formatParameterizedResource(data)) != null) {
            IBlameStack stack = data.getStack(this.getComponentTracer(), true);
            this.getComponentTracer().addComponent(stack, blamedComponent, data);
        }
    }

    protected final void removeFromBlameStackIfEnabled(InvocationData data) {
        String blamedComponent;
        if (this.useBlame() && (blamedComponent = this.formatParameterizedResource(data)) != null) {
            ComponentTracer componentTracer = this.getComponentTracer();
            IBlameStack stack = data.getStack(componentTracer, false);
            componentTracer.removeComponent(stack, blamedComponent);
        }
    }

    protected final BlameStackSnapshot addToBlameStackIfEnabledAndReturnSnapshot(InvocationData data) {
        if (this.useBlame()) {
            ComponentTracer componentTracer = this.getComponentTracer();
            IBlameStack stack = data.getStack(componentTracer, false);
            String blamedComponent = this.formatParameterizedResource(data);
            BlameStackSnapshot snapshot = componentTracer.getSnapshot(stack, blamedComponent);
            if (blamedComponent != null) {
                stack = data.getStack(componentTracer, true);
                componentTracer.addComponent(blamedComponent, data);
            }
            return snapshot;
        }
        return BlameStackSnapshot.kEmptyBlameStackSnapshot;
    }

    protected final BlameStackSnapshot removeFromBlameStackIfEnabledAndReturnSnapshot(InvocationData data) {
        if (this.useBlame()) {
            ComponentTracer componentTracer = this.getComponentTracer();
            IBlameStack stack = data.getStack(componentTracer, false);
            String blamedComponent = this.formatParameterizedResource(data);
            if (blamedComponent != null) {
                componentTracer.removeComponent(stack, blamedComponent);
            }
            return componentTracer.getSnapshot(stack, blamedComponent);
        }
        return BlameStackSnapshot.kEmptyBlameStackSnapshot;
    }

    protected final IDataAccumulator getDataAccumulator(InvocationData data) {
        return this.getDataAccumulator(this.formatParameterizedName(data));
    }

    protected final IDataAccumulator getDataAccumulator(String name) {
        return this.createDataAccumulator(name);
    }

    protected abstract IDataAccumulator createDataAccumulator(String var1);
}

