/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace;

import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.servlet.ServletConfigWrapper;
import com.wily.introscope.agent.trace.servlet.ServletContextWrapper;
import com.wily.introscope.agent.trace.servlet.ServletObjectFactory;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.properties.AttributeListing;
import java.util.HashSet;
import java.util.Set;

public final class ServletInitTracer
extends ASingleInstanceTracerFactory {
    private static final int kReportingFrequency = 30000;
    static final String kServletConfigInterfaceName = "javax.servlet.ServletConfig";
    private ServletReporter fServletReporter = new ServletReporter();

    public ServletInitTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        agent.IAgent_getCommonHeartbeat().addBehavior((ITimestampedRunnable)this.fServletReporter, "Servlet Reporter", true, 30000L, false);
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        if (this.fServletReporter != null) {
            try {
                ServletObjectFactory apiFactory = ServletObjectFactory.getServletObjectFactory(data.getInvocationParameterAsObject(0));
                ServletConfigWrapper servletConfig = apiFactory.getServletConfigWrapper(data.getInvocationParameterAsObject(0));
                ServletContextWrapper servletContext = servletConfig.getServletContext();
                servletContext.getServletContextName();
                servletConfig.getServletName();
                servletContext.getRealPath("/");
            }
            catch (Exception e) {
                AgentShim.handleError("Error starting tracer", e);
            }
        }
    }

    protected final IDataAccumulator createDataAccumulator(String formattedMetricName) {
        return this.getDataAccumulatorFactory().safeGetStringEveryEventDataAccumulator(formattedMetricName);
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    public boolean ITracerFactory_isShutoff() {
        return false;
    }

    private class ServletReporter
    implements ITimestampedRunnable {
        Set fServlets = new HashSet();

        private ServletReporter() {
        }

        public void ITimestampedRunnable_execute(long nowInMillis) {
        }
    }
}

