/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.biz.trx;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.INameFormatter;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.spec.agent.bizdef.IBizTrx;
import com.wily.util.WilyStringBuilder;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.wilyassert.Assertion;

public class BizTrxNameFormatter
implements INameFormatter {
    private IModuleFeedbackChannel fFeedback;
    private static final char[] kBusinessDefinitionPlaceHolder = new String("{Business Definition}").toCharArray();
    private static final char[] kBusinessProcessPlaceHolder = new String("{Business Process}").toCharArray();
    private static final char[] kBusinessTransactionPlaceHolder = new String("{Business Transaction}").toCharArray();
    private static final char[] kBusinessTransactionComponentPlaceHolder = new String("{Business Transaction Component}").toCharArray();
    private static ThreadLocal NameFormatterBuilder = new ThreadLocal(){

        protected Object initialValue() {
            return new WilyStringBuilder();
        }
    };

    public BizTrxNameFormatter(IAgent agent) {
        this.fFeedback = agent.IAgent_getModuleFeedback();
    }

    public String INameFormatter_format(String name, InvocationData data) {
        Assertion.wilyAssert(name != null);
        String result = name;
        try {
            int bizTrxComponentIndex;
            int bizTrxIndex;
            int bizProcessIndex;
            WilyStringBuilder bldr = (WilyStringBuilder)NameFormatterBuilder.get();
            bldr.setString(name);
            int bizDefinitionIndex = bldr.indexOf(kBusinessDefinitionPlaceHolder);
            if (bizDefinitionIndex >= 0) {
                bldr = bldr.replace(bizDefinitionIndex, bizDefinitionIndex + kBusinessDefinitionPlaceHolder.length, this.getBusinessDefinitionName(data));
            }
            if ((bizProcessIndex = bldr.indexOf(kBusinessProcessPlaceHolder)) >= 0) {
                bldr = bldr.replace(bizProcessIndex, bizProcessIndex + kBusinessProcessPlaceHolder.length, this.getBusinessProcessName(data));
            }
            if ((bizTrxIndex = bldr.indexOf(kBusinessTransactionPlaceHolder)) >= 0) {
                bldr = bldr.replace(bizTrxIndex, bizTrxIndex + kBusinessTransactionPlaceHolder.length, this.getBusinessTransactionName(data));
            }
            if ((bizTrxComponentIndex = bldr.indexOf(kBusinessTransactionComponentPlaceHolder)) >= 0) {
                bldr = bldr.replace(bizTrxComponentIndex, bizTrxComponentIndex + kBusinessTransactionComponentPlaceHolder.length, this.getBusinessTransactionComponentName(data));
            }
            result = bldr.toString();
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                this.fFeedback.error("An error occurred formatting business definition name.");
                this.fFeedback.verbose(t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
        return result;
    }

    protected IBizTrx getBizTrx(InvocationData data) {
        Assertion.wilyAssert(data != null);
        IBizTrx bizTrx = (IBizTrx)data.get("BusinessTrxData");
        return bizTrx;
    }

    protected String getBusinessDefinitionName(InvocationData data) {
        IBizTrx bizTrx = this.getBizTrx(data);
        return bizTrx.getBizFullName();
    }

    protected String getBusinessProcessName(InvocationData data) {
        IBizTrx bizTrx = this.getBizTrx(data);
        return bizTrx.getBizProcessName();
    }

    protected String getBusinessTransactionName(InvocationData data) {
        IBizTrx bizTrx = this.getBizTrx(data);
        return bizTrx.getBizTrxName();
    }

    protected String getBusinessTransactionComponentName(InvocationData data) {
        IBizTrx bizTrx = this.getBizTrx(data);
        return bizTrx.getBizTrxComponentName();
    }
}

