/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.ejb;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.INameFormatter;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ejb.hc2.EjbDeferredContextTracer;
import com.wily.util.WilyStringBuilder;
import com.wily.util.adt.ConcurrentWeakIdentityThreadLocalHashMap;
import com.wily.util.adt.IConcurrentMapFactory15;
import com.wily.util.classfile.NameUtilities;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicReference;

public abstract class AEjbNameFormatter
implements INameFormatter {
    protected final IModuleFeedbackChannel fFeedback;
    private final IStringLocalizer fLocalizer;
    public static final String kEjbDeferredInterface = "com.wily.EjbDeferredContextTracer.DEFERRED";
    private static final Module kModule = new Module("AEjbNameFormatter");
    private static final char[] kClassNamePlaceHolder = "{bean}".toCharArray();
    private static final char[] kInterfaceNamePlaceHolder = "{interface}".toCharArray();
    private static final char[] kMethodNamePlaceHolder = "{method}".toCharArray();
    private static AtomicReference<ConcurrentWeakIdentityThreadLocalHashMap<Object, String>> sEjbBeanClassToInterfaceMap = new AtomicReference<Object>(null);
    private static AtomicReference<ConcurrentWeakIdentityThreadLocalHashMap<Object, Object>> sEjbBeanClassToContextMap = new AtomicReference<Object>(null);
    protected static String kEJBObjectClass = "javax.ejb.EJBObject";
    protected static String kEJBPacakgePrefix = "javax.ejb.";
    protected static String kSerializableInterface = "java.io.Serializable";
    protected static String kExternalizableInterface = "java.io.Externalizable";
    private static String kUnknownClassName = "UnknownClass";
    private static String kUnknownInterfaceName = "UnknownInterface";
    private static String kUnknownMethodName = "UnknownMethod";
    private static ThreadLocal NameFormatterBuilder = new ThreadLocal(){

        protected Object initialValue() {
            return new WilyStringBuilder();
        }
    };

    public AEjbNameFormatter(IAgent agent) {
        ConcurrentWeakIdentityThreadLocalHashMap map;
        IConcurrentMapFactory15 mapFactory;
        this.fFeedback = agent.IAgent_getModuleFeedback();
        this.fLocalizer = agent.IAgent_getStringLocalizer();
        if (sEjbBeanClassToInterfaceMap.get() == null) {
            mapFactory = (IConcurrentMapFactory15)((Object)agent.IAgent_getConcurrentMapFactory());
            map = mapFactory.getConcurrentWeakIdentityHashMap("EjbBeanClassToInterfaceMap");
            sEjbBeanClassToInterfaceMap.set(map);
        }
        if (sEjbBeanClassToContextMap.get() == null) {
            mapFactory = (IConcurrentMapFactory15)((Object)agent.IAgent_getConcurrentMapFactory());
            map = mapFactory.getConcurrentWeakIdentityHashMap("EjbBeanClassToContextMap");
            sEjbBeanClassToContextMap.set(map);
        }
    }

    @Override
    public String INameFormatter_format(String name, InvocationData data) {
        return this.format(name, data.getInvocationObject(), data.getProbeInformation().getProbeIdentification());
    }

    protected String format(String name, Object obj, ProbeIdentification pInfo) {
        String result;
        block31: {
            result = name;
            try {
                if (name == null) break block31;
                WilyStringBuilder bldr = (WilyStringBuilder)NameFormatterBuilder.get();
                bldr.setString(name);
                int methodNameIndex = bldr.indexOf(kMethodNamePlaceHolder);
                int interfaceNameIndex = bldr.indexOf(kInterfaceNamePlaceHolder);
                int classNameIndex = bldr.indexOf(kClassNamePlaceHolder);
                String methodName = null;
                String interfaceName = null;
                String className = null;
                if (methodNameIndex >= 0) {
                    methodName = pInfo.getProbeMethodName();
                }
                if (classNameIndex >= 0 || interfaceNameIndex >= 0) {
                    className = pInfo.getProbeClassName();
                }
                Class<?> clazz = null;
                ClassLoader classLoader = null;
                if (interfaceNameIndex >= 0 || className == null && classNameIndex >= 0) {
                    interfaceName = AEjbNameFormatter.getInterfaceFromCache(obj);
                    if (interfaceName == kEjbDeferredInterface) {
                        interfaceName = EjbDeferredContextTracer.findInterfaceName(AEjbNameFormatter.getContextFromCache(obj), this.getFeedback());
                    }
                    if (interfaceName == null) {
                        classLoader = obj != null ? obj.getClass().getClassLoader() : this.getClass().getClassLoader();
                        if (className != null) {
                            try {
                                clazz = Class.forName(className, false, classLoader);
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                clazz = null;
                            }
                        }
                        if (obj != null && clazz == null) {
                            clazz = obj.getClass();
                        }
                        if (clazz != null) {
                            if (className == null) {
                                className = NameUtilities.parseSimpleClassName(clazz.getName());
                            }
                            if ((interfaceName = this.findInterfaceName(obj, clazz, classLoader)) != null) {
                                AEjbNameFormatter.setInterfaceToCache(obj, interfaceName);
                            }
                        }
                    } else if (className == null) {
                        className = NameUtilities.parseSimpleClassName(obj.getClass().getName());
                    }
                }
                if (methodNameIndex >= 0 && methodName == null) {
                    methodName = kUnknownMethodName;
                }
                className = classNameIndex >= 0 && className == null ? kUnknownClassName : NameUtilities.parseSimpleClassName(className);
                if (interfaceNameIndex >= 0 && interfaceName == null) {
                    interfaceName = kUnknownInterfaceName;
                    if (this.fFeedback.isDebugEnabled(kModule) && obj != null && clazz != null) {
                        Class<?> superClass;
                        Annotation[] annotations;
                        int n;
                        this.fFeedback.debug(kModule, String.valueOf(this.getClass().getName()) + ": Unable to find interface for " + className + "(" + clazz.getName() + ")");
                        Class<?>[] interfaces = clazz.getInterfaces();
                        if (interfaces != null && interfaces.length > 0) {
                            Class<?>[] classArray = interfaces;
                            n = interfaces.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Class<?> c = classArray[n2];
                                this.fFeedback.debug(kModule, "Implements: " + c.getName());
                                ++n2;
                            }
                        }
                        if ((annotations = clazz.getAnnotations()) != null && annotations.length > 0) {
                            Annotation[] annotationArray = annotations;
                            int n3 = annotations.length;
                            n = 0;
                            while (n < n3) {
                                Annotation a = annotationArray[n];
                                this.fFeedback.debug(kModule, "Annotated as: " + a.getClass().getName());
                                ++n;
                            }
                        }
                        if ((superClass = clazz.getSuperclass()) != null) {
                            this.fFeedback.debug(kModule, "Extends: " + superClass.getName());
                        }
                    }
                    AEjbNameFormatter.setInterfaceToCache(obj, interfaceName);
                }
                if (classNameIndex >= 0) {
                    bldr = bldr.replace(classNameIndex, classNameIndex + kClassNamePlaceHolder.length, className);
                }
                if (interfaceNameIndex >= 0) {
                    bldr = bldr.replace(interfaceNameIndex, interfaceNameIndex + kInterfaceNamePlaceHolder.length, interfaceName);
                }
                if (methodNameIndex >= 0) {
                    bldr = bldr.replace(methodNameIndex, methodNameIndex + kMethodNamePlaceHolder.length, methodName);
                }
                result = bldr.toString();
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    this.fFeedback.error(kModule, "An error occurred formatting EJB name:" + t.getMessage());
                    this.fFeedback.verbose(kModule, "An error occurred formatting EJB name.", t);
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Throwable throwable) {}
            }
        }
        return result;
    }

    protected abstract String findInterfaceName(Object var1, Class var2, ClassLoader var3);

    protected IModuleFeedbackChannel getFeedback() {
        return this.fFeedback;
    }

    public IStringLocalizer getFLocalizer() {
        return this.fLocalizer;
    }

    public static String getInterfaceFromCache(InvocationData data) {
        return AEjbNameFormatter.getInterfaceFromCache(data.getInvocationObject());
    }

    public static String getInterfaceFromCache(Object beanObject) {
        String result = null;
        if (beanObject != null) {
            try {
                ConcurrentWeakIdentityThreadLocalHashMap<Object, String> map = sEjbBeanClassToInterfaceMap.get();
                if (map != null) {
                    result = map.getWeak(beanObject);
                }
            }
            catch (Throwable t) {
                try {
                    if (AgentShim.getAgent().IAgent_getModuleFeedback().isDebugEnabled()) {
                        AgentShim.getAgent().IAgent_getModuleFeedback().debug("Using string based cache to look up object because it fails to hash: " + t.toString());
                    }
                }
                catch (AgentNotAvailableException agentNotAvailableException) {}
            }
        }
        return result;
    }

    public static void setInterfaceToCache(InvocationData data, String interfaceName) {
        AEjbNameFormatter.setInterfaceToCache(data.getInvocationObject(), interfaceName);
    }

    public static void setInterfaceToCache(Object beanObject, String interfaceName) {
        if (beanObject == null) {
            Assertion.wilyAssert("Object does not have class name.");
            return;
        }
        try {
            ConcurrentWeakIdentityThreadLocalHashMap<Object, String> map = sEjbBeanClassToInterfaceMap.get();
            if (map != null) {
                map.putWeak(beanObject, interfaceName);
            }
        }
        catch (Throwable t) {
            try {
                if (AgentShim.getAgent().IAgent_getModuleFeedback().isDebugEnabled()) {
                    AgentShim.getAgent().IAgent_getModuleFeedback().debug("Using string based cache for object because it fails to hash: " + t.toString());
                }
            }
            catch (AgentNotAvailableException agentNotAvailableException) {}
        }
    }

    public static Object getContextFromCache(Object beanObject) {
        Object obj = null;
        if (beanObject != null) {
            try {
                ConcurrentWeakIdentityThreadLocalHashMap<Object, Object> map = sEjbBeanClassToContextMap.get();
                if (map != null && (obj = map.getWeak(beanObject)) != null) {
                    WeakReference result = (WeakReference)obj;
                    obj = result.get();
                }
            }
            catch (Throwable t) {
                try {
                    if (AgentShim.getAgent().IAgent_getModuleFeedback().isDebugEnabled()) {
                        AgentShim.getAgent().IAgent_getModuleFeedback().debug("Using string based cache to look up object because it fails to hash: " + t.toString());
                    }
                }
                catch (AgentNotAvailableException agentNotAvailableException) {}
            }
        }
        return obj;
    }

    public static void setContextToCache(Object beanObject, Object context) {
        if (beanObject == null) {
            Assertion.wilyAssert("Object does not have class name.");
            return;
        }
        try {
            ConcurrentWeakIdentityThreadLocalHashMap<Object, Object> map = sEjbBeanClassToContextMap.get();
            if (map != null) {
                map.putWeak(beanObject, new WeakReference<Object>(context));
            }
        }
        catch (Throwable t) {
            try {
                if (AgentShim.getAgent().IAgent_getModuleFeedback().isDebugEnabled()) {
                    AgentShim.getAgent().IAgent_getModuleFeedback().debug("Using string based cache for object because it fails to hash: " + t.toString());
                }
            }
            catch (AgentNotAvailableException agentNotAvailableException) {}
        }
    }
}

