/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.hc2;

import java.util.concurrent.atomic.AtomicInteger;

public abstract class BaseMetricGathererWrapper {
    public static int kRead = 2;
    public static int kDirty = 1;
    public static int kStandBy = 0;
    private final AtomicInteger fStatus = new AtomicInteger();
    private long startTimestamp = Long.MAX_VALUE;
    private final boolean fShouldBeConsumedOnRead;
    private volatile boolean fIsRead = false;

    protected BaseMetricGathererWrapper(boolean shouldBeConsumedOnRead) {
        this.fShouldBeConsumedOnRead = shouldBeConsumedOnRead;
    }

    public final void combineTime(long startTime) {
        if (startTime < this.startTimestamp) {
            this.startTimestamp = startTime;
        }
    }

    public final void combineTime(long endTime, long startTime) {
        if (startTime < this.startTimestamp) {
            this.startTimestamp = startTime;
        }
    }

    public final void combineTime(BaseMetricGathererWrapper offered) {
        if (offered.startTimestamp < this.startTimestamp) {
            this.startTimestamp = offered.startTimestamp;
        }
    }

    public void setStartTimestamp(long startTimestamp) {
        this.startTimestamp = startTimestamp;
    }

    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    public void setEndTimestamp(long endTimestamp) {
    }

    public long getEndTimestamp() {
        return 0L;
    }

    public boolean shouldBeConsumendOnRead() {
        return this.fShouldBeConsumedOnRead;
    }

    public final void markClean() {
        this.fStatus.set(kStandBy);
    }

    public final boolean markDirty() {
        return this.fStatus.compareAndSet(kStandBy, kDirty);
    }

    public final void forceDirty() {
        this.fStatus.set(kDirty);
    }

    public final boolean markRead() {
        boolean result;
        this.fIsRead = result = this.fStatus.compareAndSet(kStandBy, kRead);
        return result;
    }

    public final boolean isRead() {
        return this.fIsRead;
    }
}

