/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.hc2.HttpServletTracer;
import com.wily.introscope.agent.trace.servlet.IServletRequestHelper;
import com.wily.introscope.agent.trace.servlet.LoaderContext;
import com.wily.introscope.agent.transactiontrace.TransactionTraceController;
import com.wily.util.adt.LazyMap;
import java.util.Map;
import java.util.Set;

public final class HttpServletLazyMapProvider
implements LazyMap.ILazyMapProvider {
    private volatile Object servlet;
    private volatile InvocationData data;
    private volatile IAgent agent;
    private volatile Map cacheParameterMap;
    private volatile IServletRequestHelper helper;
    private volatile String charEncoding;
    private volatile LoaderContext context;
    private volatile Object request;
    private TransactionTraceController ttc;

    public HttpServletLazyMapProvider(Object servlet, InvocationData data, IAgent agent, Map cacheParameterMap, IServletRequestHelper helper, String charEncoding, LoaderContext context, Object request) {
        this.servlet = servlet;
        this.data = data;
        this.agent = agent;
        this.cacheParameterMap = cacheParameterMap;
        this.helper = helper;
        this.charEncoding = charEncoding;
        this.context = context;
        this.request = request;
        this.ttc = this.agent.IAgent_getTransactionTraceController();
    }

    @Override
    public void warn(String string) {
        if (HttpServletTracer.fIsDebugEnabled) {
            this.agent.IAgent_getModuleFeedback().debug(string);
        }
    }

    @Override
    public Set getKeySet() {
        return this.helper.getKeySet();
    }

    public String getCharEncoding() {
        return this.charEncoding;
    }

    public void setCharEncoding(String charEncoding) {
        this.charEncoding = charEncoding;
    }

    @Override
    public Object get(Object key) {
        if (key.equals("Normalized URL")) {
            return HttpServletTracer.getNormalizedURL(this.agent, this.cacheParameterMap, this.helper, this.request, this.data, this.charEncoding);
        }
        if (key.equals("Application Name")) {
            return HttpServletLazyMapProvider.getServletContextName(this.agent, this.helper, this.request, this.servlet);
        }
        if (key.equals("Session ID") && !this.ttc.isSessionIdPropagationEnabled()) {
            return null;
        }
        return this.helper.get(this.request, this.servlet, this.cacheParameterMap, this.context, key, this.charEncoding);
    }

    void reset(Object servlet, InvocationData data, IAgent agent, IServletRequestHelper helper, String charEncoding, LoaderContext context, Object request) {
        this.servlet = servlet;
        this.data = data;
        this.agent = agent;
        this.helper = helper;
        this.charEncoding = charEncoding;
        this.context = context;
        this.request = request;
        this.cacheParameterMap.clear();
    }

    private static String getServletContextName(IAgent agent, IServletRequestHelper helper, Object request, Object servlet) {
        try {
            String result = helper.getApplicationName(request, servlet);
            if (result != null && result.equals("")) {
                result = "rootContext";
            }
            return result;
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                agent.IAgent_getModuleFeedback().verbose(t);
                agent.IAgent_getModuleFeedback().error("An error occurred getting the application name: " + t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
            return "UnknownApp";
        }
    }
}

