/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.intelligent;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.IFactoryLevelParameterCallback;
import com.wily.introscope.agent.blame.VirtualStack;
import com.wily.introscope.agent.correlation.CrossProcessCorrelationAdmin;
import com.wily.introscope.agent.trace.BTThreadLocalAdministrator;
import com.wily.introscope.agent.trace.ICallbackOnStartHarvestTransaction;
import com.wily.introscope.agent.trace.IIntelligentInstrumentationStackElement;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeInformation;
import com.wily.introscope.agent.trace.cas.BlameTransactionElement;
import com.wily.introscope.agent.trace.cas.IParamsProviderElement;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.cas.ITransactionInstance;
import com.wily.introscope.agent.trace.cas.SetElement;
import com.wily.introscope.agent.trace.hc2.SocketTransactionElement;
import com.wily.introscope.agent.trace.hc2.TransactionHarvestHelper;
import com.wily.introscope.agent.trace.hc2.WilyTransactionElement;
import com.wily.introscope.agent.trace.intelligent.CrossProcessAutoTracingConfiguration;
import com.wily.introscope.agent.trace.intelligent.ErrorElementsParameterContainer;
import com.wily.introscope.agent.trace.intelligent.HighPerformanceIntelligenceStackElement;
import com.wily.introscope.agent.trace.intelligent.HighPerformanceIntelligentErrorFeature;
import com.wily.introscope.agent.trace.intelligent.HighPerformanceIntelligentFilter;
import com.wily.introscope.agent.trace.intelligent.HighPerformanceIntelligentStackHelper;
import com.wily.introscope.agent.trace.intelligent.IInstrumentationLevelChangeStatusManager;
import com.wily.introscope.agent.trace.intelligent.IntelligentInstrumentationThreadLocalObject;
import com.wily.introscope.agent.trace.intelligent.NullInstrumentationLevelChangeStatusManager;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import com.wily.introscope.agent.transactiontrace.TransactionCollectStatus;
import com.wily.introscope.spec.server.beans.event.IEventDataNode;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import com.wily.wilyassert.Assertion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class IntelligentTransactionHarvesterHelper {
    private static IInstrumentationLevelChangeStatusManager sInstrumentationStatusManager = new NullInstrumentationLevelChangeStatusManager();
    private static final int kTraceThrottleArrayIndex_TotalTCDCreated = 5;
    private static final int kTraceThrottleArray_Size = 8;

    public static void setInstrumentationLevelChangeStatusManager(IInstrumentationLevelChangeStatusManager manager) {
        sInstrumentationStatusManager = manager;
    }

    private static int harvestTcdFromNormalTracer(IAgent sAgent, IStackElement stckElement, IntelligentInstrumentationThreadLocalObject tlObj, HashMap normalTcdHash) {
        int numTCD = 0;
        boolean isRootVirtual = false;
        IIntelligentInstrumentationStackElement ttTopOfStack = tlObj.fTopOfStackForTT;
        boolean isRoot = true;
        List trace = stckElement.getTransactionInstanceList();
        long duration = 0L;
        TransactionComponentData root = null;
        InvocationData rootData = null;
        int position = trace.size() - 1;
        while (position >= 0) {
            BlameTransactionElement last;
            ITransactionInstance tend = (ITransactionInstance)trace.get(position);
            if (tend == null) {
                IntelligentTransactionHarvesterHelper.cleanupAfterTT(tlObj);
                return -1;
            }
            ITransactionElement te = tend.getTransactionElement();
            if (te == null) {
                IntelligentTransactionHarvesterHelper.cleanupAfterTT(tlObj);
                return -1;
            }
            if (te instanceof BlameTransactionElement && !(last = (BlameTransactionElement)te).isStartTrace()) {
                InvocationData theData;
                ITransactionInstance tStart = tend.getStartInstance();
                if (tStart == null) {
                    IntelligentTransactionHarvesterHelper.cleanupAfterTT(tlObj);
                    return -1;
                }
                long startTrace = tStart.getData().getWallClockStartTime();
                BTThreadLocalAdministrator.getInstance().insert("x-apm-brtm-tt-starttime", startTrace);
                duration = tend.getDuration();
                if (duration < 0L) {
                    Assertion.wilyAssert(duration >= 0L, "The duration should be bigger than zero");
                    duration = 0L;
                }
                TransactionComponentData component = TransactionComponentData.createMilliSecTransactionComponentData(last.getComponentName(), startTrace, duration);
                IStackElement sElem = tStart.getData();
                boolean isVirtualElement = false;
                if (!(sElem instanceof InvocationData)) {
                    isVirtualElement = true;
                }
                if (isRoot) {
                    if (!isVirtualElement) {
                        theData = (InvocationData)sElem;
                        isRoot = false;
                        root = component;
                        rootData = theData;
                        if (theData.getInvocationId() != ttTopOfStack.getStackElementId()) {
                            if (sAgent.IAgent_getModuleFeedback().isDebugEnabled()) {
                                sAgent.IAgent_getModuleFeedback().debug("Unable to match Intelligent Instrumentation trace data with InvocationData");
                            }
                            IntelligentTransactionHarvesterHelper.cleanupAfterTT(tlObj);
                            return -1;
                        }
                        IntelligentTransactionHarvesterHelper.addToNormalTcdMap(normalTcdHash, theData.getInvocationId(), component);
                        ++numTCD;
                    } else {
                        isRootVirtual = true;
                        if (sAgent.IAgent_getModuleFeedback().isDebugEnabled()) {
                            sAgent.IAgent_getModuleFeedback().debug("Unable to merge 1st element of transaction trace ");
                        }
                    }
                } else if (!isVirtualElement) {
                    theData = (InvocationData)sElem;
                    IntelligentTransactionHarvesterHelper.addToNormalTcdMap(normalTcdHash, theData.getInvocationId(), component);
                    ++numTCD;
                }
                component.tempChildren = new ArrayList();
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                component.setParameters(parameters);
                IStackElement dataElement = tend.getData();
                if (dataElement != null) {
                    ProbeInformation fInfo;
                    if (last instanceof WilyTransactionElement && dataElement instanceof InvocationData && (fInfo = ((InvocationData)dataElement).getProbeInformation()) != null) {
                        parameters.put("Resource Name", component.getResource());
                        IntelligentTransactionHarvesterHelper.decorateComponentWithProbeInfo(parameters, fInfo);
                    }
                    VirtualStack.addParameterCallbacks(parameters, dataElement);
                    dataElement.addParameterCallbacks(parameters);
                }
                Object error = dataElement.get("Exception");
                Object errMsg = dataElement.get("Error Message");
                if (error != null) {
                    parameters.put("Exception", error);
                }
                if (errMsg != null) {
                    parameters.put("Error Message", errMsg);
                }
                TransactionHarvestHelper.includeSocketParams(parameters, tend.getData());
            }
            --position;
        }
        if (root != null && !isRootVirtual) {
            TransactionHarvestHelper.includeRootParams(root.getParameters(), rootData);
        }
        return numTCD;
    }

    private static void addToNormalTcdMap(HashMap normalTcdHash, int id, TransactionComponentData component) {
        Integer key = new Integer(id);
        TransactionComponentData d = (TransactionComponentData)normalTcdHash.get(key);
        if (d == null) {
            normalTcdHash.put(key, component);
        } else {
            TransactionComponentData[] sn = d.getSubNodes();
            while (sn != null && sn.length > 0) {
                d = sn[0];
                sn = d.getSubNodes();
            }
            d.setSubNodes(new TransactionComponentData[]{component});
        }
    }

    public static boolean harvestTransaction(IStackElement stckElement, ICallbackOnStartHarvestTransaction callback, boolean isNormalOrPassedErrorFilter) {
        boolean result = true;
        try {
            result = IntelligentTransactionHarvesterHelper.harvestTransactionHighPerformanceWithThrottle(HighPerformanceIntelligenceStackElement.getAgent(), callback, stckElement, isNormalOrPassedErrorFilter);
        }
        catch (Exception exception) {
            result = false;
        }
        HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack.tearDown();
        return result;
    }

    public static int prepareTopTCDElementsForCache(IStackElement stckElement) {
        if (!CrossProcessAutoTracingConfiguration.isCrossProcessAutoTracingEnabled()) {
            return 0;
        }
        IAgent sAgent = HighPerformanceIntelligenceStackElement.getAgent();
        IntelligentInstrumentationThreadLocalObject tlObj = HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack.getThreadLocal().sIntelligentThreadLocalObject;
        HashMap normalTcdHash = tlObj.fTopTCDElements;
        int numTCD = 0;
        boolean isRootVirtual = false;
        IIntelligentInstrumentationStackElement ttTopOfStack = tlObj.fTopOfStackForTT;
        boolean isRoot = true;
        List trace = stckElement.getTransactionInstanceList();
        long duration = 0L;
        TransactionComponentData root = null;
        InvocationData rootData = null;
        int position = trace.size() - 1;
        int numTCDCreated = 0;
        while (position >= 0) {
            BlameTransactionElement last;
            ITransactionInstance tend = (ITransactionInstance)trace.get(position);
            if (tend == null) {
                IntelligentTransactionHarvesterHelper.cleanupAfterTT(tlObj);
                return -1;
            }
            ITransactionElement te = tend.getTransactionElement();
            if (te == null) {
                IntelligentTransactionHarvesterHelper.cleanupAfterTT(tlObj);
                return -1;
            }
            if (te instanceof BlameTransactionElement && !(last = (BlameTransactionElement)te).isStartTrace() && numTCDCreated <= 3) {
                InvocationData theData;
                ITransactionInstance tStart = tend.getStartInstance();
                if (tStart == null) {
                    IntelligentTransactionHarvesterHelper.cleanupAfterTT(tlObj);
                    return -1;
                }
                long startTrace = tStart.getData().getWallClockStartTime();
                BTThreadLocalAdministrator.getInstance().insert("x-apm-brtm-tt-starttime", startTrace);
                duration = tend.getDuration();
                if (duration < 0L) {
                    Assertion.wilyAssert(duration >= 0L, "The duration should be bigger than zero");
                    duration = 0L;
                }
                ++numTCDCreated;
                TransactionComponentData component = TransactionComponentData.createMilliSecTransactionComponentData(last.getComponentName(), startTrace, duration);
                IStackElement sElem = tStart.getData();
                boolean isVirtualElement = false;
                if (!(sElem instanceof InvocationData)) {
                    isVirtualElement = true;
                }
                if (isRoot) {
                    if (!isVirtualElement) {
                        theData = (InvocationData)sElem;
                        isRoot = false;
                        root = component;
                        rootData = theData;
                        if (ttTopOfStack != null && theData.getInvocationId() != ttTopOfStack.getStackElementId()) {
                            if (sAgent.IAgent_getModuleFeedback().isDebugEnabled()) {
                                sAgent.IAgent_getModuleFeedback().debug("Unable to match Intelligent Instrumentation trace data with InvocationData");
                            }
                            IntelligentTransactionHarvesterHelper.cleanupAfterTT(tlObj);
                            return -1;
                        }
                        IntelligentTransactionHarvesterHelper.addToNormalTcdMap(normalTcdHash, theData.getInvocationId(), component);
                        ++numTCD;
                    } else {
                        isRootVirtual = true;
                        if (sAgent.IAgent_getModuleFeedback().isDebugEnabled()) {
                            sAgent.IAgent_getModuleFeedback().debug("Unable to merge 1st element of transaction trace ");
                        }
                    }
                } else if (!isVirtualElement) {
                    theData = (InvocationData)sElem;
                    IntelligentTransactionHarvesterHelper.addToNormalTcdMap(normalTcdHash, theData.getInvocationId(), component);
                    ++numTCD;
                }
                component.tempChildren = new ArrayList();
                HashMap<String, String> parameters = new HashMap<String, String>();
                component.setParameters(parameters);
                IStackElement dataElement = tend.getData();
                if (dataElement != null) {
                    ProbeInformation fInfo;
                    if (last instanceof WilyTransactionElement && dataElement instanceof InvocationData && (fInfo = ((InvocationData)dataElement).getProbeInformation()) != null) {
                        parameters.put("Resource Name", component.getResource());
                        IntelligentTransactionHarvesterHelper.decorateComponentWithProbeInfo(parameters, fInfo);
                    }
                    VirtualStack.addParameterCallbacks(parameters, dataElement);
                    dataElement.addParameterCallbacks(parameters);
                }
            }
            --position;
        }
        if (root != null && !isRootVirtual) {
            TransactionHarvestHelper.includeRootParams(root.getParameters(), rootData);
        }
        return numTCD;
    }

    public static boolean harvestTransactionHighPerformanceWithThrottle(IAgent sAgent, ICallbackOnStartHarvestTransaction callback, IStackElement stckElement, boolean passedNormalOrErrorFilter) {
        HighPerformanceIntelligentFilter filter = HighPerformanceIntelligentFilter.getInstance();
        int traceThrottleState = filter.getTransactionTraceThrottleState();
        int traceComonentMax = filter.getSingleTransactionTraceComponentsMax();
        int maxTraceDepth = filter.getTransactionTraceMaxDepth();
        if (callback == null) {
            callback = HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack.getThreadLocal();
        }
        IntelligentInstrumentationThreadLocalObject tlObj = HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack.getThreadLocal().sIntelligentThreadLocalObject;
        IIntelligentInstrumentationStackElement ttTopOfStack = tlObj.fTopOfStackForTT;
        if (ttTopOfStack == null) {
            if (sAgent.IAgent_getModuleFeedback().isDebugEnabled()) {
                sAgent.IAgent_getModuleFeedback().debug("No method in stack, cannot report transaction trace.");
            }
            IntelligentTransactionHarvesterHelper.cleanupAfterTT(tlObj);
            return false;
        }
        HashMap normalTcdHash = new HashMap();
        int result = IntelligentTransactionHarvesterHelper.harvestTcdFromNormalTracer(sAgent, stckElement, tlObj, normalTcdHash);
        if (result == -1) {
            return false;
        }
        callback.prepareOnStartHarvestTransaction();
        ErrorElementsParameterContainer errorParamContainer = null;
        if (HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack.hasErrorSnapshotTriggered()) {
            errorParamContainer = HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack.getErrorElementsParameterContainer();
        }
        IntelligentTransactionHarvesterHelper.harvestTransactionFromIntelligentInstrumentationWithThrottle(ttTopOfStack, normalTcdHash, errorParamContainer, traceThrottleState, traceComonentMax, maxTraceDepth, result);
        TransactionComponentData finalRoot = ttTopOfStack.getTransactionComponentData();
        finalRoot = IntelligentTransactionHarvesterHelper.decorateRootComponent(finalRoot, stckElement, !passedNormalOrErrorFilter);
        IntelligentTransactionHarvesterHelper.validateTransactionFromIntelligentInstrumentation(finalRoot, null);
        if (!passedNormalOrErrorFilter) {
            IntelligentTransactionHarvesterHelper.decorateRootComponentWithAutoTracingParameters(finalRoot, stckElement);
        }
        sAgent.IAgent_getTransactionTraceController().ITransactionTraceListener_reportTransaction(finalRoot);
        IntelligentTransactionHarvesterHelper.cleanupAfterTT(tlObj);
        return true;
    }

    private static void decorateRootComponentWithAutoTracingParameters(TransactionComponentData finalRoot, IStackElement stckElement) {
        if (stckElement instanceof InvocationData) {
            InvocationData rootInvData = (InvocationData)stckElement;
            finalRoot.setParameterValue("Autotrace Trigger Criteria", rootInvData.getAutoTracingCollectStatus().getReason());
        }
    }

    protected static TransactionComponentData decorateRootComponent(TransactionComponentData finalRoot, IStackElement stckElement, boolean isAutoTrace) {
        TransactionComponentData bizDefComponent;
        TransactionComponentData root = finalRoot;
        if (!root.getResource().startsWith("Business Segment") && (bizDefComponent = TransactionHarvestHelper.buildBusinessTransactionComponent(root)) != null) {
            HighPerformanceIntelligentStackHelper.realizeSubcomponent(bizDefComponent);
            root = bizDefComponent;
        }
        root.getParameters().put("Trace Type", "Normal");
        TransactionCollectStatus tcs = stckElement.getTransactionCollectionStatus();
        if (tcs.isSampled()) {
            root.getParameters().put("Trace Type", "Sampled");
        }
        if (!isAutoTrace && tcs.isComponentClampAlreadyHitForTxn()) {
            root.setParameterValue("Components Not Shown", Integer.toString(tcs.getComponentClampAfterCount()));
        }
        root.setParameterValue("Instrumentation Level", sInstrumentationStatusManager.getCurrentStatus());
        return root;
    }

    public static boolean harvestTransactionHighPerformance(IAgent sAgent, int fResponseThreshold, IStackElement stckElement, ICallbackOnStartHarvestTransaction callback, boolean passedNormalOrErrorFilter) {
        HighPerformanceIntelligentFilter filter = HighPerformanceIntelligentFilter.getInstance();
        int traceThrottleState = filter.getTransactionTraceThrottleState();
        int traceComonentMax = filter.getSingleTransactionTraceComponentsMax();
        int maxTraceDepth = filter.getTransactionTraceMaxDepth();
        return IntelligentTransactionHarvesterHelper.harvestTransactionHighPerformanceWithThrottle(sAgent, fResponseThreshold, stckElement, callback, passedNormalOrErrorFilter, traceThrottleState, traceComonentMax, maxTraceDepth);
    }

    public static boolean harvestTransactionHighPerformanceWithThrottle(IAgent sAgent, int fResponseThreshold, IStackElement stckElement, ICallbackOnStartHarvestTransaction callback, boolean passedNormalOrErrorFilter, int transactionThrottleState, int componentMax, int maxTraceDepth) {
        TransactionComponentData bizDefComponent;
        boolean isNotEmpty;
        IntelligentInstrumentationThreadLocalObject tlObj = HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack.getThreadLocal().sIntelligentThreadLocalObject;
        boolean bl = isNotEmpty = tlObj.fTopOfStackForTT != null;
        if (transactionThrottleState == 2) {
            return false;
        }
        if (!isNotEmpty) {
            if (sAgent.IAgent_getModuleFeedback().isDebugEnabled()) {
                sAgent.IAgent_getModuleFeedback().debug("No method in stack, cannot report transaction trace.");
            }
            IntelligentTransactionHarvesterHelper.cleanupAfterTT(tlObj);
            return false;
        }
        if (!passedNormalOrErrorFilter) {
            if (sAgent.IAgent_getModuleFeedback().isDebugEnabled()) {
                sAgent.IAgent_getModuleFeedback().debug("Transaction did not pass Intelligent Instrumentation filter.");
            }
            IntelligentTransactionHarvesterHelper.cleanupAfterTT(tlObj);
            return false;
        }
        HashMap normalTcdHash = new HashMap();
        int result = IntelligentTransactionHarvesterHelper.harvestTcdFromNormalTracer(sAgent, stckElement, tlObj, normalTcdHash);
        if (result == -1) {
            return false;
        }
        callback.prepareOnStartHarvestTransaction();
        IIntelligentInstrumentationStackElement ttTopOfStack = tlObj.fTopOfStackForTT;
        IntelligentTransactionHarvesterHelper.harvestTransactionFromIntelligentInstrumentationWithThrottle(ttTopOfStack, normalTcdHash, null, transactionThrottleState, componentMax, maxTraceDepth, result);
        TransactionComponentData finalRoot = ttTopOfStack.getTransactionComponentData();
        if (!finalRoot.getResource().startsWith("Business Segment") && (bizDefComponent = TransactionHarvestHelper.buildBusinessTransactionComponent(finalRoot)) != null) {
            HighPerformanceIntelligentStackHelper.realizeSubcomponent(bizDefComponent);
            finalRoot = bizDefComponent;
        }
        finalRoot.getParameters().put("Trace Type", "Normal");
        TransactionCollectStatus tcs = stckElement.getTransactionCollectionStatus();
        if (tcs.isSampled()) {
            finalRoot.getParameters().put("Trace Type", "Sampled");
        }
        if (tcs.isComponentClampAlreadyHitForTxn()) {
            finalRoot.setParameterValue("Components Not Shown", Integer.toString(tcs.getComponentClampAfterCount()));
        }
        IntelligentTransactionHarvesterHelper.validateTransactionFromIntelligentInstrumentation(finalRoot, null);
        sAgent.IAgent_getTransactionTraceController().ITransactionTraceListener_reportTransaction(finalRoot);
        IntelligentTransactionHarvesterHelper.cleanupAfterTT(tlObj);
        return true;
    }

    public static void validateTransactionFromIntelligentInstrumentation(TransactionComponentData root, TransactionComponentData parent) {
        int numChildren;
        if (parent != null) {
            root.fixTimingData(parent);
        }
        if (root.getParameterValue("Total Methods") != null) {
            root.getParameters().remove("Total Methods");
        }
        if ((numChildren = root.getSubNodeCount()) > 0) {
            TransactionComponentData[] children = root.getSubNodes();
            int i = 0;
            while (i < numChildren) {
                IntelligentTransactionHarvesterHelper.validateTransactionFromIntelligentInstrumentation(children[i], root);
                ++i;
            }
        }
    }

    public static void cleanupAfterTT(IntelligentInstrumentationThreadLocalObject tlObj) {
        tlObj.reset();
    }

    private static void harvestTransactionFromIntelligentInstrumentationWithThrottle(IIntelligentInstrumentationStackElement rootElement, HashMap normalTcdMap, ErrorElementsParameterContainer errorParamContainer, int transactionThrottleState, int componentMax, int maxTraceDepth, int normalTcdCount) {
        IntelligentTransactionHarvesterHelper.createTcd(rootElement, normalTcdMap, errorParamContainer);
        IntelligentTransactionHarvesterHelper.decorateRootComponentWithError(rootElement);
        HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack deepStack = HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack.getThreadLocal();
        int stackElements = deepStack.getStackElementCount();
        int i = 2;
        while (i <= stackElements) {
            IIntelligentInstrumentationStackElement stackElement = deepStack.getElementAt(i);
            IntelligentTransactionHarvesterHelper.createTcd(stackElement, normalTcdMap, errorParamContainer);
            ++i;
        }
        IntelligentTransactionHarvesterHelper.joinTCDSubTrees(deepStack);
    }

    static void joinTCDSubTrees(HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack deepStack) {
        IIntelligentInstrumentationStackElement rootElement = deepStack.getElementAt(1);
        TransactionComponentData tcdRoot = rootElement.getTransactionComponentData();
        rootElement.reassignTcdCursor(null);
        int stackElements = deepStack.getStackElementCount();
        int i = 2;
        while (i <= stackElements) {
            IIntelligentInstrumentationStackElement stackElement = deepStack.getElementAt(i);
            stackElement.joinTCDSubTreeWithParent();
            ++i;
        }
        rootElement.reassignTcdCursor(tcdRoot);
    }

    private static void decorateRootComponentWithError(IIntelligentInstrumentationStackElement rootElement) {
        if (HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack.hasErrorSnapshotTriggered()) {
            TransactionComponentData tcd = rootElement.getTransactionComponentData();
            HighPerformanceIntelligenceStackElement exElem = HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack.getExceptionElement();
            if (exElem == null) {
                return;
            }
            String errorMessage = HighPerformanceIntelligentErrorFeature.constructErrorMessage(exElem);
            tcd.setParameterValue("Error Message", errorMessage);
            Throwable error = exElem.getInvocationThrownException();
            if (error != null) {
                StackTraceElement[] stackTraceElements = error.getStackTrace();
                if (stackTraceElements.length > 0) {
                    tcd.setParameterValue("Exception", InvocationData.limitSize(stackTraceElements[0].toString()));
                } else {
                    tcd.setParameterValue("Exception", errorMessage);
                }
            }
        }
    }

    private static void createTcd(IIntelligentInstrumentationStackElement ttTopOfStack, Map normalTcdMap, ErrorElementsParameterContainer errorParams) {
        IIntelligentInstrumentationStackElement rootElement = ttTopOfStack;
        int invocationId = rootElement.getInvocationId();
        if (invocationId != -1) {
            TransactionComponentData normalTcd = (TransactionComponentData)normalTcdMap.get(new Integer(invocationId));
            if (normalTcd != null) {
                rootElement.setTransactionComponentData(normalTcd);
            } else {
                IntelligentTransactionHarvesterHelper.createTcd(rootElement);
            }
            IntelligentTransactionHarvesterHelper.addParamsFromErrorSnapshot(errorParams, rootElement, invocationId);
            return;
        }
        IntelligentTransactionHarvesterHelper.decorateComponentWithParameters(rootElement);
    }

    static void createTcd(IIntelligentInstrumentationStackElement deepElement) {
        boolean result = IntelligentTransactionHarvesterHelper.createTcdWithWTS(deepElement);
        if (!result) {
            IntelligentTransactionHarvesterHelper.decorateComponentWithParameters(deepElement);
        }
    }

    private static boolean createTcdWithWTS(IIntelligentInstrumentationStackElement deepElement) {
        ITransactionElement txElement = deepElement.getLastTransactionElement();
        if (txElement != null) {
            boolean hasNoticedBackendElement = false;
            ArrayList<ITransactionElement> elements = new ArrayList<ITransactionElement>();
            while (txElement != null && txElement != deepElement.getFirstTransactionElement()) {
                elements.add(txElement);
                txElement = txElement.getParent();
            }
            elements.add(deepElement.getFirstTransactionElement());
            int i = elements.size();
            while (i > 0) {
                txElement = (ITransactionElement)elements.get(i - 1);
                if (txElement instanceof BlameTransactionElement) {
                    BlameTransactionElement be = (BlameTransactionElement)txElement;
                    IntelligentTransactionHarvesterHelper.createTcd(deepElement, be);
                    hasNoticedBackendElement = hasNoticedBackendElement || be.isBackend();
                } else {
                    IntelligentTransactionHarvesterHelper.decorateComponentWithParameters(deepElement);
                }
                --i;
            }
            if (hasNoticedBackendElement) {
                IntelligentTransactionHarvesterHelper.addParamsFromSocket(deepElement, deepElement.getLastTransactionElement());
            }
            return true;
        }
        return false;
    }

    private static void addParamsFromErrorSnapshot(ErrorElementsParameterContainer errorParams, IIntelligentInstrumentationStackElement rootElement, int invocationId) {
        if (errorParams != null && errorParams.hasErrorElement(invocationId)) {
            HashMap params = errorParams.getParameters(invocationId);
            TransactionComponentData tcd = rootElement.getTransactionComponentData();
            for (String param : params.keySet()) {
                if (param.equals("Trace Type") || tcd.getParameterValue(param) != null) continue;
                tcd.setParameterValue(param, (String)params.get(param));
            }
        }
    }

    private static void createTcd(IIntelligentInstrumentationStackElement rootElement, BlameTransactionElement blameElement) {
        String resourceName = blameElement.getResourceName();
        String componentName = resourceName != null ? resourceName : rootElement.getElementName();
        TransactionComponentData component = TransactionComponentData.createMilliSecTransactionComponentData(componentName, rootElement.getStartTime(), rootElement.getDuration());
        rootElement.setTransactionComponentData(component);
        Map parameters = component.getParameters();
        parameters.put("Method", rootElement.getProbeMethodName());
        parameters.put("Method Descriptor", rootElement.getProbeMethodDescriptor());
        parameters.put("Class", rootElement.getProbeClassName());
        if (rootElement.getInvocationId() == -1) {
            parameters.put("Method Score Level", rootElement.getProbeMethodScoreLevel());
        }
        if (blameElement instanceof IParamsProviderElement) {
            ((IParamsProviderElement)((Object)blameElement)).addParams(parameters);
        }
        if (HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack.isExceptionElement(((HighPerformanceIntelligenceStackElement)rootElement).fCurrentCursor)) {
            String errorMessage = HighPerformanceIntelligentErrorFeature.constructErrorMessage(rootElement);
            errorMessage = InvocationData.limitSize(errorMessage);
            parameters.put("Trace Type", "Normal");
            parameters.put("Error Message", errorMessage);
            Throwable error = ((HighPerformanceIntelligenceStackElement)rootElement).getInvocationThrownException();
            if (error != null) {
                StackTraceElement[] stackTraceElements = error.getStackTrace();
                if (stackTraceElements.length > 0) {
                    parameters.put("Exception", InvocationData.limitSize(stackTraceElements[0].toString()));
                } else {
                    parameters.put("Exception", errorMessage);
                }
            }
        }
    }

    private static void decorateComponentWithParameters(IIntelligentInstrumentationStackElement ttTopOfStack) {
        IIntelligentInstrumentationStackElement rootElement = ttTopOfStack;
        String componentName = rootElement.getElementName();
        TransactionComponentData component = TransactionComponentData.createMilliSecTransactionComponentData(componentName, rootElement.getStartTime(), rootElement.getDuration());
        rootElement.setTransactionComponentData(component);
        Map parameters = component.getParameters();
        parameters.put("Method", rootElement.getProbeMethodName());
        parameters.put("Method Descriptor", rootElement.getProbeMethodDescriptor());
        parameters.put("Class", rootElement.getProbeClassName());
        if (rootElement.getInvocationId() == -1) {
            parameters.put("Method Score Level", rootElement.getProbeMethodScoreLevel());
            parameters.put("Is Unmonitored", "True");
        }
        if (HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack.isExceptionElement(((HighPerformanceIntelligenceStackElement)rootElement).fCurrentCursor)) {
            String errorMessage = HighPerformanceIntelligentErrorFeature.constructErrorMessage(rootElement);
            errorMessage = InvocationData.limitSize(errorMessage);
            parameters.put("Error Message", errorMessage);
            Throwable error = ((HighPerformanceIntelligenceStackElement)rootElement).getInvocationThrownException();
            if (error != null) {
                StackTraceElement[] stackTraceElements = error.getStackTrace();
                if (stackTraceElements.length > 0) {
                    parameters.put("Exception", InvocationData.limitSize(stackTraceElements[0].toString()));
                } else {
                    parameters.put("Exception", errorMessage);
                }
            }
        }
    }

    public static void submitTransactionToCache(IStackElement stckElement) {
        if (IntelligentTransactionHarvesterHelper.isDownStreamAgentForTx()) {
            HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack highPerformanceCallBack = HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack.getThreadLocal();
            highPerformanceCallBack.shouldCache(true);
            highPerformanceCallBack.prepareOnStartHarvestTransaction();
            IntelligentTransactionHarvesterHelper.prepareTopTCDElementsForCache(stckElement);
            HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack.tearDown();
        } else {
            HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack highPerformanceCallBack = HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack.getThreadLocal();
            highPerformanceCallBack.prepareOnStartHarvestTransaction();
            HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack.tearDown();
        }
    }

    private static boolean isDownStreamAgentForTx() {
        SharedCrossProcessData cpCache = CrossProcessCorrelationAdmin.getCrossProcessCorrelationCache();
        if (cpCache != null) {
            return cpCache.hasRemotelyGeneratedCorrelationId();
        }
        return false;
    }

    private static void decorateComponentWithProbeInfo(HashMap parameters, ProbeInformation probeInfo) {
        if (probeInfo != null) {
            parameters.put("Method", probeInfo.getProbeIdentification().getProbeMethodName());
            parameters.put("Method Descriptor", probeInfo.getProbeIdentification().getProbeMethodDescriptor());
            parameters.put("Class", probeInfo.getProbeIdentification().getRuntimeFullClassName());
            IFactoryLevelParameterCallback[] staticCallbacks = probeInfo.getCallbacks();
            int i = 0;
            while (i < staticCallbacks.length) {
                if (staticCallbacks[i] != null) {
                    staticCallbacks[i].IFactoryLevelParameterCallback_addParameters(parameters);
                }
                ++i;
            }
        }
    }

    private static void addParamsFromSocket(IIntelligentInstrumentationStackElement rootElement, ITransactionElement txnElement) {
        Map socketParams = IntelligentTransactionHarvesterHelper.fetchSocketParameters(txnElement);
        if (!socketParams.isEmpty()) {
            TransactionComponentData tcd = rootElement.getTransactionComponentData();
            while (tcd != null) {
                tcd.getParameters().putAll(socketParams);
                IEventDataNode iEventDataNode = tcd = tcd.getSubNodeCount() > 0 ? tcd.getSubNode(0) : null;
            }
        }
    }

    private static Map fetchSocketParameters(ITransactionElement txnElement) {
        if (txnElement.hasChildren()) {
            HashMap parameters = new HashMap(5);
            Iterator it = txnElement.iterateChildren();
            int index = 1;
            while (it.hasNext()) {
                ITransactionElement el;
                ITransactionElement next = (ITransactionElement)it.next();
                if (next instanceof SocketTransactionElement) {
                    TransactionHarvestHelper.includeSocketParams(index++, (SocketTransactionElement)next, parameters);
                    continue;
                }
                if (!(next instanceof SetElement) || !((el = ((SetElement)next).getElement()) instanceof SocketTransactionElement)) continue;
                TransactionHarvestHelper.includeSocketParams(index++, (SocketTransactionElement)el, parameters);
            }
            return parameters;
        }
        return Collections.emptyMap();
    }
}

