/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.transactiontrace;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.transactiontrace.CrossCorrelationListParameterProvider;
import com.wily.introscope.agent.transactiontrace.CrossCorrelationStringParameterProvider;
import com.wily.introscope.agent.transactiontrace.ISharedCrossProcessData;
import com.wily.introscope.spec.server.transactiontrace.SequenceId;
import com.wily.util.WilyStringBuilder;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.wilyassert.Assertion;
import com.wily.wilyassert.UnimplementedException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SharedCrossProcessData
implements ISharedCrossProcessData {
    private static IAgent fAgent;
    public static final String kCrossProcessDataKey = "CorCrossProcessData";
    public static final String kCrossProcessSeqNoKey = "SeqNoCrossProcessData";
    public static final String kTransactionPropagationFlag = "TransactionPropagationFlag";
    public static final String kOutgoingSeqeunceId = "OutgoingSeqNo";
    public static final String kCallerName = "CallerName";
    public static final String kCallerNodeType = "CallerNodeType";
    public static final String kDependencyPropagationFlag = "DependencyPropagationFlag";
    public static final String kTxnTraceId = "TxnTraceId";
    public static final String kCallerTxnTraceTd = "CallerTxnTraceId";
    public static final String kNonBlockingThreadTxnKey = "NBThreadTxn";
    public static final String kCallerTimestampKey = "CallerTimestamp";
    public static final String kLogicalCaller = "LogicalCaller";
    public static final String kLogicalCallerNodeType = "LogicalCallerNodeType";
    public static final String kIsAutoTraced = "IsAutoTraced";
    public static final String kUpstreamGUIDCache = "UpstreamGUIDCache";
    private SequenceId fInternalSequenceID;
    private String fCorrelationId;
    private boolean fCorrelationIdRemotelyGen = false;
    private boolean fFirstInProcessFlag = true;
    private int fPropagationFlag = 0;
    private Integer fIncomingPropagationFlag = null;
    private int fDepPropagationFlag = 0;
    private String fOutgoingCallerNodeId = "";
    private String fIncomingCalledByNodeId = "";
    private String fOutgoingCallerNodeType = "";
    private String fIncomingCalledByNodeType = "";
    private int fCorrelationCount = 0;
    private HashMap fOptionalParamsIn;
    private HashMap fOptionalParamsOut;
    private static volatile List fCrossProcessDataCallBacks;
    private static volatile List kPostCrossProcessCallBacks;
    private static volatile List fOnCorrelationCallBacks;
    private volatile int fComponentCount;

    static {
        fCrossProcessDataCallBacks = new ArrayList();
        kPostCrossProcessCallBacks = new ArrayList();
        fOnCorrelationCallBacks = new ArrayList();
    }

    public SharedCrossProcessData() {
        if (fAgent == null) {
            try {
                fAgent = AgentShim.getAgent();
            }
            catch (AgentNotAvailableException agentNotAvailableException) {}
        }
    }

    public static SharedCrossProcessData createNewInstance(String corid, String seqid, int propFlag) {
        SharedCrossProcessData data = new SharedCrossProcessData();
        data.setCorrelationID(corid);
        data.createSeqID(seqid);
        data.setPropagationFlag(propFlag);
        data.fOptionalParamsOut = new HashMap();
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCrossProcessDataCallback(ICrossProcessDataCallBack cbo, IAgent agent) {
        if (cbo != null) {
            ArrayList<ICrossProcessDataCallBack> shallowCopy = new ArrayList<ICrossProcessDataCallBack>(fCrossProcessDataCallBacks.size() + 1);
            List list = fCrossProcessDataCallBacks;
            synchronized (list) {
                shallowCopy.addAll(fCrossProcessDataCallBacks);
            }
            if (shallowCopy.size() < 6) {
                if (agent != null) {
                    agent.IAgent_getModuleFeedback().debug("Adding callback to cross process cache: size is " + shallowCopy.size());
                }
                shallowCopy.add(cbo);
            } else {
                if (agent != null) {
                    agent.IAgent_getModuleFeedback().debug("Cannot add callback to cross process cache: size is " + shallowCopy.size());
                }
                Assertion.wilyAssert(false);
            }
            list = fCrossProcessDataCallBacks;
            synchronized (list) {
                if (fCrossProcessDataCallBacks.size() == shallowCopy.size() - 1) {
                    fCrossProcessDataCallBacks = shallowCopy;
                    return;
                }
            }
            SharedCrossProcessData.addCrossProcessDataCallback(cbo, agent);
        }
    }

    public static void addCrossProcessDataCallback(ICrossProcessDataCallBack cbo) {
        SharedCrossProcessData.addCrossProcessDataCallback(cbo, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addOnCorrelationIncomingCallback(IOnCorrelationIncomingCallBack cbo, IAgent agent) {
        if (cbo != null) {
            ArrayList<IOnCorrelationIncomingCallBack> shallowCopy = new ArrayList<IOnCorrelationIncomingCallBack>(fOnCorrelationCallBacks.size() + 1);
            List list = fOnCorrelationCallBacks;
            synchronized (list) {
                shallowCopy.addAll(fOnCorrelationCallBacks);
            }
            if (shallowCopy.size() < 5) {
                if (agent != null) {
                    agent.IAgent_getModuleFeedback().debug("Adding correlation incoming callback to cross process cache: size is " + shallowCopy.size());
                }
                shallowCopy.add(cbo);
            } else {
                if (agent != null) {
                    agent.IAgent_getModuleFeedback().debug("Cannot add correlation incoming callback to cross process cache: size is " + shallowCopy.size());
                }
                Assertion.wilyAssert(false);
            }
            list = fOnCorrelationCallBacks;
            synchronized (list) {
                if (fOnCorrelationCallBacks.size() == shallowCopy.size() - 1) {
                    fOnCorrelationCallBacks = shallowCopy;
                    return;
                }
            }
            SharedCrossProcessData.addOnCorrelationIncomingCallback(cbo, agent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPostCrossProcessCallback(IPostCrossProcessCallBack cb) {
        if (cb != null) {
            ArrayList<IPostCrossProcessCallBack> shallowCopy = new ArrayList<IPostCrossProcessCallBack>(kPostCrossProcessCallBacks.size() + 1);
            List list = kPostCrossProcessCallBacks;
            synchronized (list) {
                shallowCopy.addAll(kPostCrossProcessCallBacks);
            }
            shallowCopy.add(cb);
            list = kPostCrossProcessCallBacks;
            synchronized (list) {
                if (kPostCrossProcessCallBacks.size() == shallowCopy.size() - 1) {
                    kPostCrossProcessCallBacks = shallowCopy;
                    return;
                }
            }
            SharedCrossProcessData.addPostCrossProcessCallback(cb);
        }
    }

    public void markNextCrossProcessCallAsNonBlocking() {
        this.addParamOut(kNonBlockingThreadTxnKey, "true");
    }

    public int incrementCorrelationCount() {
        return this.fCorrelationCount++;
    }

    public int decrementCorrelationCount() {
        return --this.fCorrelationCount;
    }

    public void setCorrelationID(String corID, boolean locallyGen) {
        if (locallyGen) {
            Assertion.wilyAssert(false);
            if (this.fCorrelationId == null) {
                this.fCorrelationId = corID;
            } else if (fAgent.IAgent_getModuleFeedback().isDebugEnabled()) {
                fAgent.IAgent_getModuleFeedback().debug("SharedCrossProcessData  setCorrelationID : attempt to override correlationID  locally generated one with another existing GUID ");
            }
        } else {
            this.setCorrelationID(corID);
        }
    }

    public void setCorrelationID(String corID) {
        if (this.fCorrelationId == null) {
            this.fCorrelationId = corID;
            this.fCorrelationIdRemotelyGen = true;
        } else if (this.fCorrelationIdRemotelyGen) {
            if (this.fCorrelationId != null && corID.equals(this.fCorrelationId)) {
                try {
                    IAgent agent = AgentShim.getAgent();
                    agent.IAgent_getModuleFeedback().debug("SharedCrossProcessData correlationId already set, but the same");
                }
                catch (AgentNotAvailableException e) {
                    e.printStackTrace();
                }
            } else {
                Assertion.wilyAssert(false);
            }
        } else {
            this.fCorrelationIdRemotelyGen = true;
            this.fCorrelationId = corID;
        }
    }

    public boolean overrideCorrelationId(String corId) {
        this.fCorrelationIdRemotelyGen = true;
        if (this.fCorrelationId == null) {
            this.fCorrelationId = corId;
            return false;
        }
        this.fCorrelationId = corId;
        return true;
    }

    public String getCorrelationID() {
        return this.fCorrelationId;
    }

    public void addParamOut(String key, String value) {
        if (this.fOptionalParamsOut == null) {
            this.fOptionalParamsOut = new HashMap();
        }
        this.fOptionalParamsOut.put(key, value);
    }

    public void addParamOut(String key, ArrayList value) {
        if (this.fOptionalParamsOut == null) {
            this.fOptionalParamsOut = new HashMap();
        }
        this.fOptionalParamsOut.put(key, value);
    }

    public void addParamOut(String key, CrossCorrelationStringParameterProvider value) {
        if (this.fOptionalParamsOut == null) {
            this.fOptionalParamsOut = new HashMap();
        }
        this.fOptionalParamsOut.put(key, value);
    }

    public void addParamOut(String key, CrossCorrelationListParameterProvider value) {
        if (this.fOptionalParamsOut == null) {
            this.fOptionalParamsOut = new HashMap();
        }
        this.fOptionalParamsOut.put(key, value);
    }

    public String getStringParamOut(String key) {
        if (this.fOptionalParamsOut == null) {
            this.fOptionalParamsOut = new HashMap();
            return null;
        }
        Object o = this.fOptionalParamsOut.get(key);
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof CrossCorrelationStringParameterProvider) {
            String result = ((CrossCorrelationStringParameterProvider)o).getParam(key);
            this.fOptionalParamsOut.put(key, result);
            return result;
        }
        return null;
    }

    public Object getObjectParamOut(String key) {
        if (this.fOptionalParamsOut == null) {
            this.fOptionalParamsOut = new HashMap();
            return null;
        }
        Object o = this.fOptionalParamsOut.get(key);
        if (o instanceof CrossCorrelationStringParameterProvider) {
            String result = ((CrossCorrelationStringParameterProvider)o).getParam(key);
            this.fOptionalParamsOut.put(key, result);
            return result;
        }
        if (o instanceof CrossCorrelationListParameterProvider) {
            List result = ((CrossCorrelationListParameterProvider)o).getParam(key);
            this.fOptionalParamsOut.put(key, result);
            return result;
        }
        return o;
    }

    public List getListParamOut(String key) {
        if (this.fOptionalParamsOut == null) {
            this.fOptionalParamsOut = new HashMap();
            return null;
        }
        Object o = this.fOptionalParamsOut.get(key);
        if (o instanceof ArrayList) {
            return (List)o;
        }
        if (o instanceof CrossCorrelationListParameterProvider) {
            List result = ((CrossCorrelationListParameterProvider)o).getParam(key);
            this.fOptionalParamsOut.put(key, result);
            return result;
        }
        return null;
    }

    public String getStringParamIn(String key) {
        Object o;
        if (this.fOptionalParamsIn == null) {
            this.fOptionalParamsIn = new HashMap();
        }
        if ((o = this.fOptionalParamsIn.get(key)) instanceof String) {
            return (String)o;
        }
        return null;
    }

    public List getListParamIn(String key) {
        Object o;
        if (this.fOptionalParamsIn == null) {
            this.fOptionalParamsIn = new HashMap();
        }
        if ((o = this.fOptionalParamsIn.get(key)) == null) {
            return null;
        }
        if (o instanceof ArrayList) {
            return (List)o;
        }
        return null;
    }

    public void removeParamOut(String key) {
        if (this.fOptionalParamsOut != null) {
            this.fOptionalParamsOut.remove(key);
        }
    }

    public void copyOptionalParamsIn(SharedCrossProcessData data) {
        this.copyOptionalParamsIn(data.fOptionalParamsIn);
    }

    public void copyOptionalParamsIn(HashMap map) {
        this.fOptionalParamsIn = map;
    }

    public int getDependencyPropagationFlag() {
        return this.fDepPropagationFlag;
    }

    public void setDependencyPropagationFlag(int depFlag) {
        if (depFlag == 1) {
            this.fDepPropagationFlag = depFlag;
        }
    }

    public String getOutgoingCallerNodeId() {
        return this.fOutgoingCallerNodeId;
    }

    public void setOutgoingCallerNodeId(String callerNodeId) {
        this.fOutgoingCallerNodeId = callerNodeId;
    }

    public String getOutgoingCallerNodeType() {
        return this.fOutgoingCallerNodeType;
    }

    public void setOutgoingCallerNodeType(String callerNodeType) {
        this.fOutgoingCallerNodeType = callerNodeType;
    }

    public String getIncomingCalledByNodeId() {
        return this.fIncomingCalledByNodeId;
    }

    public void setIncomingCalledByNodeId(String nodeId) {
        this.fIncomingCalledByNodeId = nodeId;
    }

    public String getIncomingCalledByNodeType() {
        return this.fIncomingCalledByNodeType;
    }

    public void setIncomingCalledByNodeType(String nodeType) {
        this.fIncomingCalledByNodeType = nodeType;
    }

    public int getPropagationFlag() {
        return this.fPropagationFlag;
    }

    public void setPropagationFlag(int flag) {
        Assertion.wilyAssert(false);
        if (this.fPropagationFlag == 1 && flag == 0) {
            Assertion.wilyAssert(false);
        }
        this.fPropagationFlag = flag;
    }

    public void setIncomingPropagationFlag(int flag) {
        if (flag == 1 || this.fIncomingPropagationFlag == null) {
            this.fIncomingPropagationFlag = new Integer(flag);
        }
    }

    public Boolean isMarkedForSympatheticCrossJVMTracing() {
        return this.fIncomingPropagationFlag == null ? null : (this.fIncomingPropagationFlag == 1 ? Boolean.TRUE : Boolean.FALSE);
    }

    public void markForSympatheticCrossJVMTracing(ISharedCrossProcessData currentData, IModuleFeedbackChannel feedback) {
        throw new UnimplementedException("Please use setPropagationFlag API");
    }

    public void createSeqID() {
        this.fInternalSequenceID = new SequenceId();
    }

    public void createSeqID(String initialValue) {
        SequenceId currentSeqId = this.getSeqID();
        if (currentSeqId == null) {
            this.fInternalSequenceID = new SequenceId(initialValue);
        } else {
            SequenceId newSeqID = new SequenceId(initialValue);
            if (newSeqID.compareTo(currentSeqId) >= 0) {
                this.fInternalSequenceID = newSeqID;
            }
        }
    }

    public SequenceId getSeqID() {
        return this.fInternalSequenceID;
    }

    public void incrementSequenceId() {
        if (this.fInternalSequenceID != null) {
            this.fInternalSequenceID.incrementOutgoingLevel();
        }
    }

    private SequenceId safeUpdateSeqIDforOutgoingProcess(IModuleFeedbackChannel feedback) {
        if (this.fInternalSequenceID != null) {
            this.fInternalSequenceID.incrementOutgoingLevel();
        } else {
            this.createSeqID();
            this.fInternalSequenceID.incrementOutgoingLevel();
            feedback.debug("SharedCrossProcessData: updateSeqIDforOutgoingProcess there was no pre-existing SequenceId, creating a new one");
        }
        return this.fInternalSequenceID;
    }

    public SequenceId retrieveSeqIDforOutgoingProcess(IModuleFeedbackChannel feedback) {
        return this.safeUpdateSeqIDforOutgoingProcess(feedback);
    }

    public static void writeStream(ByteArrayOutputStream stream, SharedCrossProcessData data) throws IOException {
        String seqId;
        stream.write(data.getCorrelationID().length());
        stream.write(data.getCorrelationID().getBytes());
        SequenceId seq = data.getSeqID();
        if (seq != null && (seqId = seq.getSequenceIdOutgoingFormat()) != null) {
            stream.write(seqId.length());
            stream.write(data.getPropagationFlag());
            stream.write(seqId.length());
            stream.write(seqId.getBytes());
        }
        stream.write(data.getPropagationFlag());
    }

    public static SharedCrossProcessData readStream(ByteArrayInputStream stream) throws IOException {
        int stringLen = stream.read();
        if (stringLen < 0) {
            return null;
        }
        byte[] coridBytes = new byte[stringLen];
        if (stream.read(coridBytes, 0, stringLen) != stringLen) {
            throw new IOException("Corrupted correlation ID in trace data");
        }
        stream.read();
        stream.read();
        stringLen = stream.read();
        if (stringLen < 0) {
            return SharedCrossProcessData.createNewInstance(new String(coridBytes), "1", 0);
        }
        byte[] seqidBytes = new byte[stringLen];
        if (stream.read(seqidBytes, 0, stringLen) != stringLen) {
            throw new IOException("Corrupted correlation ID in trace data");
        }
        int propFlag = stream.read();
        if (propFlag < 0) {
            propFlag = 0;
        }
        return SharedCrossProcessData.createNewInstance(new String(coridBytes), new String(seqidBytes), propFlag);
    }

    public void syncCache(SerializableSharedCrossProcessData data) {
        this.fCorrelationId = data.corid;
        if (this.fCorrelationId != null) {
            this.fCorrelationIdRemotelyGen = true;
        }
        this.createSeqID(data.seqId);
        this.fPropagationFlag = data.propFlag;
        this.fIncomingPropagationFlag = new Integer(data.propFlag);
        this.copyOptionalParamsIn(data.optionalParams);
        this.markIncomingCorrelation();
    }

    public void doPostCrossProcessCleanup() {
        for (IPostCrossProcessCallBack cbo : kPostCrossProcessCallBacks) {
            cbo.postCrossProcessCleanup(this);
        }
    }

    public SerializableSharedCrossProcessData getOutgoingSerializableInstance() {
        for (ICrossProcessDataCallBack cbo : fCrossProcessDataCallBacks) {
            cbo.prepareOptionalParameters(this);
        }
        String componentId = String.valueOf(++this.fComponentCount);
        this.addParamOut("Caller Component ID", componentId);
        HashMap paramsout = new HashMap(this.fOptionalParamsOut);
        SerializableSharedCrossProcessData serObj = new SerializableSharedCrossProcessData(this.fCorrelationId, this.fInternalSequenceID.getCurrentOutgoingSequenceId(), fAgent.IAgent_getComponentTracer().shouldCurrentTraceBePropagated() ? 1 : 0, paramsout);
        return serObj;
    }

    public void markIncomingCorrelation() {
        for (IOnCorrelationIncomingCallBack cbo : fOnCorrelationCallBacks) {
            cbo.doOnCorrelation(this);
        }
    }

    public SharedCrossProcessData getOutgoingNonSerializedInstance() {
        for (ICrossProcessDataCallBack cbo : fCrossProcessDataCallBacks) {
            cbo.prepareOptionalParameters(this);
        }
        SharedCrossProcessData obj = SharedCrossProcessData.createNewInstance(this.fCorrelationId, this.fInternalSequenceID.getCurrentOutgoingSequenceId(), fAgent.IAgent_getComponentTracer().shouldCurrentTraceBePropagated() ? 1 : 0);
        obj.fOptionalParamsIn = new HashMap(this.fOptionalParamsOut);
        return obj;
    }

    public boolean isFirstInProcessFlag() {
        return this.fFirstInProcessFlag;
    }

    public void setFirstInProcessFlag(boolean firstInProcessFlag) {
        this.fFirstInProcessFlag = firstInProcessFlag;
    }

    public void clear() {
        this.fInternalSequenceID = null;
        this.fCorrelationId = null;
        this.fCorrelationIdRemotelyGen = false;
        this.fFirstInProcessFlag = true;
        this.fPropagationFlag = 0;
        this.fIncomingPropagationFlag = null;
        this.fDepPropagationFlag = 0;
        this.fOutgoingCallerNodeId = "";
        this.fIncomingCalledByNodeId = "";
        this.fOutgoingCallerNodeType = "";
        this.fIncomingCalledByNodeType = "";
        this.fCorrelationCount = 0;
        if (this.fOptionalParamsIn != null) {
            this.fOptionalParamsIn.clear();
        }
        if (this.fOptionalParamsOut != null) {
            this.fOptionalParamsOut.clear();
        }
        this.setComponentCount(0);
    }

    public String getCorrelationBlameKey() {
        String appNameIn;
        ArrayList<String> appNamesIn = this.getListParamIn("AppMapAppNames");
        if (appNamesIn == null && (appNameIn = this.getStringParamIn("AppMapAppNames")) != null) {
            appNamesIn = new ArrayList<String>(1);
            appNamesIn.add(appNameIn);
        }
        String appNamesKey = appNamesIn == null ? null : ((Object)appNamesIn).toString();
        String btcIn = this.getStringParamIn("AppMapBtcId");
        String classIn = this.getStringParamIn("AppMapCallerMethodName");
        String agentIn = this.getStringParamIn("AppMapCallerAgent");
        if (appNamesKey != null || btcIn != null || classIn != null || agentIn != null) {
            return new WilyStringBuilder(128).append(appNamesKey).append(btcIn).append(agentIn).append(classIn).toString();
        }
        return null;
    }

    public boolean hasRemotelyGeneratedCorrelationId() {
        return this.fCorrelationIdRemotelyGen;
    }

    public void setComponentCount(int i) {
        this.fComponentCount = i;
    }

    public static interface ICrossProcessDataCallBack {
        public void prepareOptionalParameters(SharedCrossProcessData var1);
    }

    public static interface IOnCorrelationIncomingCallBack {
        public void doOnCorrelation(SharedCrossProcessData var1);
    }

    public static interface IPostCrossProcessCallBack {
        public void postCrossProcessCleanup(SharedCrossProcessData var1);
    }

    public static class SerializableSharedCrossProcessData
    implements Serializable {
        String seqId;
        String corid;
        int propFlag;
        HashMap optionalParams;
        private static final long serialVersionUID = 77692763496594148L;

        SerializableSharedCrossProcessData(String corrID, String sequenceId, int pFlag, HashMap params) {
            this.corid = corrID;
            this.seqId = sequenceId;
            this.propFlag = pFlag;
            this.optionalParams = this.prepareForSerialization(params);
        }

        public String getCorId() {
            return this.corid;
        }

        private HashMap prepareForSerialization(HashMap params) {
            if (params != null) {
                for (Object key : params.keySet()) {
                    Object value;
                    if (key == null || (value = params.get(key)) == null) continue;
                    if (value instanceof CrossCorrelationStringParameterProvider) {
                        params.put(key, ((CrossCorrelationStringParameterProvider)value).getParam(key.toString()));
                        continue;
                    }
                    if (!(value instanceof CrossCorrelationListParameterProvider)) continue;
                    params.put(key, ((CrossCorrelationListParameterProvider)value).getParam(key.toString()));
                }
            }
            return params;
        }
    }
}

