/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.probebuilder;

import com.wily.diagnos.cmp.batch.CompilerEnvironment;
import com.wily.util.StringUtils;
import com.wily.util.commandline.ACommandLineParser;
import com.wily.util.commandline.CommandLine;
import com.wily.util.commandline.ICommandLineParser;
import com.wily.util.commandline.ParsingException;
import com.wily.util.text.IStringLocalizer;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public abstract class AProbeBuilderCommandLine
extends CommandLine {
    private static final String kListSeparator = ",";
    private static final String[] kHelpOptions = new String[]{"-help", "-h", "-?"};
    private static final String[] kDirectivesOptions = new String[]{"-directives", "-pbd"};
    private static final String[] kSourceDirOptions = new String[]{"-origdir", "-srcdir"};
    private static final String[] kDestDirOptions = new String[]{"-destdir"};
    private static final String[] kSourceJarOptions = new String[]{"-origjar", "-srcjar"};
    private static final String[] kDestJarOptions = new String[]{"-destjar"};
    private static final String[] kSourceClassOptions = new String[]{"-origclass", "-srcclass"};
    private static final String[] kDestClassOptions = new String[]{"-destclass"};
    private static final String[] kLogRedirectOptions = new String[]{"-log"};
    private static final String[] kSkipItemsOptions = new String[]{"-skipitems"};
    private static final String[] kVerboseOptions = new String[]{"-verbose", "-v"};
    private static final String[] kCommandLineUIOptions = new String[]{"-prompt"};
    private static final String[] kSourceAssemblyOptions = new String[]{"-origassembly", "-srcassembly"};
    private static final String[] kDestAssemblyOptions = new String[]{"-destassembly"};
    private CompilerEnvironment fProbeBuilderEnvironment;
    private IStringLocalizer fStringLocalizer;

    protected AProbeBuilderCommandLine(String[] commandLineStrings, IStringLocalizer localizer) {
        super(commandLineStrings);
        this.fStringLocalizer = localizer;
        this.fProbeBuilderEnvironment = new CompilerEnvironment(localizer);
    }

    public final void initialize() {
        ArrayList<ACommandLineParser> parserList = new ArrayList<ACommandLineParser>();
        parserList.add(new HelpParser());
        parserList.add(new DirectivesParser());
        this.doAddRuntimeSpecificParsers(parserList);
        parserList.add(new LogRedirectParser());
        parserList.add(new SkipItemsParser());
        parserList.add(new VerboseParser());
        parserList.add(new CommandLineUIParser());
        ICommandLineParser[] parserArray = parserList.toArray(new ICommandLineParser[0]);
        this.setParsers(parserArray);
    }

    protected abstract void doAddRuntimeSpecificParsers(List var1);

    public CompilerEnvironment getProbeBuilderEnvironment() {
        return this.fProbeBuilderEnvironment;
    }

    public IStringLocalizer getStringLocalizer() {
        return this.fStringLocalizer;
    }

    public void printHelp(PrintWriter output) {
        output.println(this.getStringLocalizer().IStringLocalizer_getLocalizedString("Probe_Builder_Command_Line_Help_Body"));
        output.println(this.getStringLocalizer().IStringLocalizer_getLocalizedString("Probe_Builder_Command_Line_Options_Header"));
        this.iterateParserHelp(output);
        output.flush();
    }

    private class CommandLineUIParser
    extends ACommandLineParser {
        public CommandLineUIParser() {
            super(kCommandLineUIOptions);
        }

        public void ICommandLineParser_parseCommand(CommandLine commandLine, String currentCommand) {
            AProbeBuilderCommandLine.this.getProbeBuilderEnvironment().setCommandLineUIMode(true);
        }

        public String ISingleCommandHelpProvider_getHelpText() {
            return AProbeBuilderCommandLine.this.getStringLocalizer().IStringLocalizer_getLocalizedString("Probe_Builder_Command_Line_Help_Command_Line_UI_Command");
        }
    }

    protected class DestinationAssemblyParser
    extends ACommandLineParser {
        public DestinationAssemblyParser() {
            super(kDestAssemblyOptions);
        }

        public void ICommandLineParser_parseCommand(CommandLine commandLine, String currentCommand) throws ParsingException {
            String destAssembly = AProbeBuilderCommandLine.this.consumeNextCommand(AProbeBuilderCommandLine.this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Probe_Builder_Command_Line_Missing_Argument", currentCommand));
            CompilerEnvironment env = AProbeBuilderCommandLine.this.getProbeBuilderEnvironment();
            if (env.hasInstrumentedDestinationAssembly()) {
                AProbeBuilderCommandLine.this.throwParsingException(AProbeBuilderCommandLine.this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Probe_Builder_Command_Line_Specified_Only_Once", currentCommand));
            }
            env.setInstrumentedDestinationAssembly(destAssembly);
        }

        public String ISingleCommandHelpProvider_getArgumentPrompt() {
            return AProbeBuilderCommandLine.this.getStringLocalizer().IStringLocalizer_getLocalizedString("Probe_Builder_Command_Line_Help_File_Argument");
        }

        public String ISingleCommandHelpProvider_getHelpText() {
            return AProbeBuilderCommandLine.this.getStringLocalizer().IStringLocalizer_getLocalizedString("Probe_Builder_Command_Line_Help_Dest_Assembly_Command");
        }
    }

    protected class DestinationClassParser
    extends ACommandLineParser {
        public DestinationClassParser() {
            super(kDestClassOptions);
        }

        public void ICommandLineParser_parseCommand(CommandLine commandLine, String currentCommand) throws ParsingException {
            String destClass = AProbeBuilderCommandLine.this.consumeNextCommand(AProbeBuilderCommandLine.this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Probe_Builder_Command_Line_Missing_Argument", currentCommand));
            CompilerEnvironment env = AProbeBuilderCommandLine.this.getProbeBuilderEnvironment();
            if (env.hasInstrumentedDestinationClass()) {
                AProbeBuilderCommandLine.this.throwParsingException(AProbeBuilderCommandLine.this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Probe_Builder_Command_Line_Specified_Only_Once", currentCommand));
            }
            env.setInstrumentedDestinationClass(destClass);
        }

        public String ISingleCommandHelpProvider_getArgumentPrompt() {
            return AProbeBuilderCommandLine.this.getStringLocalizer().IStringLocalizer_getLocalizedString("Probe_Builder_Command_Line_Help_File_Argument");
        }

        public String ISingleCommandHelpProvider_getHelpText() {
            return AProbeBuilderCommandLine.this.getStringLocalizer().IStringLocalizer_getLocalizedString("Probe_Builder_Command_Line_Help_Dest_Class_Command");
        }
    }

    protected class DestinationDirectoryParser
    extends ACommandLineParser {
        public DestinationDirectoryParser() {
            super(kDestDirOptions);
        }

        public void ICommandLineParser_parseCommand(CommandLine commandLine, String currentCommand) throws ParsingException {
            String destDir = AProbeBuilderCommandLine.this.consumeNextCommand(AProbeBuilderCommandLine.this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Probe_Builder_Command_Line_Missing_Argument", currentCommand));
            CompilerEnvironment env = AProbeBuilderCommandLine.this.getProbeBuilderEnvironment();
            if (env.hasInstrumentedDestinationDirectory()) {
                AProbeBuilderCommandLine.this.throwParsingException(AProbeBuilderCommandLine.this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Probe_Builder_Command_Line_Specified_Only_Once", currentCommand));
            }
            env.setInstrumentedDestinationDirectory(destDir);
        }

        public String ISingleCommandHelpProvider_getArgumentPrompt() {
            return AProbeBuilderCommandLine.this.getStringLocalizer().IStringLocalizer_getLocalizedString("Probe_Builder_Command_Line_Help_Directory_Argument");
        }

        public String ISingleCommandHelpProvider_getHelpText() {
            return AProbeBuilderCommandLine.this.getStringLocalizer().IStringLocalizer_getLocalizedString("Probe_Builder_Command_Line_Help_Dest_Dir_Command");
        }
    }

    protected class DestinationJarParser
    extends ACommandLineParser {
        public DestinationJarParser() {
            super(kDestJarOptions);
        }

        public void ICommandLineParser_parseCommand(CommandLine commandLine, String currentCommand) throws ParsingException {
            String destJar = AProbeBuilderCommandLine.this.consumeNextCommand(AProbeBuilderCommandLine.this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Probe_Builder_Command_Line_Missing_Argument", currentCommand));
            CompilerEnvironment env = AProbeBuilderCommandLine.this.getProbeBuilderEnvironment();
            if (env.hasInstrumentedDestinationJar()) {
                AProbeBuilderCommandLine.this.throwParsingException(AProbeBuilderCommandLine.this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Probe_Builder_Command_Line_Specified_Only_Once", currentCommand));
            }
            env.setInstrumentedDestinationJar(destJar);
        }

        public String ISingleCommandHelpProvider_getArgumentPrompt() {
            return AProbeBuilderCommandLine.this.getStringLocalizer().IStringLocalizer_getLocalizedString("Probe_Builder_Command_Line_Help_File_Argument");
        }

        public String ISingleCommandHelpProvider_getHelpText() {
            return AProbeBuilderCommandLine.this.getStringLocalizer().IStringLocalizer_getLocalizedString("Probe_Builder_Command_Line_Help_Dest_Jar_Command");
        }
    }

    private class DirectivesParser
    extends ACommandLineParser {
        public DirectivesParser() {
            this(kDirectivesOptions);
        }

        public DirectivesParser(String[] options) {
            super(options);
        }

        public void ICommandLineParser_parseCommand(CommandLine commandLine, String currentCommand) throws ParsingException {
            String settings = AProbeBuilderCommandLine.this.consumeNextCommand(AProbeBuilderCommandLine.this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Probe_Builder_Command_Line_Missing_Argument", currentCommand));
            CompilerEnvironment env = AProbeBuilderCommandLine.this.getProbeBuilderEnvironment();
            if (env.hasUserDirectivesFiles()) {
                AProbeBuilderCommandLine.this.throwParsingException(AProbeBuilderCommandLine.this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Probe_Builder_Command_Line_Specified_Only_Once", currentCommand));
            }
            String[] filesList = StringUtils.parseList(settings, AProbeBuilderCommandLine.kListSeparator);
            env.setUserDirectivesFiles(filesList);
        }

        public String ISingleCommandHelpProvider_getArgumentPrompt() {
            return AProbeBuilderCommandLine.this.getStringLocalizer().IStringLocalizer_getLocalizedString("Probe_Builder_Command_Line_Help_File_List_Argument");
        }

        public String ISingleCommandHelpProvider_getHelpText() {
            return AProbeBuilderCommandLine.this.getStringLocalizer().IStringLocalizer_getLocalizedString("Probe_Builder_Command_Line_Help_Directives_Command");
        }
    }

    private class HelpParser
    extends ACommandLineParser {
        public HelpParser() {
            super(kHelpOptions);
        }

        public void ICommandLineParser_parseCommand(CommandLine commandLine, String currentCommand) {
            AProbeBuilderCommandLine.this.getProbeBuilderEnvironment().setHelpMode(true);
        }

        public String ISingleCommandHelpProvider_getHelpText() {
            return AProbeBuilderCommandLine.this.getStringLocalizer().IStringLocalizer_getLocalizedString("Probe_Builder_Command_Line_Help_Help_Command");
        }
    }

    private class LogRedirectParser
    extends ACommandLineParser {
        public LogRedirectParser() {
            super(kLogRedirectOptions);
        }

        public void ICommandLineParser_parseCommand(CommandLine commandLine, String currentCommand) throws ParsingException {
            String logLocation = AProbeBuilderCommandLine.this.consumeNextCommand(AProbeBuilderCommandLine.this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Probe_Builder_Command_Line_Missing_Argument", currentCommand));
            CompilerEnvironment env = AProbeBuilderCommandLine.this.getProbeBuilderEnvironment();
            if (env.hasLogLocation()) {
                AProbeBuilderCommandLine.this.throwParsingException(AProbeBuilderCommandLine.this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Probe_Builder_Command_Line_Specified_Only_Once", currentCommand));
            }
            env.setLogLocation(logLocation);
        }

        public String ISingleCommandHelpProvider_getArgumentPrompt() {
            return AProbeBuilderCommandLine.this.getStringLocalizer().IStringLocalizer_getLocalizedString("Probe_Builder_Command_Line_Help_File_Argument");
        }

        public String ISingleCommandHelpProvider_getHelpText() {
            return AProbeBuilderCommandLine.this.getStringLocalizer().IStringLocalizer_getLocalizedString("Probe_Builder_Command_Line_Help_Log_Redirect_Command");
        }
    }

    private class SkipItemsParser
    extends ACommandLineParser {
        public SkipItemsParser() {
            super(kSkipItemsOptions);
        }

        public void ICommandLineParser_parseCommand(CommandLine commandLine, String currentCommand) {
            AProbeBuilderCommandLine.this.getProbeBuilderEnvironment().setCopyItems(false);
        }

        public String ISingleCommandHelpProvider_getHelpText() {
            return AProbeBuilderCommandLine.this.getStringLocalizer().IStringLocalizer_getLocalizedString("Probe_Builder_Command_Line_Help_Skip_Items_Command");
        }
    }

    protected class SourceAssemblyParser
    extends ACommandLineParser {
        public SourceAssemblyParser() {
            super(kSourceAssemblyOptions);
        }

        public void ICommandLineParser_parseCommand(CommandLine commandLine, String currentCommand) throws ParsingException {
            String sourceAssembly = AProbeBuilderCommandLine.this.consumeNextCommand(AProbeBuilderCommandLine.this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Probe_Builder_Command_Line_Missing_Argument", currentCommand));
            CompilerEnvironment env = AProbeBuilderCommandLine.this.getProbeBuilderEnvironment();
            if (env.hasSourceAssembly()) {
                AProbeBuilderCommandLine.this.throwParsingException(AProbeBuilderCommandLine.this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Probe_Builder_Command_Line_Specified_Only_Once", currentCommand));
            }
            env.setSourceAssembly(sourceAssembly);
        }

        public String ISingleCommandHelpProvider_getArgumentPrompt() {
            return AProbeBuilderCommandLine.this.getStringLocalizer().IStringLocalizer_getLocalizedString("Probe_Builder_Command_Line_Help_File_Argument");
        }

        public String ISingleCommandHelpProvider_getHelpText() {
            return AProbeBuilderCommandLine.this.getStringLocalizer().IStringLocalizer_getLocalizedString("Probe_Builder_Command_Line_Help_Source_Assembly_Command");
        }
    }

    protected class SourceClassParser
    extends ACommandLineParser {
        public SourceClassParser() {
            super(kSourceClassOptions);
        }

        public void ICommandLineParser_parseCommand(CommandLine commandLine, String currentCommand) throws ParsingException {
            String sourceClass = AProbeBuilderCommandLine.this.consumeNextCommand(AProbeBuilderCommandLine.this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Probe_Builder_Command_Line_Missing_Argument", currentCommand));
            CompilerEnvironment env = AProbeBuilderCommandLine.this.getProbeBuilderEnvironment();
            if (env.hasSourceClass()) {
                AProbeBuilderCommandLine.this.throwParsingException(AProbeBuilderCommandLine.this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Probe_Builder_Command_Line_Specified_Only_Once", currentCommand));
            }
            env.setSourceClass(sourceClass);
        }

        public String ISingleCommandHelpProvider_getArgumentPrompt() {
            return AProbeBuilderCommandLine.this.getStringLocalizer().IStringLocalizer_getLocalizedString("Probe_Builder_Command_Line_Help_File_Argument");
        }

        public String ISingleCommandHelpProvider_getHelpText() {
            return AProbeBuilderCommandLine.this.getStringLocalizer().IStringLocalizer_getLocalizedString("Probe_Builder_Command_Line_Help_Source_Class_Command");
        }
    }

    protected class SourceDirectoryParser
    extends ACommandLineParser {
        public SourceDirectoryParser() {
            super(kSourceDirOptions);
        }

        public void ICommandLineParser_parseCommand(CommandLine commandLine, String currentCommand) throws ParsingException {
            String sourceDir = AProbeBuilderCommandLine.this.consumeNextCommand(AProbeBuilderCommandLine.this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Probe_Builder_Command_Line_Missing_Argument", currentCommand));
            CompilerEnvironment env = AProbeBuilderCommandLine.this.getProbeBuilderEnvironment();
            if (env.hasSourceDirectory()) {
                AProbeBuilderCommandLine.this.throwParsingException(AProbeBuilderCommandLine.this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Probe_Builder_Command_Line_Specified_Only_Once", currentCommand));
            }
            env.setSourceDirectory(sourceDir);
        }

        public String ISingleCommandHelpProvider_getArgumentPrompt() {
            return AProbeBuilderCommandLine.this.getStringLocalizer().IStringLocalizer_getLocalizedString("Probe_Builder_Command_Line_Help_Directory_Argument");
        }

        public String ISingleCommandHelpProvider_getHelpText() {
            return AProbeBuilderCommandLine.this.getStringLocalizer().IStringLocalizer_getLocalizedString("Probe_Builder_Command_Line_Help_Source_Dir_Command");
        }
    }

    protected class SourceJarParser
    extends ACommandLineParser {
        public SourceJarParser() {
            super(kSourceJarOptions);
        }

        public void ICommandLineParser_parseCommand(CommandLine commandLine, String currentCommand) throws ParsingException {
            String sourceJar = AProbeBuilderCommandLine.this.consumeNextCommand(AProbeBuilderCommandLine.this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Probe_Builder_Command_Line_Missing_Argument", currentCommand));
            CompilerEnvironment env = AProbeBuilderCommandLine.this.getProbeBuilderEnvironment();
            if (env.hasSourceJar()) {
                AProbeBuilderCommandLine.this.throwParsingException(AProbeBuilderCommandLine.this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Probe_Builder_Command_Line_Specified_Only_Once", currentCommand));
            }
            env.setSourceJar(sourceJar);
        }

        public String ISingleCommandHelpProvider_getArgumentPrompt() {
            return AProbeBuilderCommandLine.this.getStringLocalizer().IStringLocalizer_getLocalizedString("Probe_Builder_Command_Line_Help_File_Argument");
        }

        public String ISingleCommandHelpProvider_getHelpText() {
            return AProbeBuilderCommandLine.this.getStringLocalizer().IStringLocalizer_getLocalizedString("Probe_Builder_Command_Line_Help_Source_Jar_Command");
        }
    }

    private class VerboseParser
    extends ACommandLineParser {
        public VerboseParser() {
            super(kVerboseOptions);
        }

        public void ICommandLineParser_parseCommand(CommandLine commandLine, String currentCommand) {
            AProbeBuilderCommandLine.this.getProbeBuilderEnvironment().setVerboseMode(true);
        }

        public String ISingleCommandHelpProvider_getHelpText() {
            return AProbeBuilderCommandLine.this.getStringLocalizer().IStringLocalizer_getLocalizedString("Probe_Builder_Command_Line_Help_Verbose_Command");
        }
    }
}

