/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.spec.agent.beans.dynamicinstrumentation;

import com.wily.introscope.spec.agent.beans.dynamicinstrumentation.AbstractInstrumentationInfoResult;
import com.wily.introscope.spec.agent.beans.dynamicinstrumentation.DynamicDirectivesResult;
import com.wily.introscope.spec.agent.beans.dynamicinstrumentation.DynamicInstrumentationResult;
import com.wily.introscope.spec.agent.beans.dynamicinstrumentation.InstrumentationInfo;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InstrumentationInfoResult
extends AbstractInstrumentationInfoResult {
    private Set labels;
    private Set groups;

    public InstrumentationInfoResult() {
    }

    public InstrumentationInfoResult(InstrumentationInfoResult input) {
        this.importAll(input);
    }

    public InstrumentationInfoResult(int status) {
        super(status);
    }

    public InstrumentationInfoResult(Integer status) {
        super((int)status);
    }

    public InstrumentationInfoResult(DynamicDirectivesResult directivesByLabel) {
        super(directivesByLabel);
    }

    public void importAll(InstrumentationInfoResult input) {
        super.importAll(input);
        this.setInstrumentationInfo(input.instrumentationInfo);
        this.setGroups(input.groups);
        this.setLabels(input.labels);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.instrumentationInfo = (Map)in.readObject();
        this.groups = (Set)in.readObject();
        this.labels = (Set)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.instrumentationInfo);
        out.writeObject(this.groups);
        out.writeObject(this.labels);
    }

    public DynamicInstrumentationResult addIntrumentationInfo(List infos) {
        for (InstrumentationInfo info : infos) {
            this.addInstrumentationInfo(info.getGroupName(), info);
            this.getGroups().add(info.getGroupName());
        }
        return this;
    }

    public DynamicInstrumentationResult addInstrumentationInfo(String key, InstrumentationInfo info) {
        if (info != null) {
            if (this.getIntrumentationInfo().containsKey(key)) {
                ((List)this.getIntrumentationInfo().get(key)).add(info);
            } else {
                ArrayList<InstrumentationInfo> values = new ArrayList<InstrumentationInfo>();
                values.add(info);
                this.getIntrumentationInfo().put(key, values);
            }
        }
        return this;
    }

    public List getInstrumentationInfoByResourceName(String resourceName) {
        ArrayList<InstrumentationInfo> result = new ArrayList<InstrumentationInfo>();
        Iterator i = this.getIntrumentationInfo().values().iterator();
        while (i.hasNext()) {
            for (InstrumentationInfo info : (List)i.next()) {
                if (!info.getResourceName().equals(resourceName)) continue;
                result.add(info);
            }
        }
        return result;
    }

    public void setLabels(Set labels) {
        this.labels = labels;
    }

    public Set getLabels() {
        if (this.labels == null) {
            this.labels = new HashSet();
        }
        return this.labels;
    }

    public void setGroups(Set groups) {
        this.groups = groups;
    }

    public Set getGroups() {
        if (this.groups == null) {
            this.groups = new HashSet();
        }
        return this.groups;
    }
}

