/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.spec.server.beans.application;

import com.wily.introscope.spec.metric.AgentName;
import com.wily.introscope.spec.server.beans.application.AgentApplication;
import com.wily.util.io.IConstructorExternalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;

public class Application
implements IConstructorExternalizable {
    private String fApplicationName;
    private HashMap fAgentApplications = new HashMap();
    public static final String kAppsCategory = "Frontends|Apps";

    public Application(ObjectInput in) throws IOException {
        this.fApplicationName = in.readUTF();
        try {
            this.fAgentApplications = (HashMap)in.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e.toString());
        }
    }

    public Application(String appName) {
        this.fApplicationName = appName;
    }

    public String getApplicationName() {
        return this.fApplicationName;
    }

    public void addAgentApplication(AgentApplication agentApp) {
        this.fAgentApplications.put(agentApp.getAgent(), agentApp);
    }

    public AgentApplication removeAgentApplication(AgentName process) {
        return (AgentApplication)this.fAgentApplications.remove(process);
    }

    public AgentApplication getAgentApplication(String agentName) {
        return (AgentApplication)this.fAgentApplications.get(agentName);
    }

    public AgentApplication[] getAgentApplications() {
        return this.fAgentApplications.values().toArray(new AgentApplication[0]);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Application) {
            Application other = (Application)obj;
            return this.fApplicationName.equals(other.fApplicationName);
        }
        return super.equals(obj);
    }

    public String toString() {
        return this.fApplicationName;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.fApplicationName);
        out.writeObject(this.fAgentApplications);
    }
}

