/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.spec.server.transactiontrace;

import com.wily.introscope.spec.server.transactiontrace.AgentSideErrorTransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.AndTransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.ITransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.NotTransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.OrTransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.ParameterValueTransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.ThresholdTransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.TransactionTraceException;
import com.wily.util.text.FormattedLocalizableMessage;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.MessageFormat;

public final class TransactionFilterDeserializer {
    public static void writeFilter(DataOutput out, ITransactionTraceFilter filter) throws IOException {
        if (filter.ITransactionTraceFilter_getFilterType() == 1 || filter.ITransactionTraceFilter_getFilterType() == 3 || filter.ITransactionTraceFilter_getFilterType() == 5 || filter.ITransactionTraceFilter_getFilterType() == 2 || filter.ITransactionTraceFilter_getFilterType() == 6 || filter.ITransactionTraceFilter_getFilterType() == 4) {
            out.writeInt(filter.ITransactionTraceFilter_getFilterType());
            filter.ITransactionTraceFilter_write(out);
        } else if (out instanceof ObjectOutput) {
            out.writeInt(filter.ITransactionTraceFilter_getFilterType());
            ((ObjectOutput)out).writeObject(filter);
        } else {
            throw new IOException(MessageFormat.format("The filter {0} is not supported", filter.toString()));
        }
    }

    public static ITransactionTraceFilter readFilter(DataInput in) throws IOException, TransactionTraceException, ClassNotFoundException {
        ITransactionTraceFilter filter = null;
        int filterType = in.readInt();
        switch (filterType) {
            case 1: {
                filter = ThresholdTransactionTraceFilter.read(in);
                break;
            }
            case 2: {
                filter = ParameterValueTransactionTraceFilter.read(in);
                break;
            }
            case 3: {
                filter = AndTransactionTraceFilter.read(in);
                break;
            }
            case 5: {
                filter = OrTransactionTraceFilter.read(in);
                break;
            }
            case 6: {
                filter = NotTransactionTraceFilter.read(in);
                break;
            }
            case 4: {
                filter = AgentSideErrorTransactionTraceFilter.read(in);
                break;
            }
            default: {
                if (in instanceof ObjectInput) {
                    filter = (ITransactionTraceFilter)((ObjectInput)in).readObject();
                    break;
                }
                throw new TransactionTraceException(new FormattedLocalizableMessage("Agent_JIP_Protocol_Unknown_Transaction_Trace_Filter_Type", String.valueOf(filterType)));
            }
        }
        return filter;
    }
}

