/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.stat.gatherer;

import com.wily.introscope.spec.metric.IncompatibleTypesException;
import com.wily.introscope.spec.server.beans.metricdata.IMetricDataValue;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import com.wily.introscope.stat.gatherer.AConstantGatherer;
import com.wily.introscope.stat.timeslice.ATimeslicedValue;
import com.wily.introscope.stat.timeslice.IntegerTimeslicedValue;
import com.wily.wilyassert.Assertion;

public class IntegerConstantGatherer
extends AConstantGatherer {
    private int fValue;

    public IntegerConstantGatherer(int typeCookie, long startTimestamp) {
        super(typeCookie, startTimestamp);
        Assertion.wilyAssert(false);
    }

    public IntegerConstantGatherer(int typeCookie, long startTimestamp, int constantValue) {
        this(typeCookie, startTimestamp);
        this.noteDataIsPresent();
        this.setIntValue(constantValue);
    }

    public int getIntValue() {
        return this.fValue;
    }

    private void setIntValue(int newValue) {
        this.fValue = newValue;
    }

    protected ATimeslicedValue doConstantHarvest(long when, BlameStackSnapshot blameStack) {
        if (this.isDataAbsent()) {
            return new IntegerTimeslicedValue(this.getESETypeCookie(), this.getStartTimestampInMillis(), when, blameStack, true);
        }
        return new IntegerTimeslicedValue(this.getESETypeCookie(), this.getStartTimestampInMillis(), when, blameStack, this.getIntValue());
    }

    protected void doAcceptAggregateTimeslicedValue(IMetricDataValue value) throws IncompatibleTypesException {
        IntegerTimeslicedValue typedValue = IntegerTimeslicedValue.checkedCast(value);
        this.setIntValue(typedValue.getValue());
    }
}

