/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.stat.gatherer;

import com.wily.introscope.spec.metric.IncompatibleTypesException;
import com.wily.introscope.spec.server.beans.metricdata.IMetricDataValue;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import com.wily.introscope.stat.gatherer.ACombiningGatherer;
import com.wily.introscope.stat.timeslice.ATimeslicedValue;
import com.wily.introscope.stat.timeslice.LongTimeslicedValue;
import com.wily.wilyassert.Assertion;

public class IntervalCounterGatherer
extends ACombiningGatherer {
    public IntervalCounterGatherer(int typeCookie, long startTimestamp) {
        super(typeCookie, startTimestamp);
        Assertion.wilyAssert(false);
    }

    protected void doResetCombiningGatherer(long when) {
    }

    protected void doReinitializeCombiningGatherer() {
    }

    protected ATimeslicedValue doCombiningHarvest(long when, BlameStackSnapshot blameStack) {
        if (this.isDataAbsent()) {
            return new LongTimeslicedValue(this.getESETypeCookie(), this.getStartTimestampInMillis(), when, blameStack, true);
        }
        return new LongTimeslicedValue(this.getESETypeCookie(), this.getStartTimestampInMillis(), when, blameStack, this.getDataPointCount(), false, this.getDataPointCount(), 0L, this.getDataPointCount());
    }

    protected void doAcceptAggregateTimeslicedValue(IMetricDataValue value) throws IncompatibleTypesException {
        this.addToDataPointCount(value.getDataPointCount());
    }

    public void addSingleIncident() {
        this.incrementDataPointCount();
        this.noteDataIsPresent();
    }

    public void addBatchIncidents(long incidentCount) {
        this.addToDataPointCount(incidentCount);
        this.newDataPointsReceived();
        this.noteDataIsPresent();
    }

    public void noteWithoutIncident() {
        this.noteDataIsPresent();
    }

    public static IMetricDataValue aggregateByTime(IMetricDataValue pvalue1, IMetricDataValue pvalue2) {
        LongTimeslicedValue value1 = (LongTimeslicedValue)pvalue1;
        LongTimeslicedValue value2 = (LongTimeslicedValue)pvalue2;
        if (value1.dataIsAbsent() || value2.dataIsAbsent()) {
            return IntervalCounterGatherer.absentLong(value1, value2);
        }
        long count = value1.getDataPointCount() + value2.getDataPointCount();
        Math.min(value1.getMinimum(), value2.getMinimum());
        Math.max(value1.getMaximum(), value2.getMaximum());
        return new LongTimeslicedValue(value1.getType(), value1.getStartTimestampInMillis(), value2.getStopTimestampInMillis(), null, count, false, count, 0L, count);
    }
}

