/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.messageprimitives.service;

import com.wily.isengard.container.MessageServiceRegistration;
import com.wily.isengard.messageprimitives.ConnectionException;
import com.wily.isengard.messageprimitives.InvalidIsengardInterface;
import com.wily.isengard.messageprimitives.service.IMessageService;
import com.wily.isengard.messageprimitives.service.MessageService;
import com.wily.isengard.messageprimitives.service.MessageServiceInfo;
import com.wily.isengard.postoffice.PostOffice;
import com.wily.isengard.registry.IRegistryService;
import com.wily.isengard.registry.RegistryEntry;
import com.wily.isengard.util.tree.DirectoryPath;
import com.wily.isengard.util.tree.EntryAlreadyExistsException;
import com.wily.isengard.util.tree.EntryNotFoundException;
import com.wily.isengard.util.tree.InvalidPathException;
import com.wily.util.exception.UnexpectedExceptionError;
import java.util.HashMap;
import java.util.Map;

public class RegisteredMessageService
extends MessageService {
    private String fServiceName;
    private boolean fGrouped;
    private Map fProperties = new HashMap();

    public RegisteredMessageService(PostOffice po) {
        super(po);
    }

    public void close() {
        try {
            this.unregisterService();
        }
        catch (Exception exception) {}
        super.close();
    }

    public void setProperties(Map properties) {
        this.fProperties = properties;
    }

    public void setGrouped(boolean grouped) {
        this.fGrouped = grouped;
    }

    public MessageServiceInfo getServiceInfo() {
        return new MessageServiceInfo(this.getAddress(), this.fServiceName, this.fProperties);
    }

    public void registerService(Class interfaceClass, IMessageService callHandler) throws EntryAlreadyExistsException, ConnectionException, InvalidIsengardInterface {
        try {
            this.registerService(interfaceClass, null, callHandler);
        }
        catch (InvalidPathException e) {
            throw new UnexpectedExceptionError(e);
        }
    }

    public void registerMessageService(MessageServiceRegistration registration) throws EntryAlreadyExistsException, ConnectionException, InvalidIsengardInterface, InvalidPathException {
        if (registration.getSecurityGroups() == null) {
            this.allowAllGroupsToAccess();
        } else {
            this.setGroupAccess(registration.getSecurityGroups());
        }
        this.setGrouped(registration.isGrouped());
        String location = registration.getRelativeServiceName();
        if (registration.isPrependHubNameToRelativeServiceName()) {
            location = String.valueOf(this.getPostOffice().getPostOfficeHub().getHubName()) + (location == null || location.length() == 0 ? "" : String.valueOf('/') + location);
        }
        if (location == null) {
            this.registerService(registration.getInterfaceClass(), registration.getHandler());
        } else {
            this.registerService(registration.getInterfaceClass(), location, registration.getHandler());
        }
    }

    public void registerService(Class interfaceClass, String location, IMessageService callHandler) throws EntryAlreadyExistsException, InvalidPathException, ConnectionException, InvalidIsengardInterface {
        this.initialize(interfaceClass, callHandler);
        this.fServiceName = RegisteredMessageService.getServiceName(interfaceClass, location);
        IRegistryService client = this.getPostOffice().getRegistry();
        if (this.fGrouped) {
            DirectoryPath path = new DirectoryPath(this.fServiceName);
            try {
                RegistryEntry entry = client.getEntry(path);
                entry.addAddress(this.getAddress());
                entry.setProperties(this.fProperties);
            }
            catch (EntryNotFoundException entryNotFoundException) {
                this.addEntry(client);
            }
            catch (InvalidPathException invalidPathException) {
                this.addEntry(client);
            }
        } else {
            this.addEntry(client);
        }
    }

    private void addEntry(IRegistryService client) throws EntryAlreadyExistsException, ConnectionException {
        RegistryEntry entry = new RegistryEntry();
        entry.setAddress(this.getAddress());
        entry.setProperty("Interface", this.getServiceInterface().getName());
        client.addEntry(this.getAddress().getPostOffice(), new DirectoryPath(this.fServiceName), entry);
    }

    private void unregisterService() throws ConnectionException {
        IRegistryService client = this.getPostOffice().getRegistry();
        if (this.fGrouped) {
            DirectoryPath path = new DirectoryPath(this.fServiceName);
            try {
                RegistryEntry entry = client.getEntry(path);
                entry.removeAddress(this.getAddress());
                if (entry.getAddresses().size() == 0) {
                    client.deleteEntry(path);
                }
            }
            catch (InvalidPathException invalidPathException) {
            }
            catch (EntryNotFoundException entryNotFoundException) {}
        } else {
            try {
                if (this.fServiceName != null) {
                    client.deleteEntry(new DirectoryPath(this.fServiceName));
                }
            }
            catch (InvalidPathException invalidPathException) {}
        }
    }

    public String toString() {
        return String.valueOf(this.fServiceName) + " (" + this.getServiceInterface().getName() + ") Grouped:" + this.fGrouped;
    }

    private static String prependDefaultServiceContext(String relativeServiceName) {
        String serviceName = null;
        serviceName = relativeServiceName.charAt(0) == '/' ? "/service/" + relativeServiceName.substring(1) : "/service/" + relativeServiceName;
        return serviceName;
    }

    public static String getServiceName(Class interfaceClass, String location) {
        String serviceName = null;
        if (location != null) {
            if (location.charAt(0) == '/') {
                throw new IllegalArgumentException("The location should not begin with the '/' character.");
            }
            serviceName = RegisteredMessageService.prependDefaultServiceContext(String.valueOf(interfaceClass.getName()) + "/" + location);
        } else {
            serviceName = RegisteredMessageService.prependDefaultServiceContext(interfaceClass.getName());
        }
        return serviceName;
    }
}

