/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.postofficehub.link;

import com.wily.isengard.api.ServerInstanceLocator;
import com.wily.isengard.api.TransportConfiguration;
import com.wily.isengard.postoffice.PostOfficeHub;
import com.wily.isengard.postofficehub.link.ClientHandShaker;
import com.wily.isengard.postofficehub.link.IOutgoingConnection;
import com.wily.isengard.postofficehub.link.IRemoteClientTransport;
import com.wily.isengard.postofficehub.link.IRemoteTransport;
import com.wily.isengard.postofficehub.link.TransportFactory;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketTimeoutException;

public class OutgoingConnection
implements IOutgoingConnection {
    private static Module sModule = new Module("OutgoingConnection");
    private final TransportConfiguration fTransportConfig;
    private final ServerInstanceLocator fServerLocator;
    private final PostOfficeHub fHub;
    private IRemoteClientTransport fTransport;
    private Socket fSocket;

    public OutgoingConnection(TransportConfiguration transportConfig, ServerInstanceLocator serverLocator, PostOfficeHub hub) {
        this.fTransportConfig = transportConfig;
        this.fServerLocator = serverLocator;
        this.fHub = hub;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String connect(String groupName, String credential) throws IOException {
        String hubName = null;
        IRemoteClientTransport transport = null;
        Socket socket = null;
        IModuleFeedbackChannel feedback = this.fHub.getFeedbackChannel();
        try {
            try {
                TransportFactory factory = new TransportFactory();
                socket = this.fServerLocator.createSocket();
                transport = factory.newSocketTransportInstance(socket, 3);
                this.fSocket = socket;
                int timeout = socket.getSoTimeout();
                socket.setSoTimeout(30000);
                socket.setTcpNoDelay(true);
                socket.setSoTimeout(this.fTransportConfig.getSocketTimeout());
                if (feedback.isDebugEnabled(sModule)) {
                    feedback.debug(sModule, "Established client connection: host: " + socket.getInetAddress() + ", port: " + socket.getPort() + ", socket send buffer size [bytes]: " + socket.getSendBufferSize() + ", socket receive buffer size [bytes]: " + socket.getReceiveBufferSize());
                }
                transport.setThreadFactory(this.fHub.getThreadFactory());
                transport.setTransportConfiguration(this.fTransportConfig);
                ClientHandShaker handShaker = new ClientHandShaker();
                handShaker.doInitialHandshake(transport);
                transport.initialize(this.fHub);
                hubName = transport.connect(groupName, credential, this.fServerLocator.getSocketCreationProperties());
                this.fTransport = transport;
                this.fSocket.setSoTimeout(timeout);
            }
            catch (SocketTimeoutException e) {
                feedback.debug(sModule, "Client connection attempt timed out after " + socket.getSoTimeout() + " milliseconds: host: " + socket.getInetAddress() + ", port: " + socket.getPort());
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.closeTransportOnConnectionFailure(hubName, transport, socket);
            throw throwable;
        }
        {
            Object var10_13 = null;
            this.closeTransportOnConnectionFailure(hubName, transport, socket);
            return hubName;
        }
    }

    public boolean isConnected() {
        return this.fTransport != null && !this.fTransport.isClosed();
    }

    public void close() {
        if (this.isConnected()) {
            this.fTransport.close();
        }
        this.closeSocket(this.fSocket);
    }

    private void closeTransportOnConnectionFailure(String hubName, IRemoteTransport transport, Socket socket) {
        if (hubName == null && transport != null) {
            transport.close();
            this.closeSocket(socket);
        }
    }

    private void closeSocket(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (IOException iOException) {}
        }
    }
}

