/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.postofficehub.link.v1;

import com.wily.isengard.postofficehub.link.http.HttpTransportAdapter;
import com.wily.isengard.postofficehub.link.v1.ABaseClientTransport;
import com.wily.isengard.util.parameter.CheckParameter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;

public final class ClientHttpTransport
extends ABaseClientTransport {
    private final HttpTransportAdapter fTransportAdapter;
    private InetAddress fRemoteAddress;

    public ClientHttpTransport(HttpTransportAdapter transportAdapter, int version) {
        super(version);
        CheckParameter.notNull("HTTP Transport Adapter", transportAdapter);
        this.fTransportAdapter = transportAdapter;
    }

    public InputStream getRawInputStream() throws IOException {
        return this.fTransportAdapter.getIncomingHttpTrafficStream();
    }

    public OutputStream getRawOutputStream() throws IOException {
        return this.fTransportAdapter.getOutgoingHttpTrafficStream();
    }

    public InetAddress getRemoteAddress() {
        if (this.fRemoteAddress == null) {
            try {
                this.fRemoteAddress = InetAddress.getByName(this.getRemoteHostName());
            }
            catch (UnknownHostException unknownHostException) {
                this.fRemoteAddress = null;
            }
        }
        return this.fRemoteAddress;
    }

    public int getRemotePort() {
        return this.fTransportAdapter.getRemotePort();
    }

    public void closeRemoteConnection() {
        this.fTransportAdapter.close();
    }

    protected boolean isTrafficObfuscated() {
        return false;
    }

    public String getType() {
        return "http";
    }

    public String getRemoteHostName() {
        return this.fTransportAdapter.getRemoteHostName();
    }

    public String toString() {
        return "HTTP Transport connected with " + this.fTransportAdapter.toString();
    }
}

