/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.adt;

import com.wily.util.feedback.ADefaultModuleFeedbackChannel;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentThreadLocalHashMap<K, V>
extends ConcurrentHashMap<K, V> {
    private static final float kDefaultLoadFactor = 0.75f;
    private static final int kDefaultThreadLocalSize = 750;
    private static final int kDefaultMapSize = 75000;
    final boolean fUseThreadLocal;
    final boolean fConsolidateThreadLocals;
    final int fThreadLocalSize;
    final float fLoadFactor;
    private IModuleFeedbackChannel fFeedback;
    private static final long serialVersionUID = 1L;
    private static ThreadLocal<Map<?, ?>> fLocalMap = new ThreadLocal();
    private static ThreadLocal<Long> fCreationDate = new ThreadLocal();
    private static ThreadLocal<Boolean> fShouldFlush = new ThreadLocal();

    public ConcurrentThreadLocalHashMap(IModuleFeedbackChannel feedback, boolean useThreadLocal, boolean consolidateThreadLocals, int initialSize, int threadLocalSize, float loadFactor, int numberOfThreads) {
        super(initialSize, loadFactor, numberOfThreads);
        this.setFeedback(feedback);
        this.fUseThreadLocal = useThreadLocal;
        this.fThreadLocalSize = threadLocalSize;
        this.fLoadFactor = loadFactor;
        this.fConsolidateThreadLocals = consolidateThreadLocals;
    }

    public ConcurrentThreadLocalHashMap(IModuleFeedbackChannel feedback, boolean useThreadLocal, boolean consolidateThreadLocals, int numberOfThreads) {
        this(feedback, useThreadLocal, consolidateThreadLocals, 75000, 750, 0.75f, numberOfThreads);
    }

    public ConcurrentThreadLocalHashMap(IModuleFeedbackChannel feedback, boolean useThreadLocal, boolean consolidateThreadLocals, int numberOfThreads, int size) {
        this(feedback, useThreadLocal, consolidateThreadLocals, size, 750, 0.75f, numberOfThreads);
    }

    public ConcurrentThreadLocalHashMap(IModuleFeedbackChannel feedback, boolean useThreadLocal, boolean consolidateThreadLocals) {
        this(feedback, useThreadLocal, consolidateThreadLocals, 8);
    }

    public ConcurrentThreadLocalHashMap(IModuleFeedbackChannel feedback) {
        this(feedback, false, false, 8);
    }

    public ConcurrentThreadLocalHashMap() {
        this(new NullFeedbackChannel(), false, false, 8);
    }

    public int getLocalMapSize() {
        return this.getLocalMap().size();
    }

    public boolean checkFlushThreadLocal(int maxValues, long maxTime) {
        if (this.getLocalMapSize() > maxValues || System.currentTimeMillis() - maxTime > this.getLocalMapCreationTime()) {
            fShouldFlush.set(Boolean.TRUE);
            return true;
        }
        return false;
    }

    protected long getLocalMapCreationTime() {
        Long creationDate = fCreationDate.get();
        if (creationDate != null) {
            return creationDate;
        }
        return Long.MAX_VALUE;
    }

    protected Boolean getShouldFlushLocalMap() {
        return fShouldFlush.get();
    }

    protected void setShouldFlushLocalMap() {
        fShouldFlush.set(true);
    }

    @Override
    public V put(K key, V value) {
        this.onPut();
        if (!this.fUseThreadLocal) {
            if (value == null) {
                return super.remove(key);
            }
            return super.put(key, value);
        }
        V isAlreadyThere = this.getLocalMap().put(key, value);
        if (isAlreadyThere == null) {
            isAlreadyThere = super.get(key);
        }
        if (this.fConsolidateThreadLocals) {
            this.enqueueAdd(key, value);
        }
        return isAlreadyThere;
    }

    @Override
    public V remove(Object key) {
        this.onRemove();
        if (!this.fUseThreadLocal) {
            return super.remove(key);
        }
        V removedValue = this.getLocalMap().remove(key);
        if (removedValue == null) {
            removedValue = super.get(key);
        }
        if (this.fConsolidateThreadLocals) {
            this.enqueueRemove(key);
        }
        return removedValue;
    }

    @Override
    public boolean remove(Object key, Object value) {
        this.onRemove();
        if (!this.fUseThreadLocal) {
            return super.remove(key, value);
        }
        V removedValue = this.getLocalMap().remove(key);
        if (this.fConsolidateThreadLocals) {
            this.enqueueRemove(key);
        }
        return removedValue != null;
    }

    protected void onPut() {
    }

    protected void onRemove() {
    }

    @Override
    public V get(Object key) {
        this.onGet();
        if (!this.fUseThreadLocal) {
            return super.get(key);
        }
        V result = this.getLocalMap().get(key);
        if (result != null) {
            return result;
        }
        if (this.fConsolidateThreadLocals) {
            return super.get(key);
        }
        return result;
    }

    protected void onGet() {
    }

    protected final void enqueueAdd(K key, V value) {
        if (value == null) {
            super.remove(key);
        } else {
            super.put(key, value);
        }
    }

    protected final void enqueueRemove(K key) {
        super.remove(key);
    }

    private Map<K, V> getLocalMap() {
        Map<Object, Object> localMap = fLocalMap.get();
        if (localMap == null || this.getShouldFlushLocalMap().booleanValue()) {
            localMap = this.createLocalmap();
        }
        return localMap;
    }

    private Map<K, V> createLocalmap() {
        HashMap localMap = new HashMap(this.fThreadLocalSize, this.fLoadFactor);
        fLocalMap.set(localMap);
        fCreationDate.set(System.currentTimeMillis());
        fShouldFlush.set(Boolean.FALSE);
        return localMap;
    }

    public void setFeedback(IModuleFeedbackChannel fFeedback) {
        this.fFeedback = fFeedback == null ? new NullFeedbackChannel() : fFeedback;
    }

    public IModuleFeedbackChannel getFeedback() {
        return this.fFeedback;
    }

    private static class NullFeedbackChannel
    extends ADefaultModuleFeedbackChannel {
        private NullFeedbackChannel() {
            super("NullFeedbackChannel-ConcurrentThreadLocalHashMap");
        }
    }
}

