/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.adt;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class LabeledList {
    private final List fDataList = new LinkedList();

    public void addLabeledElement(Object label, Object element) {
        this.fDataList.add(new LabeledElement(label, element));
    }

    public void clear() {
        this.fDataList.clear();
    }

    public Iterator getIterator() {
        return new ElementIterator(this.fDataList.iterator());
    }

    public void removeAllElementsWithLabel(Object label) {
        Iterator dataListIterator = this.fDataList.iterator();
        while (dataListIterator.hasNext()) {
            LabeledElement nextLabeledElement = (LabeledElement)dataListIterator.next();
            if (!nextLabeledElement.isLabelled(label)) continue;
            dataListIterator.remove();
        }
    }

    private static class ElementIterator
    implements Iterator {
        private final Iterator fDataListIterator;

        private ElementIterator(Iterator dataListIterator) {
            this.fDataListIterator = dataListIterator;
        }

        public boolean hasNext() {
            return this.fDataListIterator.hasNext();
        }

        public Object next() {
            LabeledElement nextLabeledElement = (LabeledElement)this.fDataListIterator.next();
            return nextLabeledElement.getElement();
        }

        public void remove() {
            this.fDataListIterator.remove();
        }
    }

    private static class LabeledElement {
        private final Object fLabel;
        private final Object fElement;

        private LabeledElement(Object label, Object element) {
            this.fLabel = label;
            this.fElement = element;
        }

        public boolean isLabelled(Object label) {
            return this.fLabel == label || this.fLabel != null && this.fLabel.equals(label);
        }

        public Object getElement() {
            return this.fElement;
        }
    }
}

