/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.text;

import com.wily.util.exception.AChainingException;
import com.wily.util.text.ILocalizableException;
import com.wily.util.text.ILocalizableMessage;
import com.wily.util.text.IStringLocalizer;
import com.wily.util.text.LocalizedMessage;
import com.wily.util.text.StringLocalizerHandle;
import java.util.Locale;

public abstract class ALocalizableException
extends AChainingException
implements ILocalizableException {
    private ILocalizableMessage fLocalizableMessage;

    private ALocalizableException() {
    }

    protected ALocalizableException(ILocalizableMessage userMessage) {
        this.fLocalizableMessage = userMessage;
    }

    protected ALocalizableException(Throwable cause, ILocalizableMessage userMessage) {
        super(cause);
        this.fLocalizableMessage = userMessage;
    }

    protected ALocalizableException(String internalMessage, ILocalizableMessage userMessage) {
        super(internalMessage);
        this.fLocalizableMessage = userMessage;
    }

    protected ALocalizableException(String internalMessage, Throwable cause, ILocalizableMessage userMessage) {
        super(internalMessage, cause);
        this.fLocalizableMessage = userMessage;
    }

    protected ALocalizableException(Throwable t) {
        super(t);
        this.fLocalizableMessage = new LocalizedMessage(t.getLocalizedMessage());
    }

    public ILocalizableMessage ILocalizableException_getLocalizableMessage() {
        return this.fLocalizableMessage;
    }

    public String getInternalMessage() {
        return super.getMessage();
    }

    public String getMessage() {
        return this.getMessage(Locale.getDefault());
    }

    public String getMessage(Locale locale) {
        if (this.fLocalizableMessage == null) {
            return super.getMessage();
        }
        String msg = this.fLocalizableMessage.ILocalizableMessage_getLocalizedMessage(this.getDefaultStringLocalizer(), locale);
        if (msg != null && msg.length() > 0) {
            return msg;
        }
        return super.getMessage();
    }

    protected IStringLocalizer getDefaultStringLocalizer() {
        return StringLocalizerHandle.getStringLocalizer();
    }
}

