/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.text;

import com.wily.util.locale.LocaleUtils;
import com.wily.util.text.AStringLocalizer;
import com.wily.util.text.IStringLocalizer;
import java.util.Locale;

public class FixedLocaleStringLocalizer
extends AStringLocalizer {
    private AStringLocalizer delegateeLocalizer;
    private Locale forLocale;

    public FixedLocaleStringLocalizer(Locale locale, IStringLocalizer localizer) {
        if (localizer == null || locale == null) {
            throw new IllegalArgumentException("Given arguments to create FixedLocaleStringLocalizer are: locale - " + locale + ", Localizer - " + localizer);
        }
        if (!(localizer instanceof AStringLocalizer)) {
            throw new IllegalArgumentException("Given localizer should be an extended type of AStringLocalizer");
        }
        this.delegateeLocalizer = (AStringLocalizer)localizer;
        this.forLocale = locale;
    }

    public static FixedLocaleStringLocalizer getFallbackLocaleLocalizer(IStringLocalizer localizer) {
        return new FixedLocaleStringLocalizer(LocaleUtils.getFallbackLocale(), localizer);
    }

    protected String getLocalizedString(String key) {
        return this.delegateeLocalizer.getLocalizedString(this.forLocale, key);
    }

    protected String getLocalizedString(Locale locale, String key) {
        return this.delegateeLocalizer.getLocalizedString(this.forLocale, key);
    }

    public String getFormattedLocalizedString(String key, String[] parameters) {
        return this.delegateeLocalizer.getFormattedLocalizedString(this.forLocale, key, parameters);
    }

    public String getFormattedLocalizedString(Locale locale, String key, String[] parameters) {
        return this.delegateeLocalizer.getFormattedLocalizedString(this.forLocale, key, parameters);
    }
}

