/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.topologicalsort;

import com.wily.util.topologicalsort.CycleExistsException;
import com.wily.util.topologicalsort.ITopologicalSortNode;
import com.wily.util.topologicalsort.Node;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TopologicalSorter {
    Map fNodes = new HashMap();

    private TopologicalSorter(Collection nodes) {
        if (nodes == null) {
            return;
        }
        for (ITopologicalSortNode n : nodes) {
            Node nodeRef = (Node)this.fNodes.get(n.ITopologicalSortNode_getId());
            if (nodeRef == null) {
                this.fNodes.put(n.ITopologicalSortNode_getId(), new Node(n));
                continue;
            }
            nodeRef.incrOccurenceCount();
        }
        for (Node currNode : this.fNodes.values()) {
            String[] incomingEdges = currNode.getExternalNode().ITopologicalSort_getDependencies();
            if (incomingEdges == null) continue;
            int i = 0;
            while (i < incomingEdges.length) {
                Node incomingNode = (Node)this.fNodes.get(incomingEdges[i]);
                if (incomingNode != null) {
                    currNode.addIncomingNode(incomingNode);
                }
                ++i;
            }
        }
    }

    private void traverseNode(Node n, List outputList) throws CycleExistsException {
        if (n.getColor() == 1) {
            throw new CycleExistsException("Cycle exists involving node " + n.getExternalNode().ITopologicalSortNode_getId());
        }
        if (n.getColor() == 2) {
            return;
        }
        n.setColor(1);
        List incomingNodes = n.getIncomingNodes();
        int i = 0;
        while (i < incomingNodes.size()) {
            Node v = (Node)incomingNodes.get(i);
            this.traverseNode(v, outputList);
            ++i;
        }
        int rank = outputList.size();
        n.getExternalNode().ITopologicalSort_setRank(rank);
        outputList.add(n);
        n.setColor(2);
    }

    private void doSort(List outputList) throws CycleExistsException {
        for (Node n : this.fNodes.values()) {
            this.traverseNode(n, outputList);
        }
    }

    public static void sort(List inputList) throws CycleExistsException {
        if (inputList == null) {
            throw new IllegalArgumentException("inputList cannot be null");
        }
        TopologicalSorter t = new TopologicalSorter(inputList);
        ArrayList output = new ArrayList();
        t.doSort(output);
        int count = 0;
        int i = 0;
        while (i < output.size()) {
            Node n = (Node)output.get(i);
            int j = 0;
            while (j < n.getOccurenceCount()) {
                inputList.set(count++, n.getExternalNode());
                ++j;
            }
            ++i;
        }
    }

    public static void sort(ITopologicalSortNode[] inputList) throws CycleExistsException {
        if (inputList == null) {
            throw new IllegalArgumentException("inputList cannot be null");
        }
        TopologicalSorter t = new TopologicalSorter(Arrays.asList(inputList));
        ArrayList output = new ArrayList();
        t.doSort(output);
        int count = 0;
        int i = 0;
        while (i < output.size()) {
            Node n = (Node)output.get(i);
            int j = 0;
            while (j < n.getOccurenceCount()) {
                inputList[count++] = n.getExternalNode();
                ++j;
            }
            ++i;
        }
    }
}

