/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.gcmonitor.agent;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.gcmonitor.agent.jvmprovider.JVMProvider;
import com.wily.introscope.gcmonitor.agent.jvmprovider.JVMProviderFactory;
import com.wily.introscope.gcmonitor.ui.Messages;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.ITimestampedRunnable;

public class GCMonitor
implements ITimestampedRunnable {
    private JVMProvider provider = null;
    private Module kGCMonitor = new Module("GCMonitor Runnable");
    private int fFrequency = 15000;
    private int fTimeSinceLastQuery = 0;

    public GCMonitor(IAgent agent, int queryFrequency) {
        agent.IAgent_getModuleFeedback().debug(this.kGCMonitor, Messages.getString("GCMonitorExtn.JVMInit"));
        this.provider = JVMProviderFactory.getInstance().getJVMProvider(agent);
        if (this.provider != null) {
            agent.IAgent_getModuleFeedback().debug(this.kGCMonitor, Messages.getString("GCMonitorExtn.JVM"));
            this.provider.getGCInformation();
        } else {
            agent.IAgent_getModuleFeedback().debug(this.kGCMonitor, Messages.getString("GCMonitorExtn.JVMNull"));
        }
        this.fFrequency = queryFrequency;
    }

    public void ITimestampedRunnable_execute(long arg0) {
        if (this.provider != null) {
            boolean useCachedValues = true;
            if (this.fTimeSinceLastQuery <= 0) {
                this.fTimeSinceLastQuery = this.fFrequency;
                useCachedValues = false;
            }
            this.fTimeSinceLastQuery -= 7500;
            this.provider.publishMetricValues(useCachedValues);
        }
    }

    public void turnOffAllMetrics() {
        if (this.provider != null) {
            this.provider.destroyMetrics();
        }
    }

    public JVMProvider getProvider() {
        return this.provider;
    }
}

