/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.gcmonitor.metricpublisher;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.gcmonitor.metricpublisher.MetricPublisher;
import com.wily.introscope.gcmonitor.metricpublisher.SystemOutMetricPublisher;
import com.wily.introscope.gcmonitor.metricpublisher.agent.AgentMetricPublisher;

public class MetricPublisherFactory {
    private static final int SYSTEM_OUT_PUBLISHER = 0;
    private static final int AGENT_PUBLISHER = 1;
    private static MetricPublisherFactory publisherFactory = new MetricPublisherFactory();
    private static int publisherType = 0;
    private IAgent fAgent;

    public static MetricPublisherFactory getInstance() {
        return publisherFactory;
    }

    public synchronized MetricPublisher getMetricPublisher() {
        MetricPublisher metricPublisher = null;
        switch (publisherType) {
            case 0: {
                metricPublisher = new SystemOutMetricPublisher();
                break;
            }
            case 1: {
                metricPublisher = new AgentMetricPublisher(this.fAgent);
                break;
            }
            default: {
                metricPublisher = new SystemOutMetricPublisher();
            }
        }
        return metricPublisher;
    }

    public synchronized void useSystemOutMetricPublisher() {
        publisherType = 0;
    }

    public synchronized void useAgentMetricPublisher(IAgent agent) {
        publisherType = 1;
        this.fAgent = agent;
    }
}

