/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.datetime;

import com.wily.util.datetime.DateFormatException;
import com.wily.util.datetime.Messages;
import java.util.Date;

public class DateRangeParser {
    public static final Long NOW = new Long(-1L);
    private Integer fInterval;
    private long fIntervalMultiplier;
    private Date fStart;
    private Date fEnd;
    private final Long fStartUTC;
    private final Long fEndUTC;

    public DateRangeParser(Long start, Long end, Integer interval, long intervalMultiplier) throws DateFormatException {
        this.fStartUTC = start;
        this.fEndUTC = end;
        this.fInterval = interval;
        this.fIntervalMultiplier = intervalMultiplier;
        this.parse();
    }

    private void parse() throws DateFormatException {
        if (this.fStartUTC != null) {
            Date date = this.fStart = this.fStartUTC.equals(NOW) ? new Date() : new Date(this.fStartUTC);
        }
        if (this.fEndUTC != null) {
            Date date = this.fEnd = this.fEndUTC.equals(NOW) ? new Date() : new Date(this.fEndUTC);
        }
        if (this.fStart == null && this.fEnd == null) {
            throw new DateFormatException(Messages.getString("DateRangeParser.MissingBothDates"));
        }
        if (this.fStart == null || this.fEnd == null) {
            if (this.fInterval == null) {
                throw new DateFormatException(Messages.getString("DateRangeParser.MissingValues"));
            }
            long time = this.fIntervalMultiplier;
            if (this.fInterval <= 0) {
                throw new DateFormatException(Messages.getString("DateRangeParser.InvalidInterval", this.fInterval));
            }
            time *= (long)this.fInterval.intValue();
            if (this.fStart == null) {
                this.fStart = new Date(this.fEnd.getTime() - time);
            } else {
                this.fEnd = new Date(this.fStart.getTime() + time);
            }
        }
        if (this.fStart.after(this.fEnd)) {
            throw new DateFormatException(Messages.getString("DateRangeParser.InvalidRange"));
        }
    }

    public Date getEnd() {
        return this.fEnd;
    }

    public Date getStart() {
        return this.fStart;
    }
}

