/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.net;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

public class NetworkInterfaceValidator {
    private NetworkInterfaceValidator() {
    }

    public static boolean isLocalNodeInetAddress(InetAddress address) throws SocketException {
        if (address.isAnyLocalAddress() || address.isLoopbackAddress()) {
            return true;
        }
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        if (interfaces != null) {
            while (interfaces.hasMoreElements()) {
                NetworkInterface networkInterface = interfaces.nextElement();
                Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress localAddr = inetAddresses.nextElement();
                    if (!localAddr.equals(address)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

