/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.validate;

import com.wily.util.ArrayEnumeration;
import com.wily.util.validate.IValidatable;
import com.wily.util.validate.KValidationConstants;
import com.wily.util.validate.ValidationException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import javax.swing.JScrollPane;
import javax.swing.text.JTextComponent;

public class ValidationUIUtilities
implements KValidationConstants {
    private ValidationUIUtilities() {
    }

    public static void validateChildComponents(Container parentComponent, int validationConstraints, boolean recursive) throws ValidationException {
        ArrayEnumeration chiledComponents = new ArrayEnumeration(parentComponent.getComponents());
        while (chiledComponents.hasMoreElements()) {
            Component childComponent = (Component)chiledComponents.nextElement();
            if (childComponent instanceof IValidatable) {
                IValidatable validatableChild = (IValidatable)((Object)childComponent);
                validatableChild.IValidatable_validate(validationConstraints);
                continue;
            }
            if (!recursive || !(childComponent instanceof Container)) continue;
            Container childContainer = (Container)childComponent;
            ValidationUIUtilities.validateChildComponents(childContainer, validationConstraints, true);
        }
    }

    public static void setComponentFocusAfterError(Component component) {
        if (component instanceof JTextComponent) {
            ((JTextComponent)component).selectAll();
        }
        component.requestFocus();
        Rectangle componentRect = component.getBounds();
        Container nextParent = component.getParent();
        while (nextParent != null) {
            if (nextParent instanceof JScrollPane) {
                JScrollPane jScrollPaneParent = (JScrollPane)nextParent;
                if (jScrollPaneParent.getViewport() == null) break;
                jScrollPaneParent.getViewport().scrollRectToVisible(componentRect);
                break;
            }
            Rectangle bounds = nextParent.getBounds();
            componentRect.translate(bounds.x, bounds.y);
            nextParent = nextParent.getParent();
        }
    }

    public static IValidatable getCompoundValidatable(final IValidatable[] validates) {
        return new IValidatable(){

            public void IValidatable_validate() throws ValidationException {
                int i = 0;
                while (i < validates.length) {
                    validates[i].IValidatable_validate();
                    ++i;
                }
            }

            public void IValidatable_validate(int validationConstraintFlags) throws ValidationException {
                int i = 0;
                while (i < validates.length) {
                    validates[i].IValidatable_validate(validationConstraintFlags);
                    ++i;
                }
            }
        };
    }
}

