/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.biztrxhttp.trace;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.biztrxhttp.definition.GenericBizTrxHttpDef;
import com.wily.introscope.agent.biztrxhttp.utilities.KBizHttpConstants;
import com.wily.introscope.agent.trace.BlamePointTracer;
import com.wily.introscope.agent.trace.ICacheableInvocationDataTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.biz.trx.BizTrxAbstractTracer;
import com.wily.introscope.spec.agent.beans.bizdef.IBizDefSupportBean;
import com.wily.introscope.spec.agent.bizdef.IBizTrx;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;

public class BizTrxHttpTracer
extends BizTrxAbstractTracer
implements ICacheableInvocationDataTracerFactory {
    boolean fShutoff = false;
    IBizDefSupportBean fBizDefSupport;
    private static ThreadLocal sStackDepthLocal = new ThreadLocal(){

        public Object initialValue() {
            return new MutableInteger(0);
        }
    };

    public BizTrxHttpTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        try {
            this.fBizDefSupport = (IBizDefSupportBean)this.getAgent().IAgent_getTracerAdministrator().loadTraceSupport("com.wily.introscope.agent.bizdef.BizDefAdministratorFactory", "").getTraceSupportInstance();
            this.fShutoff = false;
        }
        catch (Throwable t) {
            this.getAgent().IAgent_getModuleFeedback().warn(KBizHttpConstants.kBizHttpModule, "Tracer failed initialization");
            this.getAgent().IAgent_getModuleFeedback().verbose(KBizHttpConstants.kBizHttpModule, "Tracer failed initialization", t);
            this.fShutoff = true;
        }
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        MutableInteger stackDepth = (MutableInteger)sStackDepthLocal.get();
        stackDepth.inc();
        if (stackDepth.getValue() > 1) {
            return;
        }
        try {
            if (this.fShutoff) {
                return;
            }
            IBizTrx bizTrx = this.fBizDefSupport.getBusinessTransactionComponent((Object)data, true);
            Boolean bizDefIdentified = (Boolean)data.get("introscope.agent.bizDefIdentified");
            if (bizDefIdentified != null && bizDefIdentified.equals(Boolean.TRUE)) {
                if (bizTrx != null) {
                    this.createBizTrxMetricsAtStart(bizTrx, tracerIndex, data);
                }
            } else if (bizDefIdentified != null && bizDefIdentified.equals(Boolean.FALSE)) {
                data.put("BusinessMetricResourceKey", (Object)new GenericBizTrxHttpDef());
                this.createNoBizTrxMetricsAtStart(new GenericBizTrxHttpDef(), tracerIndex, data);
            }
        }
        catch (Exception e) {
            this.getModuleFeedback().error(KBizHttpConstants.kBizHttpModule, e.getMessage());
            this.getModuleFeedback().debug(e);
        }
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        MutableInteger stackDepth = (MutableInteger)sStackDepthLocal.get();
        stackDepth.dec();
        if (stackDepth.getValue() > 0) {
            return;
        }
        if (this.fShutoff) {
            return;
        }
        Boolean bizDefIdentified = (Boolean)data.get("introscope.agent.bizDefIdentified");
        if (bizDefIdentified != null && bizDefIdentified.equals(Boolean.TRUE)) {
            IBizTrx bizTrx = (IBizTrx)data.get("BusinessTrxData");
            if (bizTrx != null) {
                this.completeBizTrxMetricsAtFinish(tracerIndex, data);
            }
        } else if (bizDefIdentified != null && bizDefIdentified.equals(Boolean.FALSE)) {
            try {
                IBizTrx bizTrx = this.fBizDefSupport.getBusinessTransactionComponent((Object)data, false);
                if (bizTrx != null) {
                    this.createBizTrxMetricsAtFinish(bizTrx, tracerIndex, data);
                } else {
                    this.completeNoMetricsAtFinish(tracerIndex, data);
                }
            }
            catch (Exception e) {
                this.getModuleFeedback().error(KBizHttpConstants.kBizHttpModule, e.getMessage());
                this.getModuleFeedback().debug(e);
            }
        }
    }

    protected void createNoBizTrxMetricsAtStart(IBizTrx bizTrx, int tracerIndex, InvocationData data) {
        String component = bizTrx.getBizFullName();
        this.doStartBlamePointTraceSimpleLite(tracerIndex, data, component);
    }

    protected void createBizTrxMetricsAtStart(IBizTrx bizTrx, int tracerIndex, InvocationData data) {
        if (this.getModuleFeedback().isVerboseEnabled(KBizHttpConstants.kBizHttpModule)) {
            this.getModuleFeedback().verbose(KBizHttpConstants.kBizHttpModule, this.getStringLocalizer().IStringLocalizer_getLocalizedString("BizHttp_Building_BizCentricMetrics"));
        }
        String component = this.getComponentName(data);
        BlamePointTracer.DataAccumulatorGroup cachedGroup = this.getAccumulatorGroup(component);
        if (cachedGroup.concurrentInvocationAccumulator == null) {
            this.resetAccumulatorGroup(component);
        }
        this.doStartBlamePointTrace(tracerIndex, data, component);
        if (this.getModuleFeedback().isVerboseEnabled(KBizHttpConstants.kBizHttpModule)) {
            this.getModuleFeedback().verbose(KBizHttpConstants.kBizHttpModule, this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("BizHttp_BizCentricMetrics_Equals", component));
        }
    }

    protected void completeBizTrxMetricsAtFinish(int tracerIndex, InvocationData data) {
        String component = this.getComponentName(data);
        this.doFinishBlamePointTrace(tracerIndex, data, component);
    }

    protected void completeNoMetricsAtFinish(int tracerIndex, InvocationData data) {
        IBizTrx bizTrx = (IBizTrx)data.get("BusinessMetricResourceKey");
        String component = bizTrx.getBizFullName();
        this.doFinishBlamePointTraceNoMatch(tracerIndex, data, component);
    }

    protected void createBizTrxMetricsAtFinish(IBizTrx updatedBizTrx, int tracerIndex, InvocationData data) {
        IBizTrx bizTrx = (IBizTrx)data.get("BusinessMetricResourceKey");
        Assertion.wilyAssert(bizTrx != null);
        if (this.getModuleFeedback().isVerboseEnabled(KBizHttpConstants.kBizHttpModule)) {
            this.getModuleFeedback().verbose(KBizHttpConstants.kBizHttpModule, this.getStringLocalizer().IStringLocalizer_getLocalizedString("BizHttp_Building_BizCentricMetrics"));
        }
        if (updatedBizTrx != null) {
            String component = this.getComponentName(data);
            this.checkForErrors(component, data);
            this.doFinishBlamePointTraceSimpleLite(tracerIndex, data, component, bizTrx.getBizFullName());
            if (this.getModuleFeedback().isVerboseEnabled(KBizHttpConstants.kBizHttpModule)) {
                this.getModuleFeedback().verbose(KBizHttpConstants.kBizHttpModule, this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("BizHttp_BizCentricMetrics_Equals", component));
            }
        }
    }

    public boolean canCacheInvocationData() {
        return true;
    }

    public boolean canCacheTracerInstances() {
        return true;
    }

    public boolean canCacheComponentNames() {
        return false;
    }

    private static final class MutableInteger {
        private int i;

        public MutableInteger(int initVal) {
            this.i = initVal;
        }

        public void inc() {
            ++this.i;
        }

        public void dec() {
            --this.i;
        }

        public int getValue() {
            return this.i;
        }

        public void clear() {
            this.i = 0;
        }
    }
}

