/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util;

import java.io.PrintStream;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public class ArrayUtilities {
    public static Object[] addElementToObjectArray(Object[] sourceArray, Object newElement, Class elementClass) {
        int sourceArrayLength = sourceArray.length;
        Object[] targetArray = (Object[])Array.newInstance(elementClass, sourceArrayLength + 1);
        System.arraycopy(sourceArray, 0, targetArray, 0, sourceArrayLength);
        targetArray[sourceArrayLength] = newElement;
        return targetArray;
    }

    public static Object[] removeElementFromObjectArray(Object[] sourceArray, Object elementToRemove, Class elementClass) {
        int sourceArrayLength = sourceArray.length;
        int indexToRemove = 0;
        while (indexToRemove < sourceArrayLength) {
            if (sourceArray[indexToRemove] == elementToRemove) {
                Object[] targetArray = (Object[])Array.newInstance(elementClass, sourceArrayLength - 1);
                if (sourceArrayLength == 1) {
                    return targetArray;
                }
                int targetArrayLength = sourceArrayLength - 1;
                int elementsToCopyInFrontHalf = indexToRemove;
                System.arraycopy(sourceArray, 0, targetArray, 0, elementsToCopyInFrontHalf);
                if (targetArrayLength > elementsToCopyInFrontHalf) {
                    System.arraycopy(sourceArray, indexToRemove + 1, targetArray, indexToRemove, targetArrayLength - elementsToCopyInFrontHalf);
                }
                return targetArray;
            }
            ++indexToRemove;
        }
        return sourceArray;
    }

    public static Object[] removeEqualedElementFromObjectArray(Object[] sourceArray, Object elementToRemove, Class elementClass) {
        int sourceArrayLength = sourceArray.length;
        int indexToRemove = 0;
        while (indexToRemove < sourceArrayLength) {
            if (sourceArray[indexToRemove].equals(elementToRemove)) {
                Object[] targetArray = (Object[])Array.newInstance(elementClass, sourceArrayLength - 1);
                if (sourceArrayLength == 1) {
                    return targetArray;
                }
                int targetArrayLength = sourceArrayLength - 1;
                int elementsToCopyInFrontHalf = indexToRemove;
                System.arraycopy(sourceArray, 0, targetArray, 0, elementsToCopyInFrontHalf);
                if (targetArrayLength > elementsToCopyInFrontHalf) {
                    System.arraycopy(sourceArray, indexToRemove + 1, targetArray, indexToRemove, targetArrayLength - elementsToCopyInFrontHalf);
                }
                return targetArray;
            }
            ++indexToRemove;
        }
        return sourceArray;
    }

    public static Object[] insertElementIntoObjectArray(Object[] sourceArray, Object newElement, int insertionIndex, Class elementClass) {
        int sourceArrayLength = sourceArray.length;
        Object[] targetArray = (Object[])Array.newInstance(elementClass, sourceArrayLength + 1);
        if (insertionIndex == -1) {
            insertionIndex = sourceArrayLength;
        }
        System.arraycopy(sourceArray, 0, targetArray, 0, insertionIndex);
        targetArray[insertionIndex] = newElement;
        System.arraycopy(sourceArray, insertionIndex, targetArray, insertionIndex + 1, sourceArrayLength - insertionIndex);
        return targetArray;
    }

    public static Object[] changeElementInObjectArray(Object[] sourceArray, Object newElement, int index, Class elementClass) {
        int sourceArrayLength = sourceArray.length;
        Object[] targetArray = (Object[])Array.newInstance(elementClass, sourceArrayLength);
        System.arraycopy(sourceArray, 0, targetArray, 0, index);
        targetArray[index] = newElement;
        System.arraycopy(sourceArray, index + 1, targetArray, index + 1, sourceArrayLength - index - 1);
        return targetArray;
    }

    public static Object[] transposeElementInArray(Object[] sourceArray, int fromIndex, int toIndex, boolean copy, Class elementClass) {
        Object itemToTranspose = sourceArray[fromIndex];
        Object[] targetArray = ArrayUtilities.insertElementIntoObjectArray(sourceArray, itemToTranspose, toIndex, elementClass);
        if (!copy) {
            if (toIndex < fromIndex) {
                ++fromIndex;
            }
            targetArray = ArrayUtilities.removeIndexedElementFromObjectArray(targetArray, fromIndex, elementClass);
        }
        return targetArray;
    }

    public static Object[] removeIndexedElementFromObjectArray(Object[] sourceArray, int removalIndex, Class elementClass) {
        int sourceArrayLength = sourceArray.length;
        Object[] targetArray = (Object[])Array.newInstance(elementClass, sourceArrayLength - 1);
        if (sourceArrayLength == 1) {
            if (removalIndex != 0) {
                throw new ArrayIndexOutOfBoundsException(removalIndex);
            }
        } else {
            System.arraycopy(sourceArray, 0, targetArray, 0, removalIndex);
            System.arraycopy(sourceArray, removalIndex + 1, targetArray, removalIndex, sourceArrayLength - removalIndex - 1);
        }
        return targetArray;
    }

    public static Object[] mutateArray(Object[] src, Class elementClass) {
        int srcLength = Array.getLength(src);
        Object[] targetArray = (Object[])Array.newInstance(elementClass, srcLength);
        ArrayUtilities.arraycopy(src, targetArray);
        return targetArray;
    }

    public static void arraycopy(Object[] src, Object[] dest) {
        int destLength;
        int srcLength = Array.getLength(src);
        int copyLength = srcLength > (destLength = Array.getLength(dest)) ? destLength : srcLength;
        System.arraycopy(src, 0, dest, 0, copyLength);
    }

    public static void arraycopy(Object[] src, Object[] dest, boolean clipSource) {
        int destLength;
        int srcLength = Array.getLength(src);
        if (srcLength > (destLength = Array.getLength(dest))) {
            throw new ArrayIndexOutOfBoundsException(destLength + 1);
        }
        System.arraycopy(src, 0, dest, 0, srcLength);
    }

    public static Integer[] intArrayToIntegerArray(int[] intArray) {
        int length = intArray.length;
        Integer[] integerArray = new Integer[length];
        int i = 0;
        while (i < length) {
            integerArray[i] = new Integer(intArray[i]);
            ++i;
        }
        return integerArray;
    }

    public static Object[] getArrayFromEnumeration(Enumeration enumeration, Class elementClass) {
        Vector elements = new Vector();
        while (enumeration.hasMoreElements()) {
            elements.addElement(enumeration.nextElement());
        }
        Object[] array = (Object[])Array.newInstance(elementClass, elements.size());
        elements.copyInto(array);
        return array;
    }

    public static void byteArrayToCharArray(byte[] src, char[] dest) {
        int destLength;
        int srcLength = Array.getLength(src);
        int copyLength = srcLength > (destLength = Array.getLength(dest)) ? destLength : srcLength;
        int i = 0;
        while (i < copyLength) {
            dest[i] = (char)src[i];
            ++i;
        }
    }

    public static void charArrayToByteArray(char[] src, byte[] dest) {
        int destLength;
        int srcLength = Array.getLength(src);
        int copyLength = srcLength > (destLength = Array.getLength(dest)) ? destLength : srcLength;
        int i = 0;
        while (i < copyLength) {
            dest[i] = (byte)src[i];
            ++i;
        }
    }

    public static Vector convertToVector(Object[] array) {
        Vector<Object> vector;
        Vector<Object> vector2 = vector = array == null ? null : new Vector<Object>();
        if (vector != null) {
            int i = 0;
            while (i < array.length) {
                vector.addElement(array[i]);
                ++i;
            }
        }
        return vector;
    }

    public static Object[] vectorToArray(Vector vector, Class elementClass) {
        Object[] array = (Object[])Array.newInstance(elementClass, vector.size());
        int arrayIndex = 0;
        Enumeration elements = vector.elements();
        while (elements.hasMoreElements()) {
            Object element = elements.nextElement();
            array[arrayIndex++] = element;
        }
        return array;
    }

    public static double[] doubleCollectionToArray(Collection collection) {
        double[] array = new double[collection.size()];
        int arrayIndex = 0;
        Iterator i = collection.iterator();
        while (i.hasNext()) {
            array[arrayIndex] = (Double)i.next();
            ++arrayIndex;
        }
        return array;
    }

    public static long[] longCollectionToArray(Collection collection) {
        long[] array = new long[collection.size()];
        int arrayIndex = 0;
        Iterator i = collection.iterator();
        while (i.hasNext()) {
            array[arrayIndex] = (Long)i.next();
            ++arrayIndex;
        }
        return array;
    }

    public static boolean equal(Object[] array1, Object[] array2) {
        boolean arraysEqual = false;
        if (array1.length == array2.length) {
            arraysEqual = true;
            int i = 0;
            while (i < array1.length && arraysEqual) {
                arraysEqual = array1[i].equals(array2[i]);
                ++i;
            }
        }
        return arraysEqual;
    }

    public static boolean equal(double[] array1, double[] array2) {
        boolean arraysEqual = false;
        if (array1.length == array2.length) {
            arraysEqual = true;
            int i = 0;
            while (i < array1.length && arraysEqual) {
                arraysEqual = array1[i] == array2[i];
                ++i;
            }
        }
        return arraysEqual;
    }

    public static boolean equalsIgnoreOrder(Object[] array1, Object[] array2) {
        if (array1.length == array2.length) {
            boolean[] matches = new boolean[array1.length];
            int i = 0;
            while (i < array1.length) {
                boolean matchFound = false;
                int j = 0;
                while (j < array2.length) {
                    if (!matches[j] && array1[i].equals(array2[j])) {
                        matches[j] = true;
                        matchFound = true;
                        break;
                    }
                    ++j;
                }
                if (!matchFound) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static void moveElementToFront(Object[] array, int index) {
        if (index > 0) {
            Object element = array[index];
            System.arraycopy(array, 0, array, 1, index);
            array[0] = element;
        }
    }

    public static void moveElementToBack(Object[] array, int index) {
        Object element = array[index];
        System.arraycopy(array, index + 1, array, index, array.length - index - 1);
        array[array.length - 1] = element;
    }

    public static void moveElementToFront(double[] array, int index) {
        if (index > 0) {
            double element = array[index];
            System.arraycopy(array, 0, array, 1, index);
            array[0] = element;
        }
    }

    public static void moveElementToBack(double[] array, int index) {
        double element = array[index];
        System.arraycopy(array, index + 1, array, index, array.length - index - 1);
        array[array.length - 1] = element;
    }

    public static void moveElementToFront(boolean[] array, int index) {
        if (index > 0) {
            boolean element = array[index];
            System.arraycopy(array, 0, array, 1, index);
            array[0] = element;
        }
    }

    public static void moveElementToBack(boolean[] array, int index) {
        boolean element = array[index];
        System.arraycopy(array, index + 1, array, index, array.length - index - 1);
        array[array.length - 1] = element;
    }

    public static Object[] append(Object[] first, Object[] second, Class elementClass) {
        int firstSize = first == null ? 0 : first.length;
        int secondSize = second == null ? 0 : second.length;
        Object[] array = (Object[])Array.newInstance(elementClass, firstSize + secondSize);
        if (firstSize > 0) {
            System.arraycopy(first, 0, array, 0, firstSize);
        }
        if (secondSize > 0) {
            System.arraycopy(second, 0, array, firstSize, secondSize);
        }
        return array;
    }

    public static Object[] subArray(Object[] source, int startIndex, int endIndex, Class elementClass) {
        int size = endIndex - startIndex + 1;
        Object[] array = (Object[])Array.newInstance(elementClass, size);
        System.arraycopy(source, startIndex, array, 0, size);
        return array;
    }

    public static void dumpArray(Object array, PrintStream out) {
        out.println("array component type: " + array.getClass().getComponentType());
        int length = Array.getLength(array);
        out.println("array length: " + length);
        int i = 0;
        while (i < length) {
            out.println(String.valueOf(i) + "; " + Array.get(array, i));
            ++i;
        }
    }

    public static int[] doubleIntArrayLength(int[] origArray) {
        if (origArray == null) {
            return null;
        }
        int[] newArray = new int[origArray.length * 2];
        System.arraycopy(origArray, 0, newArray, 0, origArray.length);
        return newArray;
    }

    public static boolean[] doubleBooleanArrayLength(boolean[] origArray) {
        if (origArray == null) {
            return null;
        }
        boolean[] newArray = new boolean[origArray.length * 2];
        System.arraycopy(origArray, 0, newArray, 0, origArray.length);
        return newArray;
    }

    public static String[] doubleStringArrayLength(String[] origArray) {
        if (origArray == null) {
            return null;
        }
        String[] newArray = new String[origArray.length * 2];
        System.arraycopy(origArray, 0, newArray, 0, origArray.length);
        return newArray;
    }

    public static Integer[] doubleIntegerArrayLength(Integer[] origArray) {
        if (origArray == null) {
            return null;
        }
        Integer[] newArray = new Integer[origArray.length * 2];
        System.arraycopy(origArray, 0, newArray, 0, origArray.length);
        return newArray;
    }
}

