/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.format;

import com.wily.utilities.properties.Messages;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;

public class BigValueFormat
extends NumberFormat {
    private static final long serialVersionUID = 1L;
    NumberFormat formatDelegate;
    static final long pivotM = 1000000L;
    static final long pivotB = 1000000000L;

    public BigValueFormat(Locale locale) {
        this.formatDelegate = NumberFormat.getNumberInstance(locale);
        this.formatDelegate.setMaximumFractionDigits(1);
    }

    public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
        if (number >= 1.0E9) {
            this.formatDelegate.format(number /= 1.0E9, toAppendTo, pos);
            toAppendTo.append("B");
            pos.setEndIndex(pos.getEndIndex() + 1);
        } else if (number >= 1000000.0) {
            this.formatDelegate.format(number /= 1000000.0, toAppendTo, pos);
            toAppendTo.append("M");
            pos.setEndIndex(pos.getEndIndex() + 1);
        } else {
            this.formatDelegate.format(number, toAppendTo, pos);
        }
        return toAppendTo;
    }

    public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
        return this.format((double)number, toAppendTo, pos);
    }

    public Number parse(String source, ParsePosition parsePosition) {
        throw new UnsupportedOperationException(Messages.getString("BigValueFormat.UnsupportedOperationError_Log"));
    }

    public int getMaximumFractionDigits() {
        return this.formatDelegate.getMaximumFractionDigits();
    }

    public int getMaximumIntegerDigits() {
        return this.formatDelegate.getMaximumIntegerDigits();
    }

    public int getMinimumFractionDigits() {
        return this.formatDelegate.getMinimumFractionDigits();
    }

    public int getMinimumIntegerDigits() {
        return this.formatDelegate.getMinimumIntegerDigits();
    }

    public void setGroupingUsed(boolean newValue) {
        this.formatDelegate.setGroupingUsed(newValue);
    }

    public void setMaximumFractionDigits(int newValue) {
        this.formatDelegate.setMaximumFractionDigits(newValue);
    }

    public void setMaximumIntegerDigits(int newValue) {
        this.formatDelegate.setMaximumIntegerDigits(newValue);
    }

    public void setMinimumFractionDigits(int newValue) {
        this.formatDelegate.setMinimumFractionDigits(newValue);
    }

    public void setMinimumIntegerDigits(int newValue) {
        this.formatDelegate.setMinimumIntegerDigits(newValue);
    }
}

