/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.powerpack.webservices.INameFormatter;
import com.wily.util.StringUtils;

public abstract class ANameFormatter
implements INameFormatter {
    private final IAgent fAgent;
    private static final ThreadLocal kThreadLocal = new ThreadLocal();

    public ANameFormatter(IAgent agent) {
        this.fAgent = agent;
    }

    protected IAgent getAgent() {
        return this.fAgent;
    }

    public String INameFormatter_format(String name, InvocationData data) {
        SOWrapper wrapper;
        String serviceName = null;
        String operationName = null;
        if (name != null) {
            if (name.indexOf("{servicename}", 0) >= 0) {
                serviceName = (String)data.get("com.wily.powerpack.webservices.trace.ServiceNameKey");
                if (serviceName == null || serviceName.equals("UnknownService")) {
                    serviceName = this.getServiceName(data);
                    if (serviceName.equals("UnknownService") && (wrapper = (SOWrapper)kThreadLocal.get()) != null && wrapper.ServiceName != null) {
                        serviceName = wrapper.ServiceName;
                    }
                    data.put("com.wily.powerpack.webservices.trace.ServiceNameKey", (Object)serviceName);
                }
                name = StringUtils.replace((String)name, (String)"{servicename}", (String)serviceName);
            }
            if (name.indexOf("{operationname}", 0) >= 0) {
                operationName = (String)data.get("com.wily.powerpack.webservices.trace.OperationNameKey");
                if (operationName == null || operationName.equals("UnknownOperationName")) {
                    operationName = this.getOperation(data);
                    if (operationName.equals("UnknownOperationName") && (wrapper = (SOWrapper)kThreadLocal.get()) != null && wrapper.OperationName != null) {
                        operationName = wrapper.OperationName;
                    }
                    data.put("com.wily.powerpack.webservices.trace.OperationNameKey", (Object)operationName);
                }
                name = StringUtils.replace((String)name, (String)"{operationname}", (String)operationName);
            }
        }
        if (kThreadLocal.get() == null) {
            wrapper = new SOWrapper();
            wrapper.OperationName = operationName;
            wrapper.ServiceName = serviceName;
            kThreadLocal.set(wrapper);
        } else {
            wrapper = (SOWrapper)kThreadLocal.get();
            if (operationName != null) {
                wrapper.OperationName = operationName;
            }
            if (serviceName != null) {
                wrapper.ServiceName = serviceName;
            }
        }
        return name;
    }

    class SOWrapper {
        public String ServiceName;
        public String OperationName;

        SOWrapper() {
        }
    }
}

