/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.errors.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.feature.FaultFeature;
import com.wily.introscope.agent.trace.ASingleMetricTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.powerpack.webservices.KConstants;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.AttributeListing;

public abstract class SoapFaultReportingTracer
extends ASingleMetricTracerFactory
implements KConstants {
    protected IModuleFeedbackChannel logger = null;

    public SoapFaultReportingTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.logger = agent.IAgent_getModuleFeedback();
        WSMUtils.refreshLogLevels();
    }

    protected Object getMessageContext(InvocationData data) {
        Object context = data.getInvocationParameterAsObject(0);
        return context;
    }

    public void ITracer_startTrace(int index, InvocationData data) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Started SOAP Fault Trace:" + this.getTitle());
        }
    }

    public void ITracer_finishTrace(int index, InvocationData data) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Finished SOAP Fault Trace:" + this.getTitle());
        }
        String faultErrorMessage = this.getFaultMessage(data);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Fault Error message:" + faultErrorMessage);
        }
        String component = this.getFormattedName();
        this.logger.debug("SoapFaultReportingTracer::component:" + component);
        int nOperationIndex = component.indexOf("{operationname}");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.valueOf(this.getTitle()) + "_finishTrace nOperationIndex= " + nOperationIndex + " component=" + component);
        }
        if (faultErrorMessage != null && !faultErrorMessage.equals("") && nOperationIndex != -1) {
            this.reportFault("SOAP Fault:" + faultErrorMessage, data);
        }
        if (faultErrorMessage != null && !faultErrorMessage.equals("")) {
            FaultFeature.incrementFaultMetric((InvocationData)data);
        }
    }

    protected void reportFault(String message, InvocationData data) {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(String.valueOf(this.getTitle()) + " reportFault message " + message);
            }
            FaultFeature.constructAndSendFaultSnapshotToServer((InvocationData)data, (String)message, (IAgent)this.getAgent());
            FaultFeature.decorateTransactionsWithFault((InvocationData)data, (String)message);
        }
        catch (Throwable t) {
            this.logger.debug(String.valueOf(this.getTitle()) + " ClientFaultTracer reportFault throwable" + t);
        }
    }

    protected abstract String getFaultMessage(InvocationData var1);

    protected abstract String getTitle();
}

