/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.fault.cxf;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.IComponentParameterCallback;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.stat.ILongIntervalCounterDataAccumulator;
import com.wily.introscope.agent.trace.ASingleMetricTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.powerpack.webservices.KConstants;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.extension.agent.errors.SoapFaultSnapshotFeatureFactory;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.AttributeListing;
import java.util.Map;

public class CXFAsyncResponseClientFaultTracer
extends ASingleMetricTracerFactory
implements KConstants {
    protected IModuleFeedbackChannel logger = null;

    public CXFAsyncResponseClientFaultTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.logger = agent.IAgent_getModuleFeedback();
        WSMUtils.refreshLogLevels();
    }

    public void ITracer_finishTrace(int index, InvocationData data) {
        try {
            ILongIntervalCounterDataAccumulator count;
            if (data.get("isAsync") == null) {
                return;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Finished SOAP Fault Trace:" + this.getTitle());
            }
            String faultErrorMessage = this.getFaultMessage(data);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Fault Error message:" + faultErrorMessage);
            }
            String componentForFault = this.getFormattedResource();
            int nOperationIndex = componentForFault.indexOf("{operationname}");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(String.valueOf(this.getTitle()) + "_finishTrace nOperationIndex= " + nOperationIndex + " componentForFault=" + componentForFault);
            }
            if (faultErrorMessage != null && !faultErrorMessage.equals("") && nOperationIndex != -1) {
                this.reportFault("SOAP Fault:" + faultErrorMessage, data);
            }
            if (faultErrorMessage != null && !faultErrorMessage.equals("") && !(count = (ILongIntervalCounterDataAccumulator)this.getDataAccumulator(data)).IDataAccumulator_isShutOff()) {
                count.ILongIntervalCounterDataAccumulator_addSingleIncident();
            }
            String component = this.formatParameterizedResource(data);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("ITracer_finishTrace component=" + component);
            }
            this.getComponentTracer().removeComponent(component);
        }
        catch (Exception e) {
            WSMUtils.handleException(this.getAgent(), "CXFAsyncResponseClientFaultTracer:ITracer_finishTrace exception", e);
        }
    }

    public void ITracer_startTrace(int index, InvocationData data) {
        try {
            Object objClientImpl;
            Map mapRequestContext;
            Boolean isAsync;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Started CXFAsyncResponseClientFaultTracer");
            }
            if (!(isAsync = (Boolean)(mapRequestContext = (Map)(objClientImpl = data.getInvocationObject()).getClass().getMethod("getRequestContext", new Class[0]).invoke(objClientImpl, new Object[0])).get("com.wily.cxf.jaxws.client.isAsync")).booleanValue()) {
                return;
            }
            data.put("com.wily.powerpack.webservices.trace.NamespaceKey", mapRequestContext.get("com.wily.powerpack.webservices.trace.NamespaceKey"));
            data.put("com.wily.powerpack.webservices.trace.OperationNameKey", mapRequestContext.get("com.wily.powerpack.webservices.trace.OperationNameKey"));
            data.put("com.wily.powerpack.webservices.trace.ServiceNameKey", mapRequestContext.get("com.wily.powerpack.webservices.trace.ServiceNameKey"));
            data.put("isPopulated", (Object)true);
            data.put("isAsync", (Object)true);
            String component = this.formatParameterizedResource(data);
            this.logger.debug("CXFAsyncResponseClientFaultTracer:ITracer_startTrace component=" + component);
            this.getComponentTracer().addComponent(component, (IComponentParameterCallback)data);
        }
        catch (Exception e) {
            WSMUtils.handleException(this.getAgent(), "CXFAsyncResponseClientFaultTracer:ITracer_startTrace exception", e);
        }
    }

    protected String getFaultMessage(InvocationData data) {
        try {
            Throwable error = data.getInvocationThrownException();
            if (error != null) {
                return error.getMessage();
            }
            Object objMessage = data.getInvocationParameterAsObject(0);
            Object objExchange = WSMUtils.invokeMethodOnObject(objMessage, "getExchange");
            Object objInFaultMessage = WSMUtils.invokeMethodOnObject(objExchange, "getInFaultMessage");
            return WSMUtils.invokeMethodOnObject(objInFaultMessage, "getContent", new Class[]{Class.class}, new Object[]{Exception.class}).toString();
        }
        catch (Exception e) {
            WSMUtils.handleException(this.getAgent(), "CXFAsyncResponseClientFaultTracer:ITracer_finishTrace", e);
            return null;
        }
    }

    protected IDataAccumulator createDataAccumulator(String formattedMetricName) {
        return this.getDataAccumulatorFactory().safeGetLongIntervalCounterDataAccumulator(formattedMetricName);
    }

    protected String getTitle() {
        return "CXF Async Client Fault Tracer";
    }

    protected void reportFault(String message, InvocationData data) {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(String.valueOf(this.getTitle()) + " reportFault message " + message);
            }
            SoapFaultSnapshotFeatureFactory.flagErrorInManagedApplication(message);
        }
        catch (Throwable t) {
            WSMUtils.handleException(this.getAgent(), "CXFAsyncResponseClientFaultTracer:reportFault", t);
        }
    }
}

