/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.substituteresult.axis;

import com.wily.introscope.agent.AgentShim;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.extension.agent.UnsupportedHandlerException;
import com.wily.powerpack.webservices.extension.agent.WSDMHandlerInstantiationException;
import java.util.Hashtable;
import org.apache.axis.AxisEngine;
import org.apache.axis.Handler;
import org.apache.axis.MessageContext;
import org.apache.axis.SimpleChain;
import org.apache.axis.client.AxisClient;
import org.apache.axis.handlers.JAXRPCHandler;
import org.apache.axis.server.AxisServer;

public class Axis13ModifyGlobalHandler {
    private static final String kAxis13ClientGlobalRequestPrependHandler = "com.wily.introscope.soa.client.requesthandler.prependhandler";
    private static final String kAxis13ServerGlobalRequestAppendHandler = "com.wily.introscope.soa.server.requesthander.appendhandler";
    private static final String kAxis13ClientGlobalResponseAppendHandler = "com.wily.introscope.soa.client.responsehandler.appendhandler";
    private static final String kAxis13ServerGlobalResponsePrependHandler = "com.wily.introscope.soa.server.responsehander.prependhandler";
    private static final String kAxisClassNameWSDMHandlerProperty = "className";
    private static final String kAxisWSDMHandlerClassName = "com.wily.powerpack.webservices.handlers.axis.WsdmJaxRpcHandler";
    private static final String kAxis13ServerGlobalRequestHandler = "com.wily.powerpack.webservices.Axis13ServerGlobalRequestHandler";
    private static final String kAxis13ServerGlobalResponseHandler = "com.wily.powerpack.webservices.Axis13ServerGlobalResponseHandler";
    private static final String kAxis13ClientGlobalRequestHandler = "com.wily.powerpack.webservices.Axis13ClientGlobalRequestHandler";
    private static final String kAxis13ClientGlobalResponseHandler = "com.wily.powerpack.webservices.Axis13ClientGlobalResponseHandler";

    public static Handler getClientWsdmHandler() {
        return ClientHandlerHolder.wsdmHandler;
    }

    public static Handler getServerWsdmHandler() {
        return ServerHandlerHolder.wsdmHandler;
    }

    private static Handler getWSDMHandler(Hashtable config) throws WSDMHandlerInstantiationException {
        JAXRPCHandler handler;
        try {
            config.put(kAxisClassNameWSDMHandlerProperty, kAxisWSDMHandlerClassName);
            handler = new JAXRPCHandler();
            handler.setOptions(config);
            handler.init();
        }
        catch (ThreadDeath bomb) {
            throw bomb;
        }
        catch (Throwable bomb) {
            throw new WSDMHandlerInstantiationException(bomb);
        }
        return handler;
    }

    private static Handler appendWSDMHandler(Handler handlerChain, Handler WSDMHandler) throws UnsupportedHandlerException {
        if (handlerChain != null && !(handlerChain instanceof SimpleChain)) {
            StringBuffer message = new StringBuffer();
            message.append(" Detected unsupported handler chain ").append(handlerChain.getClass());
            throw new UnsupportedHandlerException(message.toString());
        }
        handlerChain = Axis13ModifyGlobalHandler.appendWSDMHandler((SimpleChain)handlerChain, WSDMHandler);
        return handlerChain;
    }

    private static Handler prependWSDMHandler(Handler handlerChain, Handler WSDMHandler) throws UnsupportedHandlerException {
        if (handlerChain != null && !(handlerChain instanceof SimpleChain)) {
            StringBuffer message = new StringBuffer();
            message.append(" Detected unsupported handler chain ").append(handlerChain.getClass());
            throw new UnsupportedHandlerException(message.toString());
        }
        handlerChain = Axis13ModifyGlobalHandler.prependWSDMHandler((SimpleChain)handlerChain, WSDMHandler);
        return handlerChain;
    }

    private static SimpleChain appendWSDMHandler(SimpleChain handlerChain, Handler WSDMHandler) {
        StringBuffer message = new StringBuffer();
        message.append(Thread.currentThread()).append(" [").append("::appendWSDMHandler] ").append(" Appending WSDM handler to handler chain, size=").append(handlerChain == null ? "null" : Integer.toString(handlerChain.getHandlers().length));
        WSMUtils.getLogger().trace(WSMUtils.getModule(), message.toString());
        SimpleChain newHandlerChain = new SimpleChain();
        if (handlerChain != null) {
            Handler[] handlers = handlerChain.getHandlers();
            WSMUtils.getLogger().debug(WSMUtils.getModule(), "Append WSDM handler");
            int iter = 0;
            while (iter < handlers.length) {
                newHandlerChain.addHandler(handlers[iter]);
                WSMUtils.getLogger().debug(WSMUtils.getModule(), "Handler[" + iter + "]:" + handlers[iter].getClass().getName());
                ++iter;
            }
        }
        newHandlerChain.addHandler(WSDMHandler);
        WSMUtils.getLogger().debug(WSMUtils.getModule(), "Handler[" + (newHandlerChain.getHandlers().length - 1) + "]:" + WSDMHandler.getClass().getName());
        return newHandlerChain;
    }

    private static SimpleChain prependWSDMHandler(SimpleChain handlerChain, Handler WSDMHandler) {
        StringBuffer message = new StringBuffer();
        message.append(Thread.currentThread()).append(" [").append("::prependWSDMHandler] ").append(" Prepending WSDM handler to handler chain, size=").append(handlerChain == null ? "null" : Integer.toString(handlerChain.getHandlers().length));
        WSMUtils.getLogger().trace(WSMUtils.getModule(), message.toString());
        SimpleChain newHandlerChain = new SimpleChain();
        newHandlerChain.addHandler(WSDMHandler);
        WSMUtils.getLogger().debug(WSMUtils.getModule(), "Prepend WSDM handler");
        WSMUtils.getLogger().debug(WSMUtils.getModule(), "Handler[" + (newHandlerChain.getHandlers().length - 1) + "]:" + WSDMHandler.getClass().getName());
        if (handlerChain != null) {
            Handler[] handlers = handlerChain.getHandlers();
            int iter = 0;
            while (iter < handlers.length) {
                newHandlerChain.addHandler(handlers[iter]);
                WSMUtils.getLogger().debug(WSMUtils.getModule(), "Handler[" + (iter + 1) + "]:" + handlers[iter].getClass().getName());
                ++iter;
            }
            newHandlerChain.setName(handlerChain.getName());
            newHandlerChain.setOptions(handlerChain.getOptions());
        }
        return newHandlerChain;
    }

    private static MessageContext getMessageContext() {
        return AxisEngine.getCurrentMessageContext();
    }

    private static AxisEngine getAxisEngine() {
        return Axis13ModifyGlobalHandler.getMessageContext().getAxisEngine();
    }

    private static AxisEngine getAxisEngine(MessageContext msgCtx) {
        return msgCtx.getAxisEngine();
    }

    public static Handler modifyGlobalRequestHandler(Handler handler) {
        Handler newHandler = handler;
        WSMUtils.refreshLogLevels();
        try {
            StringBuffer message = new StringBuffer();
            message.append(Thread.currentThread()).append(" [").append(Axis13ModifyGlobalHandler.class).append("::modifyGlobalRequestHandler] ").append("Modifying global REQUEST handler");
            WSMUtils.getLogger().trace(WSMUtils.getModule(), message.toString());
            MessageContext msgCtx = Axis13ModifyGlobalHandler.getMessageContext();
            AxisEngine engine = Axis13ModifyGlobalHandler.getAxisEngine(msgCtx);
            if (engine instanceof AxisClient) {
                boolean prop;
                String message2 = Thread.currentThread() + " Getting global REQUEST handler for Axis CLIENT engine";
                WSMUtils.getLogger().debug(message2);
                Handler wsdmHandler = Axis13ModifyGlobalHandler.getClientWsdmHandler();
                newHandler = wsdmHandler != null ? ((prop = AgentShim.getAgentShim().IAgentShim_getAgent().IAgent_getIndexedProperties().getBooleanProperty(kAxis13ClientGlobalRequestPrependHandler, true)) ? Axis13ModifyGlobalHandler.prependWSDMHandler(handler, wsdmHandler) : Axis13ModifyGlobalHandler.appendWSDMHandler(handler, wsdmHandler)) : handler;
            } else if (engine instanceof AxisServer) {
                boolean prop;
                String message3 = Thread.currentThread() + " Getting global REQUEST handler for Axis SERVER engine";
                WSMUtils.getLogger().debug(message3);
                Handler wsdmHandler = Axis13ModifyGlobalHandler.getServerWsdmHandler();
                newHandler = wsdmHandler != null ? ((prop = AgentShim.getAgentShim().IAgentShim_getAgent().IAgent_getIndexedProperties().getBooleanProperty(kAxis13ServerGlobalRequestAppendHandler, true)) ? Axis13ModifyGlobalHandler.appendWSDMHandler(handler, wsdmHandler) : Axis13ModifyGlobalHandler.prependWSDMHandler(handler, wsdmHandler)) : handler;
            } else {
                String message4 = Thread.currentThread() + " Detected unsupported Axis engine " + engine.getClass() + ", ignoring global REQUEST handler";
                WSMUtils.getLogger().debug(message4.toString());
            }
        }
        catch (ThreadDeath bomb) {
            throw bomb;
        }
        catch (Throwable bomb) {
            try {
                StringBuffer message = new StringBuffer();
                message.append(Thread.currentThread()).append(" Caught unexpected exception while modifying global REQUEST handler, ").append(bomb).append(", using configured global REQUEST handler");
                WSMUtils.getLogger().error(message.toString());
            }
            catch (Throwable throwable) {}
            newHandler = handler;
        }
        return newHandler;
    }

    private static void onError(String s) {
        String message = Thread.currentThread() + "Unexpected error while modifying handlers, " + s;
        WSMUtils.getLogger().error(message);
    }

    public static Handler modifyGlobalResponseHandler(Handler handler) {
        Handler newHandler = handler;
        WSMUtils.refreshLogLevels();
        try {
            String message = Thread.currentThread() + " [" + Axis13ModifyGlobalHandler.class + "::modifyGlobalResponseHandler] " + "Modifying global RESPONSE handler";
            WSMUtils.getLogger().debug(message);
            MessageContext msgCtx = Axis13ModifyGlobalHandler.getMessageContext();
            AxisEngine engine = Axis13ModifyGlobalHandler.getAxisEngine(msgCtx);
            if (engine instanceof AxisClient) {
                String message2 = Thread.currentThread() + " Getting global RESPONSE handler for Axis CLIENT engine";
                WSMUtils.getLogger().debug(message2);
                Handler wsdmHandler = Axis13ModifyGlobalHandler.getClientWsdmHandler();
                WSMUtils.getLogger().debug("Handler is :" + (wsdmHandler != null));
                if (wsdmHandler != null) {
                    boolean prop = AgentShim.getAgentShim().IAgentShim_getAgent().IAgent_getIndexedProperties().getBooleanProperty(kAxis13ClientGlobalResponseAppendHandler, true);
                    newHandler = prop ? Axis13ModifyGlobalHandler.appendWSDMHandler(handler, wsdmHandler) : Axis13ModifyGlobalHandler.prependWSDMHandler(handler, wsdmHandler);
                }
            } else if (engine instanceof AxisServer) {
                String message3 = Thread.currentThread() + " Getting global RESPONSE handler for Axis SERVER engine";
                WSMUtils.getLogger().debug(message3);
                Handler wsdmHandler = Axis13ModifyGlobalHandler.getServerWsdmHandler();
                WSMUtils.getLogger().debug("Handler is :" + (wsdmHandler != null));
                if (wsdmHandler != null) {
                    boolean prop = AgentShim.getAgentShim().IAgentShim_getAgent().IAgent_getIndexedProperties().getBooleanProperty(kAxis13ServerGlobalResponsePrependHandler, true);
                    newHandler = prop ? Axis13ModifyGlobalHandler.prependWSDMHandler(handler, wsdmHandler) : Axis13ModifyGlobalHandler.appendWSDMHandler(handler, wsdmHandler);
                }
            } else {
                String message4 = Thread.currentThread() + " Detected unsupported Axis Engine " + engine.getClass() + ", ignoring global RESPONSE handler";
                WSMUtils.getLogger().debug(message4);
            }
        }
        catch (ThreadDeath bomb) {
            throw bomb;
        }
        catch (Throwable bomb) {
            try {
                StringBuffer message = new StringBuffer();
                message.append(Thread.currentThread()).append(" Caught unexpected exception while modifying global RESPONSE handler, ").append(bomb).append(", using configured global RESPONSE handler");
                WSMUtils.getLogger().error(message.toString());
            }
            catch (Throwable throwable) {}
            newHandler = handler;
        }
        return newHandler;
    }

    private static class ClientHandlerHolder {
        public static Handler wsdmHandler = null;

        static {
            try {
                wsdmHandler = Axis13ModifyGlobalHandler.getWSDMHandler(WSMUtils.getWSDMHandlerConfig("2"));
            }
            catch (WSDMHandlerInstantiationException e) {
                ClientHandlerHolder.onError((Exception)((Object)e));
            }
        }

        private ClientHandlerHolder() {
        }

        private static void onError(Exception e) {
            String message = Thread.currentThread() + " Caught unexpected exception while modifying client handlers, " + e;
            WSMUtils.getLogger().error(message.toString());
        }
    }

    private static class ServerHandlerHolder {
        public static Handler wsdmHandler = null;

        static {
            try {
                wsdmHandler = Axis13ModifyGlobalHandler.getWSDMHandler(WSMUtils.getWSDMHandlerConfig("1"));
            }
            catch (WSDMHandlerInstantiationException e) {
                ServerHandlerHolder.onError((Exception)((Object)e));
            }
        }

        private ServerHandlerHolder() {
        }

        private static void onError(Exception e) {
            String message = Thread.currentThread() + " Caught unexpected exception while modifying server handlers, " + e;
            WSMUtils.getLogger().error(message.toString());
        }
    }
}

