/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.weblogic;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.AttributeListing;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SEIStubCorrelationTracer
extends ASingleInstanceTracerFactory {
    private final IAgent agent;
    protected IModuleFeedbackChannel logger = null;

    public SEIStubCorrelationTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.agent = agent;
        this.logger = agent.IAgent_getModuleFeedback();
        WSMUtils.refreshLogLevels();
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        WSMUtils.getLogger().debug("START:SEIStubCorrelationTracer.ITracer_startTrace()");
        try {
            Object objPacket = data.getInvocationParameterAsObject(0);
            Field fldInvocation = objPacket.getClass().getField("invocationProperties");
            Map invocationProps = (Map)fldInvocation.get(objPacket);
            Map userHeaders = (HashMap)invocationProps.get("javax.xml.ws.http.request.headers");
            if (userHeaders == null) {
                String headersClassName = WSMUtils.getJAXWSHeadersClassName();
                if (headersClassName != null && headersClassName != "") {
                    if (WSMUtils.getLogger().isDebugEnabled()) {
                        WSMUtils.getLogger().debug("SEIStubCorrelationTracer.ITracer_startTrace(): handle JAX-WS headers as " + headersClassName);
                    }
                    ClassLoader classLoader = objPacket.getClass().getClassLoader();
                    Class<?> headersClass = Class.forName(headersClassName, true, classLoader);
                    userHeaders = (Map)headersClass.newInstance();
                } else {
                    WSMUtils.getLogger().debug("SEIStubCorrelationTracer.ITracer_startTrace(): handle JAX-WS headers as HashMap.");
                    userHeaders = new HashMap();
                }
                invocationProps.put("javax.xml.ws.http.request.headers", userHeaders);
            }
            this.insertHTTPCorrelationInfo(userHeaders);
        }
        catch (Exception e) {
            WSMUtils.getLogger().info("SEIStubCorrelationTracer Error " + WSMUtils.dumpStackTrace(e));
        }
    }

    protected void insertHTTPCorrelationInfo(Map userHeaders) {
        if (!WSMUtils.correlationHTTPInsertionEnabled()) {
            return;
        }
        String correlationString = new CorrelationId().getOutgoingCorrelationIdStrippedForHeader();
        WSMUtils.getLogger().debug("SEIStubCorrelationTracer.ITracer_startTrace() correlationString=" + correlationString);
        List<String> correlationList = Collections.singletonList(correlationString);
        userHeaders.put("CorID", correlationList);
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    public boolean ITracerFactory_isShutoff() {
        return false;
    }

    public void ITracer_finishTrace(int arg0, InvocationData arg1) {
        if (!WSMUtils.correlationHTTPInsertionEnabled()) {
            return;
        }
        new CorrelationId().decrementCorrelationCount();
    }
}

