/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.connection.IsengardServerConnectionManager;
import com.wily.org.apache.log4j.RollingFileAppender;
import com.wily.util.INameChangeListener;
import com.wily.util.LogFileUtilities;
import com.wily.util.heartbeat.WaitAndExecuteBehavior;
import java.io.File;
import java.io.IOException;

public class AutoNamingRollingFileAppender
extends RollingFileAppender {
    private static final int kSendEnvironmentCycleTime = 30000;
    private boolean fLogFileAutoNamingEnabled = false;
    private String fSuffix = null;
    private String fBaseLogFileName = null;
    private boolean fTimestampSetBefore = false;
    private String fLastLogFileName = null;
    private IAgent fAgent = null;

    public AutoNamingRollingFileAppender() {
        try {
            this.fAgent = AgentShim.getAgent();
        }
        catch (AgentNotAvailableException anae) {
            AgentShim.handleError("AutoNamingRollingFileAppender: Unable to access Introscope Agent.  Auto Naming of the Introscope Agent logfile will be disabled", anae);
        }
        if (this.fAgent != null) {
            this.fLogFileAutoNamingEnabled = this.fAgent.IAgent_isLogFileAutoNamingEnabled();
            IsengardServerConnectionManager serverConnection = this.fAgent.IAgent_getIsengardServerConnection();
            if (serverConnection != null) {
                this.fSuffix = serverConnection.getActualAgentName();
            }
            if (this.fLogFileAutoNamingEnabled) {
                final INameChangeListener listener = new INameChangeListener(){

                    public void INameChangeListener_nameChanged(String newName) {
                        AutoNamingRollingFileAppender.this.setSuffix(newName);
                        if (AutoNamingRollingFileAppender.this.fileName != null) {
                            AutoNamingRollingFileAppender.this.activateOptions();
                        }
                    }
                };
                new WaitAndExecuteBehavior(this.fAgent.IAgent_getCommonHeartbeat(), 30000L, "Check Connection for setup Agent log negotiated name listener"){

                    protected boolean execute() {
                        IsengardServerConnectionManager m = AutoNamingRollingFileAppender.this.fAgent.IAgent_getIsengardServerConnection();
                        if (m != null && m.getConnectedServer() != null && m.getConnectedServer().isConnected()) {
                            AutoNamingRollingFileAppender.this.fAgent.IAgent_addNameChangeListener(listener);
                            AutoNamingRollingFileAppender.this.fAgent.IAgent_addNegotiatedNameChangeListener(listener);
                            return true;
                        }
                        return false;
                    }
                };
            }
        }
    }

    public void setSuffix(String suffix) {
        this.fSuffix = suffix;
        if (this.isLogFileAutoNamingEnabled() && this.fBaseLogFileName != null) {
            this.setFile(this.fBaseLogFileName);
        }
    }

    private boolean isLogFileAutoNamingEnabled() {
        return this.fLogFileAutoNamingEnabled;
    }

    public void setFile(String fileName) {
        if (this.fBaseLogFileName == null) {
            this.fBaseLogFileName = fileName;
        }
        if (this.isLogFileAutoNamingEnabled()) {
            this.fLastLogFileName = this.fileName;
            if (this.fSuffix == null && !this.fTimestampSetBefore) {
                try {
                    fileName = LogFileUtilities.appendUniqueTimestampToLogFileName(fileName);
                }
                catch (Exception exception) {
                    fileName = this.fBaseLogFileName;
                }
                this.fTimestampSetBefore = true;
            } else {
                fileName = LogFileUtilities.appendIdentifierToLogFileName(fileName, this.fSuffix);
            }
        }
        super.setFile(fileName);
    }

    public synchronized void setFile(String fileName, boolean append, boolean bufferedIO, int bufferSize) throws IOException {
        if (this.isLogFileAutoNamingEnabled() && fileName != null && this.fLastLogFileName != null && fileName.compareTo(this.fLastLogFileName) != 0) {
            this.reset();
            File oldFile = new File(this.fLastLogFileName);
            new File(fileName);
            if (oldFile.exists()) {
                boolean success = LogFileUtilities.renameLogFile(this.fLastLogFileName, fileName, this.getAppend(), 262144);
                if (success) {
                    append = true;
                    this.fAgent.IAgent_getModuleFeedback().info(this.fAgent.IAgent_getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Log_File_Renamed_Message", this.fLastLogFileName, fileName));
                } else {
                    this.fAgent.IAgent_getModuleFeedback().info(this.fAgent.IAgent_getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Log_File_Renaming_Failed_Message", this.fLastLogFileName, fileName));
                    this.setFile(this.fLastLogFileName);
                }
            }
        }
        super.setFile(fileName, append, bufferedIO, bufferSize);
    }
}

