/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.api;

import com.wily.introscope.agent.api.ADataRecorderImpl;
import com.wily.introscope.agent.api.IllegalValueException;
import com.wily.introscope.agent.api.TimestampDataRecorder;
import com.wily.introscope.agent.recording.MetricRecordingAdministrator;
import com.wily.introscope.agent.stat.ILongMonotonicallyIncreasingCounterDataAccumulator;

final class TimestampDataRecorderImpl
extends ADataRecorderImpl
implements TimestampDataRecorder {
    private static final String kTimestampLessThanRecordedTimestampMessage = "timestamp is less than the currently recorded timestamp";
    private static final String kTimestampCannotBeNegativeMessage = "timestamp cannot be negative";

    TimestampDataRecorderImpl(ILongMonotonicallyIncreasingCounterDataAccumulator backingAccumulator, MetricRecordingAdministrator metricRecordingAdministrator) {
        super(backingAccumulator, metricRecordingAdministrator);
    }

    private ILongMonotonicallyIncreasingCounterDataAccumulator getBackingLongMonotonicallyIncreasingCounterAccumulator() {
        return (ILongMonotonicallyIncreasingCounterDataAccumulator)this.getBackingDataAccumulator();
    }

    public synchronized void recordTimestamp(long timestamp) throws IllegalValueException {
        if (timestamp < 0L) {
            throw new IllegalValueException(kTimestampCannotBeNegativeMessage);
        }
        if (timestamp < this.getCurrentTimestamp()) {
            throw new IllegalValueException(kTimestampLessThanRecordedTimestampMessage);
        }
        this.getBackingLongMonotonicallyIncreasingCounterAccumulator().ILongCounterDataAccumulator_setValue(timestamp);
    }

    private long getCurrentTimestamp() {
        return this.getBackingLongMonotonicallyIncreasingCounterAccumulator().ILongCounterDataAccumulator_getLongValue();
    }
}

