/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.beans;

import com.wily.introscope.agent.IAgent;
import com.wily.isengard.IsengardException;
import com.wily.isengard.container.beans.AIsengardBean;
import com.wily.isengard.messageprimitives.ConnectionException;
import com.wily.isengard.messageprimitives.InvalidIsengardInterface;
import com.wily.isengard.util.tree.EntryAlreadyExistsException;
import com.wily.isengard.util.tree.InvalidPathException;
import com.wily.util.INameChangeListener;

public abstract class AAgentRemoteBean
extends AIsengardBean {
    private IAgent fAgent;
    private String fAgentHost;
    private String fAgentProcess;
    private String fQualifiedAgentName;
    private INameChangeListener fChangeListener;
    private volatile boolean fActive;

    public AAgentRemoteBean() {
        this.setChangeListener(this.createChangeListener());
    }

    public void setAgent(IAgent fAgent) {
        this.fAgent = fAgent;
    }

    public IAgent getAgent() {
        return this.fAgent;
    }

    public void setAgentHost(String fAgentHost) {
        this.fAgentHost = fAgentHost;
    }

    public String getAgentHost() {
        return this.fAgentHost;
    }

    public void setAgentProcess(String fAgentProcess) {
        this.fAgentProcess = fAgentProcess;
    }

    public String getAgentProcess() {
        return this.fAgentProcess;
    }

    public void setQualifiedAgentName(String fQualifiedAgentName) {
        this.fQualifiedAgentName = fQualifiedAgentName;
    }

    public String getQualifiedAgentName() {
        return this.fQualifiedAgentName;
    }

    private void setChangeListener(INameChangeListener fChangeListener) {
        this.fChangeListener = fChangeListener;
    }

    protected INameChangeListener getChangeListener() {
        return this.fChangeListener;
    }

    protected abstract INameChangeListener createChangeListener();

    public void activate() throws IsengardException {
        this.setAgent((IAgent)this.getBeanDescriptor().getInstanceData());
        String[] hostProcessAgent = this.getAgent().IAgent_getHostProcessAgentTriplet();
        this.setAgentHost(hostProcessAgent[0]);
        this.setAgentProcess(hostProcessAgent[1]);
        this.fActive = true;
        this.getAgent().IAgent_addNegotiatedNameChangeListener(this.getChangeListener());
    }

    protected abstract Class getServiceClass();

    public void passivate() {
        INameChangeListener listener = this.getChangeListener();
        if (listener != null) {
            this.getAgent().IAgent_removeNegotiatedNameChangeListener(listener);
        }
        this.fActive = false;
        super.passivate();
    }

    private boolean isActive() {
        return this.fActive;
    }

    public void destroyMessageServiceFromListener(Class serviceClass) throws InvalidPathException, InvalidIsengardInterface, ConnectionException {
        this.destroyMessageService(serviceClass, this.getQualifiedAgentName());
    }

    public void createMessageServiceFromListener(Class serviceClass, String qualifiedAgentName, String[] strings) throws EntryAlreadyExistsException, InvalidPathException, InvalidIsengardInterface, ConnectionException {
        this.createMessageService(serviceClass, this.getQualifiedAgentName(), new String[]{"Workstation", "Server"});
    }
}

