/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.bizrecording;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

class ResponseWrapper {
    private static final HashMap kDefaultMessages;
    private static final int kDefaultStatusCode = 200;
    private static final String kUnknownMessage = "Unknown";
    private static final String kDefaultContentType;
    private static final String kCharSetPrefix = ";charset=";
    private int fStatusCode;
    private String fMessage;
    private String fContentType;
    private HashMap fHeaders;
    private String fAssembledHeader = null;

    static {
        kDefaultContentType = null;
        kDefaultMessages = new HashMap();
        kDefaultMessages.put(new Integer(100), "Continue");
        kDefaultMessages.put(new Integer(101), "Switching Protocols");
        kDefaultMessages.put(new Integer(200), "OK");
        kDefaultMessages.put(new Integer(201), "Created");
        kDefaultMessages.put(new Integer(202), "Accepted");
        kDefaultMessages.put(new Integer(203), "Non-Authoritative Information");
        kDefaultMessages.put(new Integer(204), "No Content");
        kDefaultMessages.put(new Integer(205), "Reset Content");
        kDefaultMessages.put(new Integer(206), "Partial Content");
        kDefaultMessages.put(new Integer(300), "Multiple Choices");
        kDefaultMessages.put(new Integer(301), "Moved Permanently");
        kDefaultMessages.put(new Integer(302), "Found");
        kDefaultMessages.put(new Integer(303), "See Other");
        kDefaultMessages.put(new Integer(304), "Not Modified");
        kDefaultMessages.put(new Integer(305), "Use Proxy");
        kDefaultMessages.put(new Integer(307), "Temporary Redirect");
        kDefaultMessages.put(new Integer(400), "Bad Request");
        kDefaultMessages.put(new Integer(401), "Unauthorized");
        kDefaultMessages.put(new Integer(402), "Payment Required");
        kDefaultMessages.put(new Integer(403), "Forbidden");
        kDefaultMessages.put(new Integer(404), "Not Found");
        kDefaultMessages.put(new Integer(405), "Method Not Allowed");
        kDefaultMessages.put(new Integer(406), "Not Acceptable");
        kDefaultMessages.put(new Integer(407), "Proxy Authentication Required");
        kDefaultMessages.put(new Integer(408), "Request Time-out");
        kDefaultMessages.put(new Integer(409), "Conflict");
        kDefaultMessages.put(new Integer(410), "Gone");
        kDefaultMessages.put(new Integer(411), "Length Required");
        kDefaultMessages.put(new Integer(412), "Precondition Failed");
        kDefaultMessages.put(new Integer(413), "Request Entity Too Large");
        kDefaultMessages.put(new Integer(414), "Request-URI Too Large");
        kDefaultMessages.put(new Integer(415), "Unsupported Media Type");
        kDefaultMessages.put(new Integer(416), "Requested range not satisfiable");
        kDefaultMessages.put(new Integer(417), "Expectation Failed");
        kDefaultMessages.put(new Integer(500), "Internal Server Error");
        kDefaultMessages.put(new Integer(501), "Not Implemented");
        kDefaultMessages.put(new Integer(502), "Bad Gateway");
        kDefaultMessages.put(new Integer(503), "Service Unavailable");
        kDefaultMessages.put(new Integer(504), "Gateway Time-out");
        kDefaultMessages.put(new Integer(505), "HTTP Version not supported");
    }

    ResponseWrapper() {
        this.setStatusCode(200, null);
        this.fContentType = kDefaultContentType;
        this.fHeaders = new HashMap();
    }

    void setCharacterEncoding(String charEncoding) {
        if (charEncoding == null || charEncoding.equals("")) {
            return;
        }
        String charSetSuffixForContentType = kCharSetPrefix + charEncoding;
        if (this.fContentType != null) {
            int endOfContType = this.fContentType.indexOf(";");
            this.fContentType = endOfContType == -1 ? String.valueOf(this.fContentType) + charSetSuffixForContentType : String.valueOf(this.fContentType.substring(0, endOfContType)) + charSetSuffixForContentType;
        }
    }

    void setStatusCode(int sc, String msg) {
        this.fStatusCode = sc;
        if (msg == null) {
            this.fMessage = (String)kDefaultMessages.get(new Integer(sc));
        }
        if (this.fMessage == null) {
            this.fMessage = kUnknownMessage;
        }
    }

    void setContentType(String contentType) {
        this.fContentType = contentType;
    }

    void addHeader(String key, String value) {
        this.fAssembledHeader = null;
        if (this.fHeaders.containsKey(key)) {
            Object old = this.fHeaders.get(key);
            if (old instanceof String) {
                HashSet<Object> newEntry = new HashSet<Object>();
                newEntry.add(old);
                newEntry.add(value);
                this.fHeaders.put(key, newEntry);
            } else {
                ((HashSet)old).add(value);
            }
        } else {
            this.fHeaders.put(key, value);
        }
    }

    void setHeader(String key, String value) {
        this.fAssembledHeader = null;
        this.fHeaders.put(key, value);
    }

    public int getStatusCode() {
        return this.fStatusCode;
    }

    public String getMessage() {
        return this.fMessage;
    }

    public String getContentType() {
        return this.fContentType;
    }

    public String getHeader() {
        if (this.fAssembledHeader == null) {
            StringBuffer buf = new StringBuffer();
            for (Map.Entry entry : this.fHeaders.entrySet()) {
                String key = (String)entry.getKey();
                Object val = entry.getValue();
                if (val instanceof String) {
                    buf.append(key).append(": ").append((String)val).append('\n');
                    continue;
                }
                Iterator values = ((HashSet)val).iterator();
                while (values.hasNext()) {
                    buf.append(key).append(": ").append((String)values.next()).append('\n');
                }
            }
            this.fAssembledHeader = buf.toString();
        }
        return this.fAssembledHeader;
    }
}

